/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.statisticalmanager.dataspace;

import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.types.VOID;
import org.gcube.data.analysis.statisticalmanager.SMOperationStatus;
import org.gcube.data.analysis.statisticalmanager.SMOperationType;
import org.gcube.data.analysis.statisticalmanager.SMResourceType;
import org.gcube.data.analysis.statisticalmanager.ServiceContext;
import org.gcube.data.analysis.statisticalmanager.dataspace.exporter.CSVExporter;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.CSVImporter;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.OccurrenceStreamConverter;
import org.gcube.data.analysis.statisticalmanager.dataspace.importer.RSWrapper;
import org.gcube.data.analysis.statisticalmanager.exception.StatisticalManagerException;
import org.gcube.data.analysis.statisticalmanager.persistence.DataBaseManager;
import org.gcube.data.analysis.statisticalmanager.persistence.HibernateManager;
import org.gcube.data.analysis.statisticalmanager.persistence.SMPersistenceManager;
import org.gcube.data.analysis.statisticalmanager.stubs.DataSpacePortType;
import org.gcube.data.analysis.statisticalmanager.stubs.SMCreateTableFromCSVRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMCreateTableFromDataStreamRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMCreateTableRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMCreatedTablesRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMFiles;
import org.gcube.data.analysis.statisticalmanager.stubs.SMGetFilesRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMImporters;
import org.gcube.data.analysis.statisticalmanager.stubs.SMImportersRequest;
import org.gcube.data.analysis.statisticalmanager.stubs.SMResourceNotFoundFault;
import org.gcube.data.analysis.statisticalmanager.stubs.SMResources;
import org.gcube.data.analysis.statisticalmanager.stubs.SMTables;
import org.gcube.data.spd.model.OccurrencePoint;
import org.gcube.data.spd.model.binding.Bindings;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.delegates.PipedStream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.generators.Generator;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMFile;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMImport;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMResource;
import org.gcube_system.namespaces.data.analysis.statisticalmanager.types.SMTable;
import org.hibernate.Query;
import org.hibernate.classic.Session;

public class DataSpace
extends GCUBEPortType
implements DataSpacePortType {
    protected ServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public String getDBParameters(String string) throws RemoteException, GCUBEFault {
        String url = DataBaseManager.getUrlDB() + "?user=" + DataBaseManager.getUsername() + "&password=" + DataBaseManager.getPassword();
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SMImporters getImporters(SMImportersRequest request) throws RemoteException, GCUBEFault {
        Session session = HibernateManager.getSessionFactory().openSession();
        try {
            Query query = session.createQuery("select importer from SMImport  importer where importer.portalLogin like :name ");
            query.setParameter("name", (Object)(request.getUser() != null ? request.getUser() : "%"));
            List objects = query.list();
            SMImport[] importers = objects.toArray(new SMImport[objects.size()]);
            SMImporters sMImporters = new SMImporters(importers);
            return sMImporters;
        }
        finally {
            session.close();
        }
    }

    public long createTableFromDataStream(SMCreateTableFromDataStreamRequest request) throws RemoteException, GCUBEFault {
        try {
            long importerId = SMPersistenceManager.addImporter((SMCreateTableRequest)request);
            Stream genericRecords = Streams.convert((URI)URI.create(request.getRsLocator())).of(GenericRecord.class).withDefaults();
            Generator<GenericRecord, OccurrencePoint> generator = new Generator<GenericRecord, OccurrencePoint>(){

                public OccurrencePoint yield(GenericRecord element) {
                    try {
                        return (OccurrencePoint)Bindings.fromXml((String)((StringField)element.getField("result")).getPayload());
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            };
            PipedStream stream = Streams.pipe((Stream)genericRecords).through((Generator)generator);
            Thread th = new Thread((Stream)stream, request, importerId){
                final /* synthetic */ Stream val$stream;
                final /* synthetic */ SMCreateTableFromDataStreamRequest val$request;
                final /* synthetic */ long val$importerId;
                {
                    this.val$stream = stream;
                    this.val$request = sMCreateTableFromDataStreamRequest;
                    this.val$importerId = l;
                }

                @Override
                public void run() {
                    String resourceId = null;
                    try {
                        DataSpace.this.logger.debug((Object)"Init import from stream ");
                        OccurrenceStreamConverter converter = new OccurrenceStreamConverter(DataBaseManager.getDataSource(), (Stream<OccurrencePoint>)this.val$stream);
                        converter.run();
                        resourceId = converter.getTableName();
                        SMTable table = new SMTable(this.val$request.getTableType());
                        table.setResourceType(SMResourceType.TABULAR.ordinal());
                        table.setResourceId(resourceId);
                        table.setName(this.val$request.getTableName());
                        table.setDescription(this.val$request.getDescription());
                        table.setCreationDate(Calendar.getInstance());
                        table.setPortalLogin(this.val$request.getUser());
                        table.setProvenance(SMOperationType.IMPORTED.ordinal());
                        table.setOperationId(this.val$importerId);
                        SMPersistenceManager.addCreatedResource(this.val$importerId, (SMResource)table);
                    }
                    catch (Exception e) {
                        DataSpace.this.logger.debug((Object)"Error import stream ", (Throwable)e);
                        SMPersistenceManager.setOperationStatus(this.val$importerId, SMOperationStatus.FAILED);
                    }
                }
            };
            th.start();
            return importerId;
        }
        catch (Exception e) {
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
    }

    public long createTableFromCSV(final SMCreateTableFromCSVRequest request) throws RemoteException, GCUBEFault {
        try {
            final long importerId = SMPersistenceManager.addImporter((SMCreateTableRequest)request);
            this.logger.debug((Object)"retrieve file ");
            this.logger.debug((Object)("Locator :" + request.getRsLocator()));
            final File file = RSWrapper.getStreamFromLocator(new URI(request.getRsLocator()));
            this.logger.debug((Object)("File created " + file));
            Thread th = new Thread(){

                @Override
                public void run() {
                    try {
                        DataSpace.this.logger.debug((Object)"Init import ");
                        CSVImporter converter = new CSVImporter(file, request.isHasHeader(), request.getTableName(), request.getTableType(), request.getDelimiter(), request.getCommentChar());
                        String resourceId = converter.toTabularData();
                        DataSpace.this.logger.debug((Object)("Import completed with resource id " + resourceId));
                        SMTable table = new SMTable(request.getTableType());
                        table.setResourceType(SMResourceType.TABULAR.ordinal());
                        table.setResourceId(resourceId);
                        table.setName(request.getTableName());
                        table.setDescription(request.getDescription());
                        table.setCreationDate(Calendar.getInstance());
                        table.setPortalLogin(request.getUser());
                        table.setProvenance(SMOperationType.IMPORTED.ordinal());
                        table.setOperationId(importerId);
                        SMPersistenceManager.addCreatedResource((SMResource)table);
                        SMPersistenceManager.addCreatedResource(importerId, (SMResource)table);
                    }
                    catch (Exception e) {
                        DataSpace.this.logger.error((Object)"Import failed ", (Throwable)e);
                        SMPersistenceManager.setOperationStatus(importerId, SMOperationStatus.FAILED);
                    }
                }
            };
            th.start();
            return importerId;
        }
        catch (Exception e) {
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SMTables getTables(SMCreatedTablesRequest request) throws RemoteException, GCUBEFault {
        Session session = HibernateManager.getSessionFactory().openSession();
        try {
            Query query = session.createQuery("select table from SMTable table where (table.portalLogin like :name or table.portalLogin = null) and table.template like :template");
            query.setParameter("name", (Object)(request.getUser() != null ? request.getUser() : "%"));
            String template = request.getTemplate();
            query.setParameter("template", (Object)(template != null && !template.equals(TableTemplates.GENERIC) ? template : "%"));
            List objects = query.list();
            SMTable[] tables = objects.toArray(new SMTable[objects.size()]);
            SMTables sMTables = new SMTables(tables);
            return sMTables;
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SMImport getImporter(String importerId) throws RemoteException, GCUBEFault {
        Session session = HibernateManager.getSessionFactory().openSession();
        try {
            Query query = session.createQuery("select importer from SMImport  importer where importer.operationId = :operationId");
            query.setParameter("operationId", (Object)Long.valueOf(importerId));
            List objects = query.list();
            SMImport sMImport = (SMImport)objects.get(0);
            return sMImport;
        }
        finally {
            session.close();
        }
    }

    public VOID removeImporter(String operationId) throws RemoteException, GCUBEFault {
        SMPersistenceManager.removeImporter(Long.valueOf(operationId));
        return new VOID();
    }

    public SMResources getResources(SMCreatedTablesRequest request) throws RemoteException, GCUBEFault {
        List<SMResource> resources = SMPersistenceManager.getResources(request.getUser(), request.getTemplate());
        return new SMResources(resources.toArray(new SMResource[resources.size()]));
    }

    public VOID removeTable(String tableId) throws RemoteException, GCUBEFault {
        SMPersistenceManager.removeResource(tableId);
        return new VOID();
    }

    public String exportTable(String tableId) throws RemoteException, SMResourceNotFoundFault, GCUBEFault {
        File file = null;
        try {
            file = File.createTempFile("export", "csv");
            CSVExporter exporter = new CSVExporter(tableId, file);
            exporter.exporterToFile();
        }
        catch (SQLException e) {
            this.logger.error((Object)"Resource not retrieved ", (Throwable)e);
            throw new SMResourceNotFoundFault();
        }
        catch (StatisticalManagerException e) {
            this.logger.debug((Object)"Data base connection internal error ", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
        catch (IOException e) {
            this.logger.error((Object)"Temp file to export did not create", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
        try {
            RSWrapper rs = new RSWrapper(ServiceContext.getContext().getScope());
            rs.add(file);
            return rs.getLocator().toString();
        }
        catch (Exception e) {
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SMFiles getFiles(SMGetFilesRequest request) throws RemoteException, GCUBEFault {
        Session session = HibernateManager.getSessionFactory().openSession();
        try {
            Query query = session.createQuery("select file from SMFile file where (file.portalLogin like :name or file.portalLogin = null)");
            query.setParameter("name", (Object)(request.getUser() != null ? request.getUser() : "%"));
            List objects = query.list();
            SMFile[] files = objects.toArray(new SMFile[objects.size()]);
            SMFiles sMFiles = new SMFiles(files);
            return sMFiles;
        }
        finally {
            session.close();
        }
    }
}

