/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tml.proxies;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.Callback;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.data.tml.Utils;
import org.gcube.data.tml.proxies.AsyncTBinder;
import org.gcube.data.tml.proxies.BindRequest;
import org.gcube.data.tml.proxies.Binding;
import org.gcube.data.tml.proxies.TBinder;
import org.gcube.data.tml.stubs.TBinderStub;
import org.gcube.data.tml.stubs.Types;

public class DefaultTBinder
implements TBinder,
AsyncTBinder {
    private final AsyncProxyDelegate<TBinderStub> delegate;

    public DefaultTBinder(ProxyDelegate<TBinderStub> delegate) {
        this.delegate = new AsyncProxyDelegate(delegate);
    }

    @Override
    public List<Binding> bind(BindRequest parameters) {
        Utils.notNull("binding parameters", parameters);
        try {
            return (List)this.delegate.make(this.bindCall(parameters));
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    @Override
    public Future<List<Binding>> bindAsync(BindRequest parameters) {
        Utils.notNull("binding parameters", parameters);
        return this.delegate.makeAsync(this.bindCall(parameters));
    }

    @Override
    public Future<?> bindAsync(BindRequest parameters, Callback<List<Binding>> callback) throws RejectedExecutionException {
        Utils.notNull("binding parameters", parameters);
        Utils.notNull("callback", callback);
        return this.delegate.makeAsync(this.bindCall(parameters), callback);
    }

    private Call<TBinderStub, List<Binding>> bindCall(final BindRequest parameters) {
        return new Call<TBinderStub, List<Binding>>(){

            public List<Binding> call(TBinderStub endpoint) throws Exception {
                Types.BindingsHolder bindings = endpoint.bind(parameters);
                return bindings == null || bindings.bindings == null ? new ArrayList() : bindings.bindings;
            }
        };
    }
}

