package org.gcube.datatransformation.client.library.proxies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;

import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.datatransformation.client.library.exceptions.DTSException;
import org.gcube.datatransformation.client.library.stubs.DTSStub;
import org.gcube.datatransformation.client.library.beans.Types.TPAndTransformationUnit;
import org.gcube.datatransformation.client.library.beans.Types.*;
import org.gcube.common.clients.Call;

public class DTSCLDefaultProxy implements DTSCLProxyI {

	private final ProxyDelegate<DTSStub> delegate;

	public DTSCLDefaultProxy(ProxyDelegate<DTSStub> config) {
		this.delegate = config;
	}

	@Override
	public String transformData(final String inputType, final String inputValue, final Map<String, String> inputParams, final String outputType,
			final String outputValue, final Map<String, String> outputParams, final String mimeType, final Map<String, String> contentTypeParams,
			final boolean createReport) throws DTSException {
		Call<DTSStub, TransformDataResponse> call = new Call<DTSStub, TransformDataResponse>() {

			@Override
			public TransformDataResponse call(DTSStub endpoint) throws Exception {
				/* INPUT */
				TransformData request = new TransformData();
				Input input = new Input();
				input.inputType = inputType;
				input.inputValue = inputValue;

				ArrayList<Parameter> inputparameters = new ArrayList<Parameter>();
				for (Entry<String, String> param : inputParams.entrySet()) {
					Parameter inputparameter = new Parameter();
					inputparameter.name = param.getKey();
					inputparameter.value = param.getValue();
					inputparameters.add(inputparameter);
				}
				input.inputparameters = inputparameters;
				request.input = input;

				/* OUTPUT */
				Output output = new Output();
				output.outputType = outputType;
				output.outputValue = outputValue;
				ArrayList<Parameter> outputTypeParameters = new ArrayList<Parameter>();
				for (Entry<String, String> param : outputParams.entrySet()) {
					Parameter inputparameter = new Parameter();
					inputparameter.name = param.getKey();
					inputparameter.value = param.getValue();
					outputTypeParameters.add(inputparameter);
				}
				output.outputparameters = outputTypeParameters;
				request.output = output;

				/* TARGET CONTENT TYPE */
				ContentType targetContentType = new ContentType();
				targetContentType.mimeType = mimeType;
				ArrayList<Parameter> contentTypeParameters = new ArrayList<Parameter>();
				for (Entry<String, String> param : contentTypeParams.entrySet()) {
					Parameter contentTypeParams = new Parameter();
					contentTypeParams.name = param.getKey();
					contentTypeParams.value = param.getValue();
					inputparameters.add(contentTypeParams);
				}
				targetContentType.parameters = contentTypeParameters;

				request.targetContentType = targetContentType;

				request.createReport = createReport;

				return endpoint.transformData(request);
			}
		};

		TransformDataResponse transformDataResponse = null;
		try {
			transformDataResponse = delegate.make(call);
		} catch (Exception e) {
			throw new DTSException(e);
		}
		String output = transformDataResponse.output;

		return output;
	}

	@Override
	public String transformDataWithTransformationUnit(final String transformationProgramID, final String transformationUnitID,
			final Map<Entry<String, String>, Map<String, String>> inputs, final String outputType, final String outputValue,
			final Map<String, String> outputParams, final String mimeType, final Map<String, String> contentTypeParams,
			final Map<String, String> tProgramUnboundParameters, final boolean filterSources, final boolean createReport) {
		Call<DTSStub, TransformDataWithTransformationUnitResponse> call = new Call<DTSStub, TransformDataWithTransformationUnitResponse>() {

			@Override
			public TransformDataWithTransformationUnitResponse call(DTSStub endpoint) throws Exception {
				TransformDataWithTransformationUnit request = new TransformDataWithTransformationUnit();

				request.tpID = transformationProgramID;
				request.transformationUnitID = transformationUnitID;
				/* INPUT */
				ArrayList<Input> inputList = new ArrayList<Input>();
				for (Entry<Entry<String, String>, Map<String, String>> inputIter : inputs.entrySet()) {
					Input input = new Input();
					input.inputType = inputIter.getKey().getKey();
					input.inputValue = inputIter.getKey().getValue();
					ArrayList<Parameter> inputTypeParameters = new ArrayList<Parameter>();
					if (inputIter.getValue() != null)
						for (Entry<String, String> param : inputIter.getValue().entrySet()) {
							Parameter inputparameter = new Parameter();
							inputparameter.name = param.getKey();
							inputparameter.value = param.getValue();
							inputTypeParameters.add(inputparameter);
						}
					input.inputparameters = inputTypeParameters;

					inputList.add(input);
				}
				request.inputs = inputList;

				/* OUTPUT */
				Output output = new Output();
				output.outputType = outputType;
				output.outputValue = outputValue;
				ArrayList<Parameter> outputTypeParameters = new ArrayList<Parameter>();
				if (outputParams != null)
					for (Entry<String, String> param : outputParams.entrySet()) {
						Parameter outputparameter = new Parameter();
						outputparameter.name = param.getKey();
						outputparameter.value = param.getValue();
						outputTypeParameters.add(outputparameter);
					}
				output.outputparameters = outputTypeParameters;
				request.output = output;

				/* TARGET CONTENT TYPE */
				ContentType targetContentType = new ContentType();
				targetContentType.mimeType = mimeType;
				ArrayList<Parameter> contentTypeParameters = new ArrayList<Parameter>();
				Set<Entry<String, String>> contentParamSet = contentTypeParams.entrySet();
				for (Entry<String, String> param : contentParamSet) {
					Parameter contentTypeParameter = new Parameter();
					contentTypeParameter.name = param.getKey();
					contentTypeParameter.value = param.getValue();
					contentTypeParameters.add(contentTypeParameter);
				}
				targetContentType.parameters = contentTypeParameters;

				request.targetContentType = targetContentType;

				ArrayList<Parameter> tProgramUnboundParameterList = new ArrayList<Parameter>();
				for (Entry<String, String> param : tProgramUnboundParameters.entrySet()) {
					Parameter tProgramUnboundParameter = new Parameter();
					tProgramUnboundParameter.name = param.getKey();
					tProgramUnboundParameter.value = param.getValue();
					tProgramUnboundParameterList.add(tProgramUnboundParameter);
				}
				request.tProgramUnboundParameters= tProgramUnboundParameterList;

				request.filterSources = filterSources;
				request.createReport = createReport;

				return endpoint.transformDataWithTransformationUnit(request);
			}
		};

		try {
			TransformDataWithTransformationUnitResponse transformDataWithTransformationUnitResponse = delegate.make(call);
			String output = transformDataWithTransformationUnitResponse.output;

			return output;
		} catch (Exception e) {
			e.printStackTrace();
		}

		return null;
	}

	@Override
	public String transformDataWithTransformationProgram(final String transformationProgramID, final String inputType, final String inputValue,
			final Map<String, String> inputParams, final String outputType, final String outputValue, final Map<String, String> outputParams,
			final String mimeType, final Map<String, String> contentTypeParams, final Map<String, String> tProgramUnboundParameters, final boolean createReport) {
		Call<DTSStub, TransformDataWithTransformationProgramResponse> call = new Call<DTSStub, TransformDataWithTransformationProgramResponse>() {

			@Override
			public TransformDataWithTransformationProgramResponse call(DTSStub endpoint) throws Exception {
				TransformDataWithTransformationProgram request = new TransformDataWithTransformationProgram();

				request.tpID = transformationProgramID;

				/* INPUT */
				Input input = new Input();
				input.inputType = inputType;
				input.inputValue = inputValue;
				ArrayList<Parameter> inputTypeParameters = new ArrayList<Parameter>();
				for (Entry<String, String> param : inputParams.entrySet()) {
					Parameter inputparameter = new Parameter();
					inputparameter.name = param.getKey();
					inputparameter.value = param.getValue();
					inputTypeParameters.add(inputparameter);
				}
				input.inputparameters = inputTypeParameters;
				request.input = input;

				/* OUTPUT */
				Output output = new Output();
				output.outputType = outputType;
				output.outputValue  = outputValue;
				ArrayList<Parameter> outputTypeParameters = new ArrayList<Parameter>();
				for (Entry<String, String> param : outputParams.entrySet()) {
					Parameter outputparameter = new Parameter();
					outputparameter.name = param.getKey();
					outputparameter.value = param.getValue();
					outputTypeParameters.add(outputparameter);
				}
				output.outputparameters = outputTypeParameters;
				request.output  =output;

				/* TARGET CONTENT TYPE */
				ContentType targetContentType = new ContentType();
				targetContentType.mimeType = mimeType;
				ArrayList<Parameter> contentTypeParameters = new ArrayList<Parameter>();
				for (Entry<String, String> param : contentTypeParams.entrySet()) {
					Parameter contentTypeParameter = new Parameter();
					contentTypeParameter.name = param.getKey();
					contentTypeParameter.value = param.getValue();
					contentTypeParameters.add(contentTypeParameter);
				}
				targetContentType.parameters = contentTypeParameters;

				request.targetContentType = targetContentType;

				ArrayList<Parameter> tProgramUnboundParameterList = new ArrayList<Parameter>();
				for (Entry<String, String> param : tProgramUnboundParameters.entrySet()) {
					Parameter tProgramUnboundParameter = new Parameter();
					tProgramUnboundParameter.name = param.getKey();
					tProgramUnboundParameter.value = param.getValue();
					tProgramUnboundParameterList.add(tProgramUnboundParameter);
				}
				request.tProgramUnboundParameters = tProgramUnboundParameterList;

				request.createReport = createReport;

				return endpoint.transformDataWithTransformationProgram(request);
			}
		};

		try {
			TransformDataWithTransformationProgramResponse transformDataWithTransformationProgramResponse = delegate.make(call);
			String output = transformDataWithTransformationProgramResponse.output;

			return output;
		} catch (Exception e) {
			e.printStackTrace();
		}

		return null;
	}

	@Override
	public Map<String, String> findApplicableTransformationUnits(final String sourceMimeType, final Map<String, String> sourceContentTypeParams,
			final String targetMimeType, final Map<String, String> targetContentTypeParams, final boolean createAndPublishCompositeTP) {
		Call<DTSStub, FindApplicableTransformationUnitsResponse> call = new Call<DTSStub, FindApplicableTransformationUnitsResponse>() {

			@Override
			public FindApplicableTransformationUnitsResponse call(DTSStub endpoint) throws Exception {
				FindApplicableTransformationUnits request = new FindApplicableTransformationUnits();

				/* SOURCE CONTENT TYPE */
				ContentType sourceContentType = new ContentType();
				sourceContentType.mimeType = sourceMimeType;
				ArrayList<Parameter> sourceContentTypeParameterList = new ArrayList<Parameter>();
				if (sourceContentTypeParams != null)
					for (Entry<String, String> param : sourceContentTypeParams.entrySet()) {
						Parameter contentTypeParameter = new Parameter();
						contentTypeParameter.name = param.getKey();
						contentTypeParameter.value = param.getValue();
						sourceContentTypeParameterList.add(contentTypeParameter);
					}
				sourceContentType.parameters = sourceContentTypeParameterList;

				request.sourceContentType = sourceContentType;

				/* TARGET CONTENT TYPE */
				ContentType targetContentType = new ContentType();
				targetContentType.mimeType = targetMimeType;
				ArrayList<Parameter> targetContentTypeParameterList = new ArrayList<Parameter>();
				if (targetContentTypeParams != null) {
					for (Entry<String, String> param : targetContentTypeParams.entrySet()) {
						Parameter contentTypeParameter = new Parameter();
						contentTypeParameter.name = param.getKey();
						contentTypeParameter.value = param.getValue();
						targetContentTypeParameterList.add(contentTypeParameter);
					}
				} else {
					
				}
				targetContentType.parameters = targetContentTypeParameterList;

				request.targetContentType = targetContentType;

				request.createAndPublishCompositeTP = createAndPublishCompositeTP;

				return endpoint.findApplicableTransformationUnits(request);
			}
		};

		try {
			FindApplicableTransformationUnitsResponse findApplicableTransformationUnitsResponse = delegate.make(call);
			List<TPAndTransformationUnit> tpAndTransformationUnit = findApplicableTransformationUnitsResponse.TPAndTransformationUnitIDs;

			Map<String, String> output = new HashMap<String, String>();
			for (TPAndTransformationUnit iter : tpAndTransformationUnit) {
				output.put(iter.transformationProgramID, iter.transformationUnitID);
			}
			return output;
		} catch (Exception e) {
			e.printStackTrace();
		}

		return null;
	}

	@Override
	public String queryTransformationPrograms(final String query) {
		Call<DTSStub, String> call = new Call<DTSStub, String>() {

			@Override
			public String call(DTSStub endpoint) throws Exception {
				return endpoint.queryTransformationPrograms(query);
			}
		};

		try {
			String response = delegate.make(call);
			
			return response;
		} catch (Exception e) {
			e.printStackTrace();
		}

		return null;
	}
}
