/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.models.security;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.fao.vrmf.core.behaviours.security.User;
import org.fao.vrmf.core.extensions.collections.impl.SerializableTreeSet;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;
import org.fao.vrmf.core.models.data.GenericData;
import org.fao.vrmf.core.models.security.UserCapability;
import org.fao.vrmf.core.models.security.UserRole;

@XmlRootElement(name="BasicUser")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BasicUser
extends GenericData
implements User {
    private static final long serialVersionUID = 4604614209712279587L;
    @XmlElement(name="id")
    private String _id = null;
    @XmlElementWrapper(name="UserRoles")
    @XmlElement(name="UserRole")
    private Set<UserRole> _roles = new SerializableTreeSet<UserRole>(new UserRoleComparator());
    @XmlElementWrapper(name="UserCapabilities")
    @XmlElement(name="UserCapability")
    private Set<UserCapability> _capabilities = new SerializableTreeSet<UserCapability>(new UserCapabilityComparator());

    public BasicUser() {
    }

    public BasicUser(String id) {
        this._id = id;
    }

    public BasicUser(String id, Collection<UserRole> roles, Collection<UserCapability> capabilities) {
        this._id = id;
        if (roles != null) {
            this._roles = new SerializableTreeSet<UserRole>(roles);
        }
        if (capabilities != null) {
            this._capabilities = new SerializableTreeSet<UserCapability>(capabilities);
        }
    }

    @Override
    public final String getId() {
        return this._id;
    }

    public final void setId(String id) {
        this._id = id;
    }

    public final void addRole(UserRole role) {
        if (role != null) {
            this._roles.add(role);
            this.addCapabilities(role.getCapabilities());
        }
    }

    public final void addRoles(UserRole ... roles) {
        if (roles != null) {
            UserRole[] userRoleArray = roles;
            int n = roles.length;
            int n2 = 0;
            while (n2 < n) {
                UserRole role = userRoleArray[n2];
                this.addRole(role);
                ++n2;
            }
        }
    }

    public final void addRoles(Collection<UserRole> roles) {
        if (roles != null) {
            this.addRoles(roles.toArray(new UserRole[roles.size()]));
        }
    }

    public final void addCapability(UserCapability capability) {
        if (capability != null) {
            this._capabilities.add(capability);
        }
    }

    public final void addCapabilities(UserCapability ... capabilities) {
        if (capabilities != null) {
            UserCapability[] userCapabilityArray = capabilities;
            int n = capabilities.length;
            int n2 = 0;
            while (n2 < n) {
                UserCapability capability = userCapabilityArray[n2];
                this.addCapability(capability);
                ++n2;
            }
        }
    }

    public final void addCapabilities(Collection<UserCapability> capabilities) {
        if (capabilities != null) {
            this.addCapabilities(capabilities.toArray(new UserCapability[capabilities.size()]));
        }
    }

    public Set<UserRole> getRoles() {
        return this._roles;
    }

    public void setRoles(Set<UserRole> roles) {
        this._roles = roles;
    }

    public Set<UserCapability> getCapabilities() {
        return this._capabilities;
    }

    public void setCapabilities(Set<UserCapability> capabilities) {
        this._capabilities = capabilities;
    }

    @Override
    public final boolean is(String ... roles) {
        boolean is;
        boolean bl = is = this._roles.size() > 0;
        if (is) {
            String[] stringArray = roles;
            int n = roles.length;
            int n2 = 0;
            while (n2 < n) {
                String role = stringArray[n2];
                boolean currentIs = false;
                for (UserRole userRole : this._roles) {
                    if (currentIs |= userRole.getRole().equals(role) || this.check(userRole.getRole(), role) || this.check(role, userRole.getRole())) break;
                }
                if (!(is &= currentIs)) break;
                ++n2;
            }
        }
        return is;
    }

    @Override
    public final boolean is(UserRole ... roles) {
        String[] rolesArray = new String[roles.length];
        int counter = 0;
        UserRole[] userRoleArray = roles;
        int n = roles.length;
        int n2 = 0;
        while (n2 < n) {
            UserRole role = userRoleArray[n2];
            rolesArray[counter++] = role.getRole();
            ++n2;
        }
        return this.is(rolesArray);
    }

    @Override
    public final boolean can(String ... capabilities) {
        boolean can = true;
        String[] stringArray = capabilities;
        int n = capabilities.length;
        int n2 = 0;
        while (n2 < n) {
            String capability = stringArray[n2];
            if (!(can &= this.lazyCan(capability))) break;
            ++n2;
        }
        return can;
    }

    @Override
    public final boolean can(UserCapability ... capabilities) {
        String[] capabilitiesArray = new String[capabilities.length];
        int counter = 0;
        UserCapability[] userCapabilityArray = capabilities;
        int n = capabilities.length;
        int n2 = 0;
        while (n2 < n) {
            UserCapability capability = userCapabilityArray[n2];
            capabilitiesArray[counter++] = capability.getCapabilityName();
            ++n2;
        }
        return this.can(capabilitiesArray);
    }

    @Override
    public final UserCapability getCapability(String capabilityID) {
        assert (StringUtils.isNotNullAndNonEmpty(capabilityID));
        if (this._capabilities != null && !this._capabilities.isEmpty()) {
            for (UserCapability current : this._capabilities) {
                if (!capabilityID.equals(current.getCapabilityName())) continue;
                return current;
            }
        }
        return null;
    }

    @Override
    public final UserCapability getCapability(UserCapability capability) {
        assert (capability != null && StringUtils.isNotNullAndNonEmpty(capability.getCapabilityName()));
        return this.getCapability(capability.getCapabilityName());
    }

    @Override
    public final Collection<UserCapability> getCapabilities(String capabilityPattern) {
        assert (StringUtils.isNotNullAndNonEmpty(capabilityPattern));
        HashSet<UserCapability> capabilities = new HashSet<UserCapability>();
        if (this._capabilities != null && !this._capabilities.isEmpty()) {
            for (UserCapability current : this._capabilities) {
                if (!this.check(capabilityPattern, current.getCapabilityName()) && !this.check(current.getCapabilityName(), capabilityPattern)) continue;
                capabilities.add(current);
            }
        }
        return capabilities;
    }

    private boolean lazyCan(String capability) {
        boolean can = false;
        if (this._capabilities.size() > 0) {
            for (UserCapability userCapability : this._capabilities) {
                if (can |= this.check(capability, userCapability.getCapabilityName()) || this.check(userCapability.getCapabilityName(), capability)) break;
            }
        }
        return can;
    }

    private boolean check(String pattern, String value) {
        return Pattern.matches(value.replaceAll("\\.", "\\\\.").replaceAll("\\?", ".").replaceAll("\\*", ".*"), pattern);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this._capabilities == null ? 0 : this._capabilities.hashCode());
        result = 31 * result + (this._id == null ? 0 : this._id.hashCode());
        result = 31 * result + (this._roles == null ? 0 : this._roles.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicUser other = (BasicUser)obj;
        if (this._capabilities == null ? other._capabilities != null : !this._capabilities.equals(other._capabilities)) {
            return false;
        }
        if (this._id == null ? other._id != null : !this._id.equals(other._id)) {
            return false;
        }
        return !(this._roles == null ? other._roles != null : !this._roles.equals(other._roles));
    }

    private static final class UserCapabilityComparator
    implements Comparator<UserCapability>,
    Serializable {
        private static final long serialVersionUID = 2999586710288981653L;

        private UserCapabilityComparator() {
        }

        @Override
        public int compare(UserCapability o1, UserCapability o2) {
            return o1.getCapabilityName().compareTo(o2.getCapabilityName());
        }
    }

    private static final class UserRoleComparator
    implements Comparator<UserRole>,
    Serializable {
        private static final long serialVersionUID = 3977840366677543533L;

        private UserRoleComparator() {
        }

        @Override
        public int compare(UserRole o1, UserRole o2) {
            return o1.getRole().compareTo(o2.getRole());
        }
    }
}

