/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.comet.core.patterns.data.providers.impl.basic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.fao.fi.comet.core.patterns.data.providers.DataProvider;
import org.fao.fi.comet.core.patterns.data.providers.FeedableSizeAwareDataProvider;
import org.fao.fi.comet.core.patterns.data.providers.ProvidedData;
import org.fao.fi.comet.core.patterns.data.providers.impl.DataProviderSkeleton;
import org.fao.vrmf.core.helpers.singletons.lang.AssertionUtils;

public class CollectionBackedDataProvider<ENTITY extends Serializable>
extends DataProviderSkeleton<ENTITY>
implements FeedableSizeAwareDataProvider<ENTITY> {
    private Collection<ProvidedData<ENTITY>> _backingCollection;

    public CollectionBackedDataProvider() {
        this._backingCollection = new ArrayList<ProvidedData<ENTITY>>();
    }

    public CollectionBackedDataProvider(String providerID) {
        super(providerID);
        this._backingCollection = new ArrayList<ProvidedData<ENTITY>>();
    }

    public CollectionBackedDataProvider(Collection<ENTITY> data) {
        AssertionUtils.$nNull(data, "Data cannot be NULL", new Object[0]);
        this.setData(data);
    }

    public CollectionBackedDataProvider(String providerID, Collection<ENTITY> data) {
        this(providerID);
        AssertionUtils.$nNull(data, "Data cannot be NULL", new Object[0]);
        this.setData(data);
    }

    public CollectionBackedDataProvider(String providerID, DataProvider<ENTITY> provider) {
        this(providerID);
        AssertionUtils.$nNull(provider, "Data provider cannot be NULL", new Object[0]);
        ArrayList data = new ArrayList();
        for (ProvidedData providedData : provider) {
            data.add(providedData.getData());
        }
        this.setData(data);
    }

    public CollectionBackedDataProvider(DataProvider<ENTITY> provider) {
        this();
        AssertionUtils.$nNull(provider, "Data provider cannot be NULL", new Object[0]);
        this.setProviderID(provider.getProviderID());
        ArrayList data = new ArrayList();
        for (ProvidedData providedData : provider) {
            data.add(providedData.getData());
        }
        this.setData(data);
    }

    protected final void setData(Collection<ENTITY> data) {
        AssertionUtils.$nNull(data, "Data cannot be NULL", new Object[0]);
        this._backingCollection = new ArrayList<ProvidedData<ENTITY>>();
        for (Serializable currentData : data) {
            this._backingCollection.add(new ProvidedData<Serializable>(this.getProviderID(), currentData));
        }
    }

    @Override
    public Iterator<ProvidedData<ENTITY>> iterator() {
        CollectionBackedDataProvider $this = this;
        return new Iterator<ProvidedData<ENTITY>>($this){
            private final Iterator<ProvidedData<ENTITY>> _realIterator;
            {
                this._realIterator = collectionBackedDataProvider2._backingCollection.iterator();
            }

            @Override
            public boolean hasNext() {
                return this._realIterator.hasNext();
            }

            @Override
            public ProvidedData<ENTITY> next() {
                return this._realIterator.next();
            }

            @Override
            public void remove() {
                this._realIterator.remove();
            }
        };
    }

    @Override
    public void addData(ProvidedData<ENTITY> toAdd) {
        this._backingCollection.add(toAdd);
    }

    @Override
    public int getAvailableDataSize() {
        return this._backingCollection.size();
    }

    @Override
    protected final void doReleaseResources() throws Exception {
    }
}

