/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.extensions.date;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class SmartDate
extends Date {
    private static final long serialVersionUID = -1220613780110603127L;
    static final int MONTHS_IN_YEAR = 12;

    public SmartDate() {
    }

    public SmartDate(Date originalDate) {
        super(originalDate.getTime());
    }

    public SmartDate(Calendar originalDate) {
        super(originalDate.getTimeInMillis());
    }

    public SmartDate(long originalDateTimestamp) {
        super(originalDateTimestamp);
    }

    public Date asDate() {
        return new Date(this.getTime());
    }

    public Calendar asCalendar() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(this.getTime());
        return calendar;
    }

    private SmartDate roundTo(int timeUnit) {
        GregorianCalendar rounded = new GregorianCalendar();
        rounded.setTime(this);
        switch (timeUnit) {
            case 1: 
            case 2: {
                rounded.set(5, 1);
            }
            case 5: {
                rounded.set(11, 0);
                rounded.set(12, 0);
                rounded.set(13, 0);
                rounded.set(14, 0);
                break;
            }
            default: {
                assert (false) : "You must provide a valid time unit code";
                break;
            }
        }
        this.setTime(rounded.getTimeInMillis());
        return this;
    }

    public SmartDate roundToDay() {
        return this.roundTo(5);
    }

    public SmartDate roundToMonth() {
        return this.roundTo(2);
    }

    public SmartDate roundToYear() {
        return this.roundTo(1);
    }

    public int differenceInDays(SmartDate dateTo) {
        assert (dateTo != null) : "Provided 'to' date cannot be null";
        boolean swap = this.after(dateTo);
        if (swap) {
            return -1 * SmartDate.differenceInDays(dateTo, this);
        }
        return SmartDate.differenceInDays(this, dateTo);
    }

    public int differenceInDays(Date dateTo) {
        return this.differenceInDays(dateTo == null ? null : new SmartDate(dateTo));
    }

    public int differenceInDays(Calendar dateTo) {
        return this.differenceInDays(dateTo == null ? null : new SmartDate(dateTo));
    }

    public int differenceInMonths(SmartDate dateTo) {
        assert (dateTo != null) : "Provided 'to' date cannot be null";
        GregorianCalendar calendarFrom = new GregorianCalendar();
        calendarFrom.setTime(new SmartDate(this).roundToMonth());
        GregorianCalendar calendarTo = new GregorianCalendar();
        calendarTo.setTime(new SmartDate(dateTo).roundToMonth());
        if (calendarFrom.getTime().compareTo(calendarTo.getTime()) == 0) {
            return 0;
        }
        int yDifference = calendarTo.get(1) - calendarFrom.get(1);
        int mDifference = calendarTo.get(2) - calendarFrom.get(2);
        return yDifference * 12 + mDifference;
    }

    public int differenceInMonth(Date dateTo) {
        return this.differenceInMonths(dateTo == null ? null : new SmartDate(dateTo));
    }

    public int differenceInMonth(Calendar dateTo) {
        return this.differenceInMonths(dateTo == null ? null : new SmartDate(dateTo));
    }

    public int differenceInYears(SmartDate dateTo) {
        assert (dateTo != null) : "Provided 'to' date cannot be null";
        GregorianCalendar calendarFrom = new GregorianCalendar();
        calendarFrom.setTime(this);
        GregorianCalendar calendarTo = new GregorianCalendar();
        calendarTo.setTime(dateTo);
        return calendarTo.get(1) - calendarFrom.get(1);
    }

    public int differenceInYears(Date dateTo) {
        return this.differenceInYears(dateTo == null ? null : new SmartDate(dateTo));
    }

    public int differenceInYears(Calendar dateTo) {
        return this.differenceInYears(dateTo == null ? null : new SmartDate(dateTo));
    }

    public int dateDifference(SmartDate dateTo, int timeUnit) {
        switch (timeUnit) {
            case 5: {
                return this.differenceInDays(dateTo);
            }
            case 2: {
                return this.differenceInMonths(dateTo);
            }
            case 1: {
                return this.differenceInYears(dateTo);
            }
        }
        assert (false) : "You shall provide a valid time unit code";
        return Integer.MIN_VALUE;
    }

    public int dateDifference(Date dateTo, int timeUnit) {
        return this.dateDifference(dateTo == null ? null : new SmartDate(dateTo), timeUnit);
    }

    public int dateDifference(Calendar dateTo, int timeUnit) {
        return this.dateDifference(dateTo == null ? null : new SmartDate(dateTo), timeUnit);
    }

    public SmartDate rollUpDays(long days) {
        assert (days >= 0L) : "Days to roll must be >= 0";
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this);
        int n = 0;
        while ((long)n < days) {
            if (calendar.get(5) == ((Calendar)calendar).getActualMaximum(5)) {
                switch (calendar.get(2)) {
                    case 11: {
                        ((Calendar)calendar).roll(1, true);
                        break;
                    }
                }
                ((Calendar)calendar).roll(5, true);
                ((Calendar)calendar).roll(2, true);
            } else {
                ((Calendar)calendar).roll(5, true);
            }
            ++n;
        }
        this.setTime(calendar.getTimeInMillis());
        return this;
    }

    public SmartDate rollUpMonths(long months) {
        assert (months >= 0L) : "Months to roll must be >= 0";
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this);
        int initialDayOfMonth = calendar.get(5);
        int n = 0;
        while ((long)n < months) {
            if (calendar.get(2) == 11) {
                ((Calendar)calendar).roll(1, true);
            }
            ((Calendar)calendar).roll(2, true);
            ++n;
        }
        int finalDayOfMonth = calendar.get(5);
        int maxDayOfMonth = ((Calendar)calendar).getActualMaximum(5);
        if (finalDayOfMonth != initialDayOfMonth) {
            if (initialDayOfMonth <= maxDayOfMonth) {
                calendar.set(5, initialDayOfMonth);
            } else {
                calendar.set(5, maxDayOfMonth);
            }
        }
        this.setTime(calendar.getTimeInMillis());
        return this;
    }

    public SmartDate rollUpYears(long years) {
        assert (years >= 0L) : "Years to roll must be >= 0";
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this);
        int n = 0;
        while ((long)n < years) {
            ((Calendar)calendar).roll(1, true);
            ++n;
        }
        this.setTime(calendar.getTimeInMillis());
        return this;
    }

    public SmartDate rollDownDays(long days) {
        assert (days >= 0L) : "Days to roll must be >= 0";
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this);
        int n = 0;
        while ((long)n < days) {
            if (calendar.get(5) == ((Calendar)calendar).getActualMinimum(5)) {
                switch (calendar.get(2)) {
                    case 0: {
                        ((Calendar)calendar).roll(1, false);
                        break;
                    }
                }
                ((Calendar)calendar).roll(2, false);
                ((Calendar)calendar).roll(5, false);
            } else {
                ((Calendar)calendar).roll(5, false);
            }
            ++n;
        }
        this.setTime(calendar.getTimeInMillis());
        return this;
    }

    public SmartDate rollDownMonths(long months) {
        assert (months >= 0L) : "Months to roll must be >= 0";
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this);
        int initialDayOfMonth = calendar.get(5);
        int n = 0;
        while ((long)n < months) {
            if (calendar.get(2) == 0) {
                ((Calendar)calendar).roll(1, false);
            }
            ((Calendar)calendar).roll(2, false);
            ++n;
        }
        int finalDayOfMonth = calendar.get(5);
        int maxDayOfMonth = ((Calendar)calendar).getActualMaximum(5);
        if (finalDayOfMonth != initialDayOfMonth) {
            if (initialDayOfMonth <= maxDayOfMonth) {
                calendar.set(5, initialDayOfMonth);
            } else {
                calendar.set(5, maxDayOfMonth);
            }
        }
        this.setTime(calendar.getTimeInMillis());
        return this;
    }

    public SmartDate rollDownYears(long years) {
        assert (years >= 0L) : "Years to roll must be >= 0";
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this);
        int n = 0;
        while ((long)n < years) {
            ((Calendar)calendar).roll(1, false);
            ++n;
        }
        this.setTime(calendar.getTimeInMillis());
        return this;
    }

    private static int differenceInDays(SmartDate from, SmartDate to) {
        SmartDate cloned = new SmartDate(from);
        GregorianCalendar calendarFrom = new GregorianCalendar();
        calendarFrom.setTime(new SmartDate(cloned).roundToDay());
        GregorianCalendar calendarTo = new GregorianCalendar();
        calendarTo.setTime(new SmartDate(to).roundToDay());
        int numberOfDays = 0;
        while (calendarFrom.before(calendarTo)) {
            calendarFrom.setTime(cloned.rollUpDays(1L));
            ++numberOfDays;
        }
        return numberOfDays;
    }
}

