/*
 * Decompiled with CFR 0.152.
 */
package org.fao.vrmf.core.helpers.singletons.text.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.fao.vrmf.core.helpers.singletons.AbstractHelperSingleton;
import org.fao.vrmf.core.helpers.singletons.text.StringUtils;
import org.fao.vrmf.core.impl.design.patterns.pair.NameValuePair;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLBuilderUtils
extends AbstractHelperSingleton {
    private static DocumentBuilder DOCUMENT_BUILDER;

    static {
        try {
            DOCUMENT_BUILDER = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Throwable t) {
            XMLBuilderUtils.getLogger().error("Unable to initialize XML document builder", t);
        }
    }

    private XMLBuilderUtils() {
    }

    public static String comment(String comment) {
        return "<!-- " + comment + " -->\n";
    }

    public static String open(Class<?> tag) {
        return XMLBuilderUtils.open(tag.getSimpleName());
    }

    public static String open(String tag) {
        return "<" + tag + ">\n";
    }

    public static String open(String tag, NameValuePair attribute) {
        return XMLBuilderUtils.open(tag, new NameValuePair[]{attribute});
    }

    public static String open(String tag, NameValuePair ... attributes) {
        StringBuilder result = new StringBuilder("<").append(tag);
        Serializable value = null;
        if (attributes != null && attributes.length > 0) {
            NameValuePair[] nameValuePairArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                NameValuePair attribute = nameValuePairArray[n2];
                if (StringUtils.rawTrim(attribute.getName()) != null && (value = attribute.getValue()) != null) {
                    result.append(" ").append(StringUtils.rawTrim(attribute.getName())).append("=\"");
                    result.append(value.toString().replaceAll("\\n|\\t|\\r", "").replaceAll("\\\"", "\\\\\""));
                    result.append("\"");
                }
                ++n2;
            }
        }
        result.append(">\n");
        return result.toString();
    }

    public static String open(String tag, Map<String, Serializable> attributes) {
        ArrayList<NameValuePair> asList = new ArrayList<NameValuePair>();
        ArrayList<String> sortedKeys = attributes != null && !attributes.isEmpty() ? new ArrayList<String>(attributes.keySet()) : new ArrayList<String>();
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            asList.add(new NameValuePair(key, attributes.get(key)));
        }
        return XMLBuilderUtils.open(tag, asList.toArray(new NameValuePair[0]));
    }

    public static String close(Class<?> tag) {
        return XMLBuilderUtils.close(tag.getSimpleName());
    }

    public static String close(String tag) {
        return "</" + tag + ">\n";
    }

    public static String cdata(String content) {
        if (content == null) {
            return "";
        }
        return "<![CDATA[" + content + "]]>\n";
    }

    public static String text(String content) {
        return content == null ? "" : String.valueOf(content) + "\n";
    }

    public static Document convertToDocument(String XML) throws SAXException, IOException {
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(XML));
        return XMLBuilderUtils.removeEmptyTextNodes(DOCUMENT_BUILDER.parse(is));
    }

    public static Document convertToDocument(File XMLFile) throws SAXException, IOException {
        return XMLBuilderUtils.removeEmptyTextNodes(DOCUMENT_BUILDER.parse(XMLFile));
    }

    public static Document convertToDocument(InputStream XMLStream) throws SAXException, IOException {
        return XMLBuilderUtils.removeEmptyTextNodes(DOCUMENT_BUILDER.parse(XMLStream));
    }

    public static Document removeEmptyTextNodes(Document root) {
        if (root != null) {
            XMLBuilderUtils.removeEmptyTextNodes((Node)root);
            NodeList children = root.getChildNodes();
            int c = 0;
            while (c < children.getLength()) {
                XMLBuilderUtils.removeEmptyTextNodes(children.item(c));
                ++c;
            }
        }
        return root;
    }

    public static Node removeEmptyTextNodes(Node node) {
        NodeList children;
        if (node != null && (children = node.getChildNodes()) != null && children.getLength() > 0) {
            int c = 0;
            while (c < children.getLength()) {
                Node child = children.item(c);
                if (child.getNodeType() == 3) {
                    String text = child.getTextContent();
                    String string = text = text == null ? null : text.replaceAll("\\r|\\n", "");
                    if (text == null || "".equals(text)) {
                        XMLBuilderUtils.getLogger().debug("Removing empty text node from " + node.getNodeName());
                        node.removeChild(child);
                    }
                } else {
                    XMLBuilderUtils.removeEmptyTextNodes(child);
                }
                ++c;
            }
        }
        return node;
    }

    public static Node getFirstChildByName(Node parent, String name) {
        if (parent == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        if (children == null || children.getLength() == 0) {
            return null;
        }
        int n = 0;
        while (n < children.getLength()) {
            Node child = children.item(n);
            if (child.getNodeType() == 1 && name.equalsIgnoreCase(child.getNodeName())) {
                return child;
            }
            ++n;
        }
        return null;
    }

    public static Collection<Node> filterChildrenByName(Node parent, String name) {
        if (parent == null) {
            return null;
        }
        if (name == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        ArrayList<Node> toReturn = new ArrayList<Node>();
        if (children != null && children.getLength() > 0) {
            int n = 0;
            while (n < children.getLength()) {
                Node child = children.item(n);
                if (child.getNodeType() == 1 && name.equalsIgnoreCase(child.getNodeName())) {
                    toReturn.add(child);
                }
                ++n;
            }
        }
        return toReturn;
    }

    public static String prettyPrint(Document xml) {
        DOMImplementation domImplementation = xml.getImplementation();
        if (domImplementation.hasFeature("LS", "3.0") && domImplementation.hasFeature("Core", "2.0")) {
            DOMImplementationLS domImplementationLS = (DOMImplementationLS)domImplementation.getFeature("LS", "3.0");
            LSSerializer lsSerializer = domImplementationLS.createLSSerializer();
            DOMConfiguration domConfiguration = lsSerializer.getDomConfig();
            if (domConfiguration.canSetParameter("format-pretty-print", Boolean.TRUE)) {
                lsSerializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
                LSOutput lsOutput = domImplementationLS.createLSOutput();
                lsOutput.setEncoding("UTF-8");
                StringWriter stringWriter = new StringWriter();
                lsOutput.setCharacterStream(stringWriter);
                lsSerializer.write(xml, lsOutput);
                return stringWriter.toString();
            }
            throw new RuntimeException("DOMConfiguration 'format-pretty-print' parameter isn't settable.");
        }
        throw new RuntimeException("DOM 3.0 LS and/or DOM 2.0 Core not supported.");
    }

    public static String prettyPrint(String xml) {
        try {
            return xml == null ? null : XMLBuilderUtils.prettyPrint(XMLBuilderUtils.convertToDocument(xml.replaceAll("\\n", "")));
        }
        catch (Throwable t) {
            XMLBuilderUtils.getLogger(XMLBuilderUtils.class).error("Unable to pretty-print provided xml: returning its original form. Reason: " + t.getMessage(), t);
            return xml;
        }
    }

    public static boolean isCharValid(char character) {
        return character == '\t' || character == '\n' || character == '\r' || character >= ' ' && character <= '\ud7ff' || character >= '\ue000' && character <= '\ufffd' || character >= '\u10000' && character <= '\u10ffff';
    }

    public static boolean isStringValid(String string) {
        if (string == null) {
            return true;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char character = cArray[n2];
            if (!XMLBuilderUtils.isCharValid(character)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

