/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.viewmanager.state;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gcube.common.core.faults.GCUBERetryEquivalentException;
import org.gcube.common.core.plugins.GCUBEPluginManager;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.types.DescriptiveProperty;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.contentmanagement.viewmanager.context.ServiceContext;
import org.gcube.contentmanagement.viewmanager.context.ViewPTContext;
import org.gcube.contentmanagement.viewmanager.plugin.PluginContext;
import org.gcube.contentmanagement.viewmanager.plugin.delegate.ViewDelegate;
import org.gcube.contentmanagement.viewmanager.state.ViewResource;
import org.gcube.contentmanagement.viewmanager.stubs.PluginDescription;
import org.gcube.contentmanagement.viewmanager.stubs.model.View;
import org.globus.wsrf.ResourceProperty;

public class Factory
extends GCUBEWSResource {
    private Set<String> activationRecords = new HashSet<String>();
    private static String[] RPNames = new String[]{"Plugin"};

    protected void initialise(Object ... args) throws Exception, IllegalArgumentException {
        this.subscribeForPlugins();
    }

    void subscribeForPlugins() {
        this.logger.trace((Object)"subscribing for plugin events");
        ServiceContext.getContext().getPluginManager().subscribe(new PluginConsumer(), new GCUBEPluginManager.PluginTopic[0]);
    }

    public Set<String> getActivationRecords() {
        return this.activationRecords;
    }

    public void setActivationRecords(Set<String> activationRecords) {
        this.activationRecords = activationRecords;
    }

    public ViewResource create(String pluginName, View view) throws Exception {
        PluginContext pluginContext;
        if (pluginName == null) {
            pluginName = "DefaultVMPlugin";
        }
        if ((pluginContext = this.getContext(pluginName)) == null) {
            throw new GCUBERetryEquivalentException("plugin " + pluginName + " is unknown");
        }
        ViewDelegate delegate = pluginContext.getDelegate();
        ViewResource resource = (ViewResource)ViewPTContext.getContext().getWSHome().create(ViewPTContext.getContext().makeKey(view.getId()), new Object[]{delegate, view, pluginName});
        resource.store();
        return resource;
    }

    private synchronized void update(Map<String, PluginContext> plugins) {
        ResourceProperty typeRP = this.getResourcePropertySet().get("Plugin");
        typeRP.clear();
        for (PluginContext context : plugins.values()) {
            PluginDescription description = new PluginDescription();
            description.setName(context.getPlugin().getServiceName());
            description.setDescription(context.getPlugin().getDescription());
            description.setProperty(context.getProperties().values().toArray(new DescriptiveProperty[0]));
            typeRP.add((Object)description);
        }
    }

    public PluginContext getContext(String name) throws Exception {
        return (PluginContext)((Object)ServiceContext.getContext().getPluginManager().getPlugins().get(name));
    }

    public String[] getPropertyNames() {
        return RPNames;
    }

    private class PluginConsumer
    extends GCUBEPluginManager.PluginConsumer<PluginContext> {
        private PluginConsumer() {
        }

        public synchronized <T1 extends GCUBEPluginManager.PluginTopic, P1 extends PluginContext> void onEvent(GCUBEEvent<T1, P1> ... events) {
            Factory.this.update(ServiceContext.getContext().getPluginManager().getPlugins());
        }
    }
}

