/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.viewmanager.plugin.metadataplugin;

import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.stubs.calls.ReadManagerCall;
import org.gcube.contentmanagement.contentmanager.stubs.model.constraints.Constraint;
import org.gcube.contentmanagement.contentmanager.stubs.model.constraints.Constraints;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Calendar;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.EdgePredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicates;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.TreePredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Bindings;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Edge;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.GDoc;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.InnerNode;
import org.gcube.contentmanagement.contentmanager.stubs.model.trees.Leaf;
import org.gcube.contentmanagement.viewmanager.plugin.delegate.ViewDelegate;
import org.gcube.contentmanagement.viewmanager.plugin.metadataplugin.Delegate;
import org.gcube.contentmanagement.viewmanager.stubs.model.ViewProperty;

public class MetadataUpdateHandler
extends GCUBEHandler<ViewDelegate> {
    private GCUBELog logger = new GCUBELog(MetadataUpdateHandler.class);
    private TreePredicate metadataPredicate = null;
    private volatile ReadManagerCall readManagerCall = null;

    public void run() throws Exception {
        this.logger.trace((Object)("starting view updater handler for collection " + this.getId()));
        long start = System.currentTimeMillis();
        URI locator = this.getReadManager().get((Predicate)this.getMetadataPredicate());
        ForwardReader reader = new ForwardReader(locator);
        Iterator it = reader.iterator();
        long count = 0L;
        java.util.Calendar maxLastUpdate = null;
        while (it.hasNext()) {
            ++count;
            GenericRecord g = (GenericRecord)it.next();
            try {
                java.util.Calendar lastUpdate = this.getLastUpdateTime(Bindings.fromXML((Reader)new StringReader(((StringField)g.getField("payload")).getPayload())));
                if (maxLastUpdate == null) {
                    maxLastUpdate = lastUpdate;
                    continue;
                }
                if (!lastUpdate.after(maxLastUpdate)) continue;
                maxLastUpdate = lastUpdate;
            }
            catch (Exception e) {
                this.logger.warn((Object)"cannot evaluate last update", (Throwable)e);
            }
        }
        reader.close();
        this.logger.trace((Object)("count is " + count));
        this.logger.trace((Object)("maxLastUpdadate is " + maxLastUpdate));
        ((ViewDelegate)this.handled).getResource().getView().setCardinality(count);
        if (maxLastUpdate != null) {
            ((ViewDelegate)this.handled).getResource().getView().setLastUpdate(maxLastUpdate);
        }
        ((ViewDelegate)this.handled).getResource().store();
        this.logger.trace((Object)("gcube handler finished his work in " + (System.currentTimeMillis() - start) / 1000L));
    }

    private ReadManagerCall getReadManager() throws Exception {
        if (this.readManagerCall == null) {
            this.logger.trace((Object)"initializing the readManager");
            this.logger.trace((Object)("scope is " + (String)((ViewDelegate)this.handled).getResource().getResourcePropertySet().getScope().get(0)));
            this.logger.trace((Object)("the collection id is " + ((ViewDelegate)this.getHandled()).getResource().getView().getCollectionID()));
            this.readManagerCall = new ReadManagerCall(GCUBEScope.getScope((String)((String)((ViewDelegate)this.handled).getResource().getResourcePropertySet().getScope().get(0))), new GCUBESecurityManager[]{((ViewDelegate)this.handled).getResource().getServiceContext()});
            this.readManagerCall.setCollectionID(((ViewDelegate)this.getHandled()).getResource().getView().getCollectionID());
            this.logger.trace((Object)"finished initialization the readManager");
        }
        return this.readManagerCall;
    }

    private TreePredicate getMetadataPredicate() {
        if (this.metadataPredicate == null) {
            Map<QName, ViewProperty> properties = ((ViewDelegate)this.handled).getResource().getView().getProperties();
            String name = properties.get(Delegate.nameQName).getValue();
            String schema = properties.get(Delegate.schemaQName).getValue();
            String language = properties.get(Delegate.languageQName).getValue();
            this.metadataPredicate = Predicates.tree((EdgePredicate[])new EdgePredicate[]{Predicates.atleast((String)"isDescribedBy", (Predicate)Predicates.tree((EdgePredicate[])new EdgePredicate[]{Predicates.cond((EdgePredicate)Predicates.one((String)"schemaURI", (Predicate)Predicates.text((Constraint)Constraints.is((Object)schema)))), Predicates.cond((EdgePredicate)Predicates.one((String)"language", (Predicate)Predicates.text((Constraint)Constraints.is((Object)language)))), Predicates.cond((EdgePredicate)Predicates.one((String)"schemaName", (Predicate)Predicates.text((Constraint)Constraints.is((Object)name)))), Predicates.one((String)"lastUpdateTime", (Predicate)Predicates.date())}))});
        }
        return this.metadataPredicate;
    }

    private java.util.Calendar getLastUpdateTime(GDoc doc) throws ParseException {
        Leaf lastUpdateLeaf = (Leaf)((Edge)((InnerNode)((Edge)doc.edges("isDescribedBy").get(0)).target()).edges("lastUpdateTime").get(0)).target();
        java.util.Calendar lastUpdate = java.util.Calendar.getInstance();
        try {
            lastUpdate.setTime(Calendar.ISO8601formatter.parse(lastUpdateLeaf.value()));
        }
        catch (ParseException e1) {
            try {
                lastUpdate.setTime(Calendar.ISO8601shortFormatter.parse(lastUpdateLeaf.value()));
            }
            catch (ParseException e2) {
                lastUpdate.setTime(Calendar.ISO8601minFormatter.parse(lastUpdateLeaf.value()));
            }
        }
        return lastUpdate;
    }
}

