/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.viewmanager.plugin.metadataplugin;

import java.util.Map;
import javax.xml.namespace.QName;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.stubs.model.constraints.Constraint;
import org.gcube.contentmanagement.contentmanager.stubs.model.constraints.Constraints;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.EdgePredicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicate;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.Predicates;
import org.gcube.contentmanagement.contentmanager.stubs.model.predicates.TreePredicate;
import org.gcube.contentmanagement.viewmanager.consumer.UpdateConsumer;
import org.gcube.contentmanagement.viewmanager.context.ServiceContext;
import org.gcube.contentmanagement.viewmanager.plugin.delegate.ViewDelegate;
import org.gcube.contentmanagement.viewmanager.plugin.metadataplugin.MetadataUpdateHandler;
import org.gcube.contentmanagement.viewmanager.stubs.model.View;
import org.gcube.contentmanagement.viewmanager.stubs.model.ViewProperty;

public class Delegate
extends ViewDelegate {
    static final QName nameQName = new QName("schemaName");
    static final QName languageQName = new QName("language");
    static final QName schemaQName = new QName("schemaURI");
    private static final long serialVersionUID = 1L;
    private static GCUBELog logger = new GCUBELog(Delegate.class);

    @Override
    public void initialise(boolean isAtCreationTime) throws Exception {
        logger.trace((Object)"initializing the MetadataPlugin");
        View relatedView = this.getResource().getView();
        Map<QName, ViewProperty> properties = relatedView.getProperties();
        logger.trace((Object)("name is present?" + properties.containsKey(nameQName)));
        logger.trace((Object)("lng is present?" + properties.containsKey(languageQName)));
        logger.trace((Object)("schema is present?" + properties.containsKey(schemaQName)));
        if (!(properties.containsKey(nameQName) && properties.containsKey(languageQName) && properties.containsKey(schemaQName))) {
            logger.error((Object)"cannot initialize the delegate, some property hs not been set");
            throw new Exception("cannot initialize the delegate, properties not properly set");
        }
        relatedView.setPredicate(this.getMetadataFilter(properties.get(nameQName).getValue(), properties.get(schemaQName).getValue(), properties.get(languageQName).getValue()));
        if (isAtCreationTime) {
            final MetadataUpdateHandler handler = new MetadataUpdateHandler();
            handler.setHandled(this);
            ServiceContext.getContext().newServiceThread(new Runnable(){

                @Override
                public void run() {
                    logger.trace((Object)"starting the handler for the first update");
                    try {
                        boolean executionFinished = false;
                        int tries = 0;
                        while (!executionFinished && tries < 10) {
                            Thread.sleep(90000L);
                            try {
                                handler.run();
                                executionFinished = true;
                                logger.trace((Object)"execution for update finished with success");
                            }
                            catch (Exception e) {
                                ++tries;
                                logger.trace((Object)"execution for update failed retryeing in 90 secs");
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)"erorr in the first update, the collection exists?", (Throwable)e);
                    }
                }
            }).start();
        }
        this.registerForUpdate();
        logger.trace((Object)"initialization finished");
    }

    private TreePredicate getMetadataFilter(String name, String schema, String language) {
        return Predicates.tree((EdgePredicate[])new EdgePredicate[]{Predicates.atleast((String)"isDescribedBy", (Predicate)Predicates.tree((EdgePredicate[])new EdgePredicate[]{Predicates.cond((EdgePredicate)Predicates.one((String)"language", (Predicate)Predicates.text((Constraint)Constraints.is((Object)language)))), Predicates.cond((EdgePredicate)Predicates.one((String)"schemaName", (Predicate)Predicates.text((Constraint)Constraints.is((Object)name)))), Predicates.cond((EdgePredicate)Predicates.one((String)"schemaURI", (Predicate)Predicates.text((Constraint)Constraints.is((Object)schema))))}))});
    }

    @Override
    public void onLoad(boolean firstLoad) {
        logger.trace((Object)("on load called with firstload " + firstLoad));
        super.onLoad(firstLoad);
        if (firstLoad) {
            this.registerForUpdate();
        }
    }

    private void registerForUpdate() {
        MetadataUpdateHandler handler = new MetadataUpdateHandler();
        handler.setHandled(this);
        UpdateConsumer.getUpdateConsumer(GCUBEScope.getScope((String)((String)this.getResource().getResourcePropertySet().getScope().get(0)))).register(handler);
    }
}

