/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.viewmanager.context;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.xml.namespace.QName;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.informationsystem.notifier.ISNotifierException;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.contentmanagement.viewmanager.activationrecord.ActivationRecord;
import org.gcube.contentmanagement.viewmanager.activationrecord.ActivationRecordConsumer;
import org.gcube.contentmanagement.viewmanager.consumer.UpdateConsumer;
import org.gcube.contentmanagement.viewmanager.context.FactoryPTContext;
import org.gcube.contentmanagement.viewmanager.plugin.PluginManager;
import org.gcube.contentmanagement.viewmanager.plugin.annotationplugin.AnnotationPluginContext;
import org.gcube.contentmanagement.viewmanager.plugin.defaultplugin.PluginContext;
import org.gcube.contentmanagement.viewmanager.plugin.metadataplugin.MetadataPluginContext;
import org.gcube.contentmanagement.viewmanager.stubs.calls.Constants;

public class ServiceContext
extends GCUBEServiceContext {
    public static final long SCHEDULER_TIME = 172800L;
    private static ServiceContext cache = new ServiceContext();
    public List<ISNotifier.GCUBENotificationTopic> registeredNotficationTopic = new ArrayList<ISNotifier.GCUBENotificationTopic>();

    public static ServiceContext getContext() {
        return cache;
    }

    private ServiceContext() {
    }

    protected String getJNDIName() {
        return "gcube/contentmanagement/viewmanager";
    }

    public PluginManager getPluginManager() {
        return (PluginManager)super.getPluginManager();
    }

    protected void onReady() throws Exception {
        GCUBEService plugin;
        super.onReady();
        this.logger.trace((Object)"creating engine resources in all RI scopes");
        for (GCUBEScope scope : this.getInstance().getScopes().values()) {
            this.setScope(scope);
            FactoryPTContext.getContext().createFactory();
        }
        if (!this.getPluginManager().getPlugins().containsKey("DefaultVMPlugin")) {
            plugin = (GCUBEService)GHNContext.getImplementation(GCUBEService.class);
            plugin.load((Reader)new InputStreamReader(PluginContext.class.getResourceAsStream("profile.xml")));
            this.getPluginManager().registerPlugin(plugin, new boolean[0]);
        } else {
            this.logger.trace((Object)"default plugin already installed");
        }
        if (!this.getPluginManager().getPlugins().containsKey("MetadataPlugin")) {
            plugin = (GCUBEService)GHNContext.getImplementation(GCUBEService.class);
            plugin.load((Reader)new InputStreamReader(MetadataPluginContext.class.getResourceAsStream("profile.xml")));
            this.getPluginManager().registerPlugin(plugin, new boolean[0]);
        } else {
            this.logger.trace((Object)"metadata plugin already installed");
        }
        if (!this.getPluginManager().getPlugins().containsKey("AnnotationPlugin")) {
            plugin = (GCUBEService)GHNContext.getImplementation(GCUBEService.class);
            plugin.load((Reader)new InputStreamReader(AnnotationPluginContext.class.getResourceAsStream("profile.xml")));
            this.getPluginManager().registerPlugin(plugin, new boolean[0]);
        } else {
            this.logger.trace((Object)"annotation plugin already installed");
        }
        this.selfStage();
    }

    public Thread newServiceThread(Runnable r) {
        Thread t = new Thread(r);
        this.setScope(t, new GCUBEScope[0]);
        try {
            this.useCredentials(t, new SecurityCredentials[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return t;
    }

    protected void onShutdown() throws Exception {
        ISNotifier notifier = (ISNotifier)GHNContext.getImplementation(ISNotifier.class);
        for (GCUBEScope scope : this.getInstance().getScopes().values()) {
            try {
                notifier.unregisterFromISNotification((GCUBESecurityManager)this, this.registeredNotficationTopic, new GCUBEScope[]{scope});
            }
            catch (ISNotifierException ne) {}
        }
    }

    private void selfStage() throws Exception {
        ISNotifier notifier = (ISNotifier)GHNContext.getImplementation(ISNotifier.class);
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        ISNotifier.GCUBENotificationTopic notificationTopic = new ISNotifier.GCUBENotificationTopic(new QName("http://gcube-system.org/namespaces/informationsystem/registry", "GenericResource"));
        notificationTopic.setPrecondition("(//operationType[text()='destroy']) or (//profile[contains(.,'<SecondaryType>" + Constants.ACTIVATIONRECORD_TYPE + "</SecondaryType>') and contains(.,'<Name>" + Constants.ACTIVATIONRECORD_NAME + "</Name>')] and //operationType[text()='create'])");
        this.registeredNotficationTopic.add(notificationTopic);
        List<ISNotifier.GCUBENotificationTopic> arNotificationTopics = Collections.singletonList(notificationTopic);
        ISNotifier.GCUBENotificationTopic updateTopic = new ISNotifier.GCUBENotificationTopic(new QName("http://gcube-system.org/namespaces/contentmanagement/contentmanager", "UpdateTopic"));
        this.registeredNotficationTopic.add(updateTopic);
        List<ISNotifier.GCUBENotificationTopic> updateNotificationTopics = Collections.singletonList(updateTopic);
        for (GCUBEScope scope : this.getInstance().getScopes().values()) {
            this.logger.trace((Object)("looking for activation records in " + scope));
            GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
            String thisServiceCondition = String.format("$result/Profile/Name eq '%1$s'", Constants.ACTIVATIONRECORD_NAME);
            query.addGenericCondition(thisServiceCondition);
            String notSameRICondition = String.format("$result/descendant::*[local-name()='createdBy'] ne '%1$s'", this.getInstance().getID());
            query.addGenericCondition(notSameRICondition);
            final List resources = client.execute((ISQuery)query, scope);
            final ActivationRecordConsumer consumer = new ActivationRecordConsumer(scope);
            final CountDownLatch latch = new CountDownLatch(1);
            if (resources.size() > 0) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            latch.await();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        for (GCUBEGenericResource resource : resources) {
                            consumer.onNewActivationRecord(ActivationRecord.newInstance(resource));
                        }
                    }
                }.start();
            }
            this.logger.trace((Object)("subscribing for activation records in " + scope));
            notifier.registerToISNotification((ISNotifier.BaseNotificationConsumer)consumer, arNotificationTopics, (GCUBESecurityManager)this, new GCUBEScope[]{scope});
            notifier.registerToISNotification((ISNotifier.BaseNotificationConsumer)UpdateConsumer.getUpdateConsumer(scope), updateNotificationTopics, (GCUBESecurityManager)this, new GCUBEScope[]{scope});
            latch.countDown();
        }
    }
}

