/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.viewmanager.porttypes;

import javax.xml.namespace.QName;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;
import org.gcube.contentmanagement.viewmanager.activationrecord.ActivationRecord;
import org.gcube.contentmanagement.viewmanager.activationrecord.ActivationRecordBody;
import org.gcube.contentmanagement.viewmanager.context.FactoryPTContext;
import org.gcube.contentmanagement.viewmanager.context.ServiceContext;
import org.gcube.contentmanagement.viewmanager.porttypes.VMSPortType;
import org.gcube.contentmanagement.viewmanager.state.Factory;
import org.gcube.contentmanagement.viewmanager.state.ViewResource;
import org.gcube.contentmanagement.viewmanager.stubs.VMSCreateParams;
import org.gcube.contentmanagement.viewmanager.stubs.View;
import org.gcube.contentmanagement.viewmanager.stubs.ViewReference;
import org.gcube.contentmanagement.viewmanager.stubs.calls.FactoryParameters;
import org.gcube.contentmanagement.viewmanager.stubs.calls.Utils;

public class FactoryPT
extends VMSPortType {
    public ViewReference create(VMSCreateParams params) throws GCUBEFault {
        String msg = "could not create view";
        try {
            QName name = VMSCreateParams.getTypeDesc().getXmlType();
            final FactoryParameters p = Utils.toObject(params, name, FactoryParameters.class, new boolean[0]);
            ViewResource resource = this.create(p);
            View viewStub = Utils.toStub(resource.getView(), View.class, new boolean[0]);
            if (params.isBroadcast()) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ActivationRecordBody body = new ActivationRecordBody(p.getPlugin(), p.getView(), ServiceContext.getContext().getInstance().getID());
                            String description = "An activation of the View Manager Service";
                            ActivationRecord record = ActivationRecord.newInstance("CMSRecord", description, body);
                            record.publish(new PublicationScheduler());
                            Factory factory = FactoryPTContext.getContext().getFactory();
                            factory.getActivationRecords().add(record.getResource().getID());
                            factory.store();
                        }
                        catch (Throwable t) {
                            FactoryPT.this.logger.error((Object)("could not publish activation record " + p), t);
                        }
                    }
                };
                ServiceContext.getContext().newServiceThread(r).start();
            }
            return new ViewReference(resource.getEPR(), viewStub);
        }
        catch (GCUBEException e) {
            throw e.toFault(new String[]{msg});
        }
        catch (Exception e) {
            throw ServiceContext.getContext().getDefaultException(e).toFault(new String[]{msg});
        }
    }

    public ViewResource create(FactoryParameters params) throws Exception {
        if (params.getView().getId() == null) {
            throw new IllegalArgumentException("id is null");
        }
        Factory factory = FactoryPTContext.getContext().getFactory();
        return factory.create(params.getPlugin(), params.getView());
    }

    private class PublicationScheduler
    extends GCUBEScheduledHandler<Object> {
        private static final int ATTEMPTS = 5;
        private static final int INTERVAL = 10;

        public PublicationScheduler() {
            this.setInterval(10L);
            this.setScopeManager((GCUBEScopeManager)ServiceContext.getContext());
            this.setSecurityManager((GCUBESecurityManager)ServiceContext.getContext());
        }

        protected boolean repeat(Exception exception, int exceptionCount) {
            if (exception == null) {
                return false;
            }
            if (exceptionCount > 5) {
                this.logger.error((Object)"could not publish activation record ", (Throwable)exception);
                return false;
            }
            return true;
        }
    }
}

