/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.viewmanager.activationrecord;

import java.io.Reader;
import java.io.StringReader;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.viewmanager.activationrecord.ActivationRecord;
import org.gcube.contentmanagement.viewmanager.activationrecord.ActivationRecordBody;
import org.gcube.contentmanagement.viewmanager.context.FactoryPTContext;
import org.gcube.contentmanagement.viewmanager.context.ServiceContext;
import org.gcube.contentmanagement.viewmanager.context.ViewPTContext;
import org.gcube.contentmanagement.viewmanager.state.Factory;
import org.globus.wsrf.ResourceKey;

public class ActivationRecordConsumer
extends ISNotifier.BaseNotificationConsumer {
    private static GCUBELog logger = new GCUBELog(ActivationRecordConsumer.class);
    private GCUBEScope scope;

    public ActivationRecordConsumer(GCUBEScope scope) {
        this.scope = scope;
    }

    public void onNotificationReceived(ISNotifier.NotificationEvent event) {
        block6: {
            try {
                String id = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(0).getChildNodes().item(0).getNodeValue();
                String operation = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(2).getChildNodes().item(0).getNodeValue();
                logger.debug((Object)("received AR with id " + id + " op " + operation));
                if (operation.equals("create")) {
                    GCUBEGenericResource resource = null;
                    try {
                        String profile = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(1).getChildNodes().item(0).getNodeValue();
                        resource = (GCUBEGenericResource)GHNContext.getImplementation(GCUBEGenericResource.class);
                        resource.load((Reader)new StringReader(profile));
                    }
                    catch (Exception e) {
                        logger.warn((Object)("could not parse generic resource " + id));
                    }
                    this.onNewActivationRecord(ActivationRecord.newInstance(resource));
                    break block6;
                }
                if (operation.equals("destroy")) {
                    this.onRemoveActivationRecord(id);
                }
            }
            catch (Throwable e) {
                logger.error((Object)("could not process event " + event), e);
            }
        }
    }

    public void onNewActivationRecord(ActivationRecord record) {
        try {
            Factory factory = FactoryPTContext.getContext().getFactory();
            ServiceContext context = ServiceContext.getContext();
            ActivationRecordBody body = record.getBody();
            if (body.getCreatedBy().equals(context.getInstance().getID()) || factory.getContext(body.getPlugin()) == null || factory.getActivationRecords().contains(record.getResource().getID())) {
                logger.trace((Object)("discarding AR " + record.getResource().getID()));
                return;
            }
            logger.trace((Object)("processing AR \n" + record.getResource().getBody()));
            context.setScope(this.scope);
            context.useServiceCredentials(new Thread[0]);
            factory.create(body.getPlugin(), body.getView());
            factory.getActivationRecords().add(record.getResource().getID());
            factory.store();
        }
        catch (Exception e) {
            logger.warn((Object)("could not process AR " + record.getResource().getID()), (Throwable)e);
        }
    }

    public void onRemoveActivationRecord(String id) {
        logger.debug((Object)"retrieved AR for removing");
        try {
            Factory factory = FactoryPTContext.getContext().getFactory();
            if (factory.getActivationRecords().contains(id)) {
                ServiceContext.getContext().setScope(this.scope);
                logger.debug((Object)("removing in scope " + this.scope));
                ViewPTContext.getContext().getWSHome().remove((ResourceKey)ViewPTContext.getContext().makeKey(id));
                factory.getActivationRecords().remove(id);
                factory.store();
                logger.debug((Object)("recource with id " + id + " removed"));
            } else {
                logger.warn((Object)("the activation record with id " + id + " has not been found"));
            }
        }
        catch (Exception e) {
            logger.warn((Object)("error destroying resource with id " + id), (Throwable)e);
        }
    }
}

