package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.queries.alters.DropColumn;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.contentmanagement.timeseries.geotools.utils.Tuple;
import org.gcube.contentmanagement.timeseries.geotools.vti.VTIDataExtender;
import org.gcube.contentmanagement.timeseries.geotools.vti.VTIDataExtender.DataExtenderFunctionalities;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.EnrichRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.DataType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.OperationType;

public class Enrichment extends Operation{

	/**
	 * 
	 */
	private static final long serialVersionUID = 2065606324772681068L;

	private static GCUBELog logger= new GCUBELog(Enrichment.class);
	
	public Enrichment() {
		super();
		this.type= OperationType.Enrichment;
		this.viewName="e"+uuidGen.nextUUID().replaceAll("-", "");
	}

	private String messageIdColumn;
	private String xDimColumn;
	private String yDimColumn;
	private String speedColumn;
	private String rawDatesColumn;
	private String vesselIDColumn;
	
	@Override
	public void setParameters(Object... parameters) throws Exception {
		EnrichRequest request = (EnrichRequest)parameters[0];
		this.messageIdColumn = request.getMessageIdColumn();
		this.xDimColumn = request.getXDimColumn();
		this.yDimColumn = request.getYDimColumn();
		this.speedColumn = request.getSpeedColumn();
		this.rawDatesColumn = request.getRawDatesColumn();
		this.vesselIDColumn = request.getVesselIDColumn();

	}

	@Override
	protected void initialize(String previuosTableName,
			ColumnDefinition[] previousTableDefinition, DBSession session)
			throws Exception {
		try {
			logger.trace("initializing Enrichment");
		
			Select select = DBSession.getImplementation(Select.class);
			select.setTables(new Table(previuosTableName));
			this.setColumnDefinition(previousTableDefinition);
			this.createTable(select, session, true);
			
			List<ColumnDefinition> newColumnDefinition = new ArrayList<ColumnDefinition>();
			newColumnDefinition.addAll(Arrays.asList(previousTableDefinition));
			
			this.viewTable.initializeFieldMapping();
			
			logger.debug("msgID: "+this.messageIdColumn+" x dim: "+this.xDimColumn+" y dim: "+ this.yDimColumn+" spped: "+this.speedColumn+" data: "+this.rawDatesColumn+" vessel: "+this.vesselIDColumn);
			
			String tablePrimaryKeyType =this.viewTable.getFieldsMapping().get(messageIdColumn).getType().getListSqlTypes().get(0);
			
			VTIDataExtender extender = ServiceContext.getContext().getVtiDataExtender();
			
			logger.trace("extender is null ?"+(extender==null));
			
			//CASE 1 : BATHYMETRY CALCULATION
			extender.extendTable(this.viewName,messageIdColumn,tablePrimaryKeyType, xDimColumn, yDimColumn, DataExtenderFunctionalities.bathymetry);
			
			List<Tuple<String>> couples = extender.getColumnsAType(DataExtenderFunctionalities.bathymetry);
			for (Tuple<String> couple: couples){
				logger.trace("enrichment found "+couple.getElements().get(0));
				DataType valueType = Util.mapSqlToJava(Type.parseType(couple.getElements().get(1), 50, 10, 5).getType());
				newColumnDefinition.add(new ColumnDefinition(EntryType.Attribute, null, null, couple.getElements().get(0), null, couple.getElements().get(0), valueType));
			}
			
			String bathymetryColumn = (extender.getColumnsAType(DataExtenderFunctionalities.bathymetry)).get(0).getElements().get(0);
							
			//CASE 2: FISHERY CLASSIFICATION
			extender.extendTable(this.viewName,messageIdColumn,tablePrimaryKeyType, speedColumn, bathymetryColumn, DataExtenderFunctionalities.classify);
			
			couples = extender.getColumnsAType(DataExtenderFunctionalities.classify);
			for (Tuple<String> couple: couples){
				logger.trace("enrichment found "+couple.getElements().get(0));
				DataType valueType = Util.mapSqlToJava(Type.parseType(couple.getElements().get(1), 50, 10, 5).getType());
				newColumnDefinition.add(new ColumnDefinition(EntryType.Attribute, null, null, couple.getElements().get(0), null, couple.getElements().get(0), valueType));
			}
			
			//CASE 3: FORMATTED DATES
			extender.extendTable(this.viewName, messageIdColumn,tablePrimaryKeyType,rawDatesColumn,DataExtenderFunctionalities.vti_dates);
			
			couples = extender.getColumnsAType(DataExtenderFunctionalities.vti_dates);
			for (Tuple<String> couple: couples){
				logger.trace("enrichment found "+couple.getElements().get(0));
				DataType valueType = Util.mapSqlToJava(Type.parseType(couple.getElements().get(1), 50, 10, 5).getType());
				newColumnDefinition.add(new ColumnDefinition(EntryType.Attribute, null, null, couple.getElements().get(0), null, couple.getElements().get(0), valueType));
			}
			
			DropColumn dropColumn = DBSession.getImplementation(DropColumn.class);
			dropColumn.setTable(new Table(getViewName()));
			dropColumn.setColumn(new SimpleAttribute(rawDatesColumn));
			dropColumn.execute(session);
			
			int index=-1;
			for (int i=0; i<newColumnDefinition.size(); i++)
				if (newColumnDefinition.get(i).getId().equals(rawDatesColumn)){
					index =i;
					break;
				}
			newColumnDefinition.remove(index);
					
			
			String formattedDatesColumn = (extender.getColumnsAType(DataExtenderFunctionalities.vti_dates)).get(0).getElements().get(0);
			
			//CASE 4: FISHING HOURS
			extender.extendTable(this.viewName, messageIdColumn,tablePrimaryKeyType,vesselIDColumn,formattedDatesColumn, DataExtenderFunctionalities.fishing_hours);
		
			couples = extender.getColumnsAType(DataExtenderFunctionalities.fishing_hours);
			for (Tuple<String> couple: couples){
				logger.trace("enrichment found "+couple.getElements().get(0));
				DataType valueType = Util.mapSqlToJava(Type.parseType(couple.getElements().get(1), 50, 10, 5).getType());
				newColumnDefinition.add(new ColumnDefinition(EntryType.Attribute, null, null, couple.getElements().get(0), null, couple.getElements().get(0), valueType));
			}
			
			this.viewTable.initializeFieldMapping();
			this.setColumnDefinition(newColumnDefinition.toArray(new ColumnDefinition[newColumnDefinition.size()]));
			setCount(this.viewTable.getCount());
			setHistoryItem(new TSHistoryItem("unknown","enrichment applied",new Date(),OperationType.Enrichment));

			logger.trace("enrichment finished");
		}catch (Exception e) {
			logger.error("error during enrichment",e);
			throw e;
		}
	}
	
}
