package org.gcube.contentmanagement.timeseriesservice.impl.editing;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.CastObject;
import org.gcube.common.dbinterface.Condition;
import org.gcube.common.dbinterface.attributes.AggregatedAttribute;
import org.gcube.common.dbinterface.attributes.AggregationFunctions;
import org.gcube.common.dbinterface.attributes.AssignedAttribute;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.BooleanAttribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.conditions.ANDCondition;
import org.gcube.common.dbinterface.conditions.NOTCondition;
import org.gcube.common.dbinterface.conditions.OperatorCondition;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CreateTableFromSelect;
import org.gcube.common.dbinterface.queries.CreateTableLike;
import org.gcube.common.dbinterface.queries.Delete;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.rules.Rule;
import org.gcube.contentmanagement.timeseriesservice.impl.exceptions.InvalidValueException;
import org.gcube.contentmanagement.timeseriesservice.impl.exceptions.OperationNotSupportedException;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.util.FilterExplorer;
import org.gcube.contentmanagement.timeseriesservice.stubs.ErrorPair;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;

public class RuleEditor extends Edit {

	/**
	 * 
	 */
	private static final long serialVersionUID = 7217900599962841532L;
	
	
	private static transient GCUBELog logger= new GCUBELog(RuleEditor.class);
	
	private List<Rule> rules;	
	private ColumnDefinition[] columnsDefinition;
	private final String TABLE_ALIAS="tableAlias";
	
	public RuleEditor(String resourceId, String fieldId,
			SimpleTable resourceTable, int[] fieldLength,
			boolean withoutError, List<Rule> rules, ColumnDefinition[] columnsDefinition,  String ... rowIdLabel) {
		super(resourceId, fieldId, resourceTable, fieldLength, withoutError, rowIdLabel);
		this.rules = rules;
		this.columnsDefinition= columnsDefinition;
	}

	@Override
	protected void internalInitialize(DBSession session) throws Exception {
		//creating correct table
		CreateTableFromSelect createFromSelect = DBSession.getImplementation(CreateTableFromSelect.class);
		createFromSelect.setTableName(getCorrectsTableName());
		
		Select select= DBSession.getImplementation(Select.class);
		select.setTables(new Table(this.resourceTable.getTableName(),TABLE_ALIAS));
				
		Condition[] conditions= new Condition[rules.size()];
		
		for (int i= 0 ; i<rules.size(); i++)
			conditions[i]=FilterExplorer.getCondition(rules.get(i).getFilter(), columnsDefinition, TABLE_ALIAS, this.getFieldId());
		
		select.setFilter(new ANDCondition(conditions));
		
		logger.debug("query for correct : "+select.getExpression());
		
		createFromSelect.setSelect(select);
		createFromSelect.setWithData();
		createFromSelect.execute(session);
						
		//creating wrong entry table
		CreateTableLike createTableLike = DBSession.getImplementation(CreateTableLike.class);
		createTableLike.setTableName(getWrongsTableName());
		createTableLike.setTableLike(this.resourceTable);
		SimpleTable wrongTable = createTableLike.execute(session);
		
		InsertFromSelect insertFromSelectQuery = DBSession.getImplementation(InsertFromSelect.class);
		insertFromSelectQuery.setTable(wrongTable);
		select= DBSession.getImplementation(Select.class);
		select.setTables(new Table(this.resourceTable.getTableName(), TABLE_ALIAS));
		
		conditions= new Condition[rules.size()];
			
		for (int i= 0 ; i<rules.size(); i++)
			conditions[i]=FilterExplorer.getCondition(rules.get(i).getFilter(), columnsDefinition, TABLE_ALIAS, this.getFieldId());
		
		select.setFilter(new NOTCondition(new ANDCondition(conditions)));
		
		logger.debug("query for wrong : "+select.getExpression());
		
		insertFromSelectQuery.setSubQuery(select);
		insertFromSelectQuery.execute(session);
	}

	
	@Override
	public long check() throws Exception {
		DBSession session= null;
		try{
			Select select= DBSession.getImplementation(Select.class);
			select.setAttributes(new AggregatedAttribute("*",AggregationFunctions.COUNT));
			select.setTables(new Table(this.resourceTable.getTableName(), TABLE_ALIAS));
			Condition[] conditions= new Condition[rules.size()];
				
			for (int i= 0 ; i<rules.size(); i++)
				conditions[i]=FilterExplorer.getCondition(rules.get(i).getFilter(), columnsDefinition, TABLE_ALIAS,  this.getFieldId());
			
			select.setFilter(new NOTCondition(new ANDCondition(conditions)));
			ResultSet result = select.getResults(session);
			return result.getLong(1);
		}finally {
			if(session!=null)session.release();
		}
	}

	@Override
	public void replaceValue(int rowId, Object value) throws Exception {
		logger.debug("replacing value "+rowId+" "+value.toString());
		Select select = DBSession.getImplementation(Select.class);
		Condition[] conditions= new Condition[rules.size()];
		
		CastObject valueCast = Utility.getCast(value.toString(), this.resourceTable.getFieldsMapping().get(this.fieldId));
		
		for (int i= 0 ; i<rules.size(); i++)
				conditions[i]=FilterExplorer.getConditionUsingValue(rules.get(i).getFilter(), valueCast);
		
			
		select.setAttributes(new BooleanAttribute("field", new ANDCondition(conditions) ));
		logger.debug("checking the new value: "+ select.getExpression());
		DBSession session = null;
		try{
			session = DBSession.connect();
			ResultSet rs = select.getResults(session, false);
			rs.next();
			if (!rs.getBoolean(1)) throw new InvalidValueException();
			
			session.disableAutoCommit();
			//retrieving the row from wrong entries and inserting in the correct table
			select = DBSession.getImplementation(Select.class);
			List<Attribute> attributes = new ArrayList<Attribute>();
			for (String key :getCorrectsTable().getFieldsMapping().keySet()){
				if (key.equals(fieldId))attributes.add(new AssignedAttribute<CastObject>(new SimpleAttribute(fieldId), valueCast));
				else attributes.add(new SimpleAttribute(key));
			}
			
			
			select.setAttributes(attributes.toArray(new Attribute[attributes.size()]));
			select.setTables(new Table(this.getWrongsTableName()));
			select.setFilter(new OperatorCondition<SimpleAttribute, Integer>(new SimpleAttribute(this.ROW_ID_LABEL), rowId ,"="));
			
			//TODO: test if is enough (insert without cast)
			
			InsertFromSelect insertFromSelect =  DBSession.getImplementation(InsertFromSelect.class);
			insertFromSelect.setTable(new SimpleTable(this.getCorrectsTableName()));
			insertFromSelect.setSubQuery(select);
			insertFromSelect.execute(session);
			
			logger.trace("replaceValue: "+insertFromSelect.getExpression());
			
			Delete deleteEntry = DBSession.getImplementation(Delete.class);
			deleteEntry.setTable(new Table(this.getWrongsTableName()));
			deleteEntry.setFilter(new OperatorCondition<SimpleAttribute, Integer>(new SimpleAttribute(this.ROW_ID_LABEL), rowId ,"="));
			deleteEntry.execute(session);
			
			session.commit();
			
		}finally{
			if (session!=null) session.release();
		}
	

	}

	public void modifyEntryId(String fieldId, String newId, long rowId) throws Exception{
		throw new OperationNotSupportedException();
	}
	
	public void modifyDistinctEntryId(String fieldId, String newId, long rowId, String dimensionId, String keyName) throws Exception{
		throw new OperationNotSupportedException();
	}
	
	public void modifyDistinctEntryValue(String fieldId, long rowId, String newValue) throws Exception{
		throw new OperationNotSupportedException();
	}
	
	public void replaceIds(String fieldId, String oldId, String newId) throws Exception{
		throw new OperationNotSupportedException();
	}
	
	public void replaceDistinctValue(String fieldId, String newValue, String oldValue) throws Exception{
		throw new OperationNotSupportedException();
	}
	
	public void replaceDistinctIds(String fieldId, String oldId, String newId, String keyName) throws Exception{
		throw new OperationNotSupportedException();
	}
	
	public void replaceEntryValueWithId(String oldValue, String newId, String fieldId) throws Exception{
		throw new OperationNotSupportedException();
	}

	@Override
	public List<ErrorPair> getDistinctErrors() throws Exception {
		throw new OperationNotSupportedException();
	}

	@Override
	public String getPossibleValues(String word) throws Exception {
		throw new OperationNotSupportedException();
	}

	@Override
	public ColumnDefinition getTemporaryColumnDefinition(ColumnDefinition oldColumnDefinition) throws Exception {
		return oldColumnDefinition;
	}
}
