package org.gcube.contentmanagement.timeseriesservice.impl.editing;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.CastObject;
import org.gcube.common.dbinterface.attributes.AggregatedAttribute;
import org.gcube.common.dbinterface.attributes.AggregationFunctions;
import org.gcube.common.dbinterface.attributes.AssignedAttribute;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.conditions.IsInOperator;
import org.gcube.common.dbinterface.conditions.ListSelect;
import org.gcube.common.dbinterface.conditions.NotInOperator;
import org.gcube.common.dbinterface.conditions.ORCondition;
import org.gcube.common.dbinterface.conditions.OperatorCondition;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CreateTableFromSelect;
import org.gcube.common.dbinterface.queries.CreateTableLike;
import org.gcube.common.dbinterface.queries.Delete;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.queries.alters.ModifyColumnType;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.codelistmanager.exception.ValueNotFoundException;

public class CodeListRelationEdit extends ColumnEditor {

	private static transient GCUBELog logger = new GCUBELog(CodeListRelationEdit.class);
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 4411160417374524492L;
	
	private String codeFieldId;
	private SimpleTable relationTable;
	
	public CodeListRelationEdit(String resourceId, String fieldId,
			SimpleTable resourceTable, int[] fieldLength,
			boolean withoutError, String codeFieldId, SimpleTable relationTable,  String ... rowIdLabel) throws Exception{
		super(resourceId, fieldId, resourceTable, fieldLength, withoutError, relationTable.getFieldsMapping().get(codeFieldId),  rowIdLabel);
		logger.debug("the type in edit mode is "+this.getDataType().getType().getValue());
		this.codeFieldId = codeFieldId;
		this.editorType= TYPE.CodeListRelation;
		this.relationTable = relationTable;
	}
	
	public CodeListRelationEdit(String resourceId, String fieldId,
			SimpleTable resourceTable, int[] fieldLength,
			boolean withoutError, String codeFieldId,  String ... rowIdLabel) throws Exception {
		super(resourceId, fieldId, resourceTable, fieldLength, withoutError, resourceTable.getFieldsMapping().get(codeFieldId),  rowIdLabel);
		logger.debug("the type in edit mode is "+this.getDataType().getType().getValue());
		this.codeFieldId = codeFieldId;
		this.editorType= TYPE.CodeListRelation;
		this.relationTable = resourceTable;
	}
	
	@Override
	public void internalInitialize(DBSession session) throws Exception {
		//creating correct table
		
		this.resourceTable.initializeFieldMapping();
		
		CreateTableFromSelect createFromSelect = DBSession.getImplementation(CreateTableFromSelect.class);
		createFromSelect.setTableName(getCorrectsTableName());
		
		Select select= DBSession.getImplementation(Select.class);
		select.setTables(this.resourceTable);
		CastObject cast= Utility.getCast(new SimpleAttribute(this.fieldId), this.getDataType());
		cast.setUseCastFunction(true);
		
		Select subSelect = DBSession.getImplementation(Select.class);
		subSelect.setTables(this.relationTable);
		subSelect.setAttributes(new SimpleAttribute(codeFieldId));
		
		select.setFilter(new IsInOperator(new SimpleAttribute(cast.getCast()), new ListSelect(subSelect)));
		
		logger.debug("query for correct : "+select.getExpression());
		
		createFromSelect.setSelect(select);
		createFromSelect.setWithData();
		createFromSelect.execute(session);
		
		ModifyColumnType modifyColumn = DBSession.getImplementation(ModifyColumnType.class);
		modifyColumn.setNewType( this.getDataType());
		modifyColumn.setTable(new Table(getCorrectsTableName()));
		modifyColumn.setColumn(new SimpleAttribute(this.fieldId));
		modifyColumn.setUseCast(true);
		modifyColumn.execute(session);
		
		logger.debug("the code data type is "+this.getDataType().getType().toString());
		
		//creating wrong entry table
		CreateTableLike createTableLike = DBSession.getImplementation(CreateTableLike.class);
		createTableLike.setTableName(getWrongsTableName());
		createTableLike.setTableLike(this.resourceTable);
		SimpleTable wrongTable = createTableLike.execute(session);
		
		InsertFromSelect insertFromSelectQuery = DBSession.getImplementation(InsertFromSelect.class);
		insertFromSelectQuery.setTable(wrongTable);
		select= DBSession.getImplementation(Select.class);
		select.setTables(this.resourceTable);
		cast= Utility.getCast(new SimpleAttribute(this.fieldId), this.getDataType());
		cast.setUseCastFunction(true);
		select.setFilter(new ORCondition(new NotInOperator(new SimpleAttribute(cast.getCast()), new ListSelect(subSelect)), new OperatorCondition<CastObject, Object>(cast, null," IS ")));
		
		logger.debug("query for wrong : "+select.getExpression());
		
		insertFromSelectQuery.setSubQuery(select);
		insertFromSelectQuery.execute(session);
	}

	@Override
	public long check() throws Exception {
		DBSession session = null;
		try{
			session = DBSession.connect();
			Select select = DBSession.getImplementation(Select.class);
			select.setAttributes(new AggregatedAttribute("*", AggregationFunctions.COUNT));

			Select subSelect = DBSession.getImplementation(Select.class);
			subSelect.setAttributes(new SimpleAttribute(codeFieldId));
			subSelect.setTables(this.relationTable);

			CastObject cast= Utility.getCast(new SimpleAttribute(this.fieldId), this.getDataType());
			cast.setUseCastFunction(true);
			
			select.setTables(this.resourceTable);
			select.setFilter(new NotInOperator(new SimpleAttribute(cast.getCast()),new ListSelect(subSelect)));

			ResultSet rs =select.getResults(false);
			rs.next();
			return rs.getLong(1);
		}finally{
			if (session!=null) session.release();
		}
	}

	@Override
	public void replaceValue(int rowId, Object value) throws Exception {
		
		//CodeList codeList = CodeList.get(this.parentInfo.getCodeListRefId());		
		Select select = DBSession.getImplementation(Select.class);
		select.setTables(this.relationTable);
		select.setAttributes(new AggregatedAttribute("*",AggregationFunctions.COUNT));
		CastObject castObject= Utility.getCast(value.toString(), this.relationTable.getFieldsMapping().get(codeFieldId));
		castObject.setUseCastFunction(true);
		select.setFilter(new OperatorCondition<SimpleAttribute, CastObject>(new SimpleAttribute(codeFieldId),castObject, "="));
		DBSession session = null;
		try{
			session = DBSession.connect();
			ResultSet result = select.getResults(session);
			result.next();
			if (result.getInt(1)==0) throw new ValueNotFoundException();
			
			session.disableAutoCommit();
			//retrieving the row from wrong entries and inserting in the correct table
			select = DBSession.getImplementation(Select.class);
			
			List<Attribute> attributes = new ArrayList<Attribute>();
			for (String key :getCorrectsTable().getFieldsMapping().keySet()){
				if (key.equals(fieldId))attributes.add(new AssignedAttribute<CastObject>(new SimpleAttribute(fieldId), castObject));
				else attributes.add(new SimpleAttribute(key));
			}
			
			select.setAttributes(attributes.toArray(new Attribute[attributes.size()]));
			
			select.setTables(new Table(this.getWrongsTableName()));
			select.setFilter(new OperatorCondition<SimpleAttribute, Integer>(new SimpleAttribute(this.ROW_ID_LABEL), rowId ,"="));
			
			//TODO: test if is enough (insert without cast)
			
			InsertFromSelect insertFromSelect =  DBSession.getImplementation(InsertFromSelect.class);
			insertFromSelect.setTable(new SimpleTable(this.getCorrectsTableName()));
			insertFromSelect.setSubQuery(select);
			insertFromSelect.execute(session);
					
			
			Delete deleteEntry = DBSession.getImplementation(Delete.class);
			deleteEntry.setTable(new Table(this.getWrongsTableName()));
			deleteEntry.setFilter(new OperatorCondition<SimpleAttribute, Integer>(new SimpleAttribute(this.ROW_ID_LABEL), rowId ,"="));
			deleteEntry.execute(session);
			
			session.commit();
			
			
		}finally{
			if (session!=null) session.release();
		}
	}		

}
