package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.CastObject;
import org.gcube.common.dbinterface.Condition;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.conditions.ANDCondition;
import org.gcube.common.dbinterface.conditions.ORCondition;
import org.gcube.common.dbinterface.conditions.OperatorCondition;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.types.Type.Types;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.codelistmanager.entities.CodeList;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.state.CurationResource;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.Operation;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ComplexCondition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ComplexFilter;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ConditionOperator;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.DateOperator;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.FilterCondition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.NumberOperator;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.SimpleFilter;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.TextOperator;

public class FilterExplorer {

	public static GCUBELog logger= new GCUBELog(FilterExplorer.class);
	
	public static Condition getCondition(FilterCondition condition, ColumnDefinition[] columsDefinition, String tableAlias, String ... fieldId) throws Exception{
		logger.debug("geting conditions");
		String fieldToSet= fieldId!=null && fieldId.length>0?fieldId[0]:null;
		
		logger.trace("field to set is "+fieldToSet);
		
		logger.trace("condition is null?"+(condition == null));
		
		if (condition.getCondition()!=null){
			ComplexCondition complCond=condition.getCondition();
			if (complCond.getOperator() == ConditionOperator.or) return new ORCondition(getCondition(complCond.getLeftCondition(),columsDefinition, fieldToSet),getCondition(complCond.getRightCondition(),columsDefinition, fieldToSet));
			else {
				logger.debug("leftOperand is null?"+(complCond.getLeftCondition()==null));
				logger.debug("rightOperand is null?"+(complCond.getRightCondition()==null));
				return new ANDCondition(getCondition(complCond.getLeftCondition(),columsDefinition, fieldToSet),getCondition(complCond.getRightCondition(),columsDefinition, fieldToSet));
			}
		}else if (condition.getFilter()!=null){
			if (condition.getFilter().getComplexFilter()!=null){
				logger.trace("is complex filter");
				ComplexFilter complexFilter= condition.getFilter().getComplexFilter();
				
				ColumnDefinition columnDef= Operation.getColumnDefinitionReference((fieldToSet==null?complexFilter.getFieldId():fieldToSet),columsDefinition);    
				CodeList relatedCodelist = CodeList.get(columnDef.getDimension().getId());
				
				Type codeType = relatedCodelist.getTable().getFieldsMapping().get(relatedCodelist.getCodeColumnId());
								
				List<OperatorCondition<Attribute, CastObject>> operators= new ArrayList<OperatorCondition<Attribute,CastObject>>();
				logger.debug("dimensionIdAray is null?"+(complexFilter.getDimensionIdsvalueArray()==null));
								
				for (String id:complexFilter.getDimensionIdsvalueArray()){
					logger.trace("value type is "+codeType.getType());
					CastObject cast= Utility.getCast(id, codeType);
					operators.add(new OperatorCondition<Attribute, CastObject>(new SimpleAttribute((fieldToSet==null?complexFilter.getFieldId():fieldToSet)+CurationResource.ID_COLUMN_SUFFIX,tableAlias), cast ,"="));
				}
				return new ORCondition(operators.toArray(new Condition[0]));
			} else if (condition.getFilter().getSimpleFilter()!=null){
				logger.trace("is simple filter");
				SimpleFilter simpleFilter= condition.getFilter().getSimpleFilter();
				ColumnDefinition columnDef= Operation.getColumnDefinitionReference((fieldToSet==null?simpleFilter.getFieldId():fieldToSet),columsDefinition);
				if (simpleFilter.getOperator().getNumberOperator()!=null){
					String operator=resolveNumberOperator(simpleFilter.getOperator().getNumberOperator());
					logger.trace("the value type is:" + columnDef.getValueType());
					CastObject cast= Utility.getCast(simpleFilter.getValue(), new Type(Types.valueOf(columnDef.getValueType().getValue().toUpperCase())));
					return new OperatorCondition<Attribute, CastObject>(new SimpleAttribute(columnDef.getId(),tableAlias),cast,operator);					
				}else if (simpleFilter.getOperator().getTextOperator()!=null){
					StringOperator stringOperator=resolveStringOperator(simpleFilter.getOperator().getTextOperator(), simpleFilter.getValue());
					logger.trace("is columnDef null?"+(columnDef==null));
					logger.trace("type of column is "+columnDef.getValueType().getValue());
					logger.trace("operator is "+stringOperator.getValue());
					CastObject cast= Utility.getCast(stringOperator.getValue(), new Type(Types.valueOf(columnDef.getValueType().getValue().toUpperCase())));
					return new OperatorCondition<Attribute, CastObject>(new SimpleAttribute(columnDef.getId(),tableAlias),cast,stringOperator.getSqlOperator());
				}else if(simpleFilter.getOperator().getDateOperator()!=null) {
					String operator=resolveDateOperator(simpleFilter.getOperator().getDateOperator());
					CastObject cast= Utility.getCast(simpleFilter.getValue(), new Type(Types.valueOf(columnDef.getValueType().getValue().toUpperCase())));
					return new OperatorCondition<Attribute, CastObject>(new SimpleAttribute(columnDef.getId(),tableAlias),cast,operator);
				}
				
				throw new Exception("Filter Declaration Error"); 
			}
			
		}
		throw new Exception("Filter Declaration Error");
	}
	
	public static Condition getConditionUsingValue(FilterCondition condition, CastObject value) throws Exception{
		logger.debug("geting conditions");
				
		if (condition.getCondition()!=null){
			ComplexCondition complCond=condition.getCondition();
			if (complCond.getOperator() == ConditionOperator.or) return new ORCondition(getConditionUsingValue(complCond.getLeftCondition(), value),getConditionUsingValue(complCond.getRightCondition(), value));
			else {
				logger.debug("leftOperand is null?"+complCond.getLeftCondition()==null);
				logger.debug("rightOperand is null?"+complCond.getRightCondition()==null);
				return new ANDCondition(getConditionUsingValue(complCond.getLeftCondition(), value),getConditionUsingValue(complCond.getRightCondition(), value));
			}
		}else if (condition.getFilter()!=null){
			if (condition.getFilter().getComplexFilter()!=null){
				throw new Exception("complexFilter are not allowed");
			} else if (condition.getFilter().getSimpleFilter()!=null){
				SimpleFilter simpleFilter= condition.getFilter().getSimpleFilter();
				if (simpleFilter.getOperator().getNumberOperator()!=null){
					String operator=resolveNumberOperator(simpleFilter.getOperator().getNumberOperator());
					CastObject cast= Utility.getCast(simpleFilter.getValue(), value.getType());
					return new OperatorCondition<CastObject, CastObject>(value,cast,operator);					
				}else if (simpleFilter.getOperator().getTextOperator()!=null){
					StringOperator stringOperator=resolveStringOperator(simpleFilter.getOperator().getTextOperator(), simpleFilter.getValue());
					CastObject cast= Utility.getCast(stringOperator.getValue(),value.getType());
					return new OperatorCondition<CastObject, CastObject>(value,cast,stringOperator.getSqlOperator());

				}else if(simpleFilter.getOperator().getDateOperator()!=null) {
					String operator=resolveDateOperator(simpleFilter.getOperator().getDateOperator());
					CastObject cast= Utility.getCast(simpleFilter.getValue(), value.getType());
					return new OperatorCondition<CastObject, CastObject>(value,cast,operator);
				}
				
				throw new Exception("Filter Declaration Error"); 
			}
			
		}
		throw new Exception("Filter Declaration Error");
	}
	
	public static StringBuilder getFilterDescription(FilterCondition condition, ColumnDefinition[] columsDefinition) throws Exception{
		StringBuilder toReturn= new StringBuilder();
		logger.debug("geting Filter description");
		if (condition.getCondition()!=null){
			ComplexCondition complCond=condition.getCondition();
			toReturn.append(getFilterDescription(complCond.getLeftCondition(), columsDefinition)).append(" AND ")
				.append(getFilterDescription(complCond.getRightCondition(), columsDefinition));
			return toReturn;
		}else if (condition.getFilter()!=null){
			if (condition.getFilter().getComplexFilter()!=null){
				ComplexFilter complexFilter= condition.getFilter().getComplexFilter();
				ColumnDefinition columnDefinition=Operation.getColumnDefinitionReference(complexFilter.getFieldId(), columsDefinition);
				toReturn.append("(").append(columnDefinition.getLabel()).append(" has as id: ").append(Arrays.toString(complexFilter.getDimensionIdsvalueArray()));
				toReturn.append(")");
				return toReturn;
			} else if (condition.getFilter().getSimpleFilter()!=null){
				SimpleFilter simpleFilter= condition.getFilter().getSimpleFilter();
				ColumnDefinition columnDefinition=Operation.getColumnDefinitionReference(simpleFilter.getFieldId(), columsDefinition);
				if (simpleFilter.getOperator().getNumberOperator()!=null){
					String operator=resolveNumberOperator(simpleFilter.getOperator().getNumberOperator());
					return toReturn.append(" (").append(columnDefinition.getLabel()).append(operator).append(simpleFilter.getValue()).append(")");
				}else if (simpleFilter.getOperator().getTextOperator()!=null){
					StringOperator stringOperator=resolveStringOperator(simpleFilter.getOperator().getTextOperator(), simpleFilter.getValue());
					return toReturn.append(" (").append(columnDefinition.getLabel()).append(stringOperator.getSqlOperator()).append(stringOperator.getValue()).append(")");		
				}else if(simpleFilter.getOperator().getDateOperator()!=null) {
					String operator=resolveDateOperator(simpleFilter.getOperator().getDateOperator());
					return toReturn.append(" (").append(columnDefinition.getLabel()).append(operator).append(simpleFilter.getValue()).append(")");
				}
			}
			
		}
		return toReturn;
	}
	
	public static StringBuilder generateRulesDescription(FilterCondition condition) throws Exception{
		StringBuilder toReturn= new StringBuilder();
		logger.debug("geting Filter description");
		final String label = "value";
		if (condition.getCondition()!=null){
			ComplexCondition complCond=condition.getCondition();
			toReturn.append(generateRulesDescription(complCond.getLeftCondition())).append(" AND ")
				.append(generateRulesDescription(complCond.getRightCondition()));
			return toReturn;
		}else if (condition.getFilter()!=null){
			if (condition.getFilter().getComplexFilter()!=null){
				ComplexFilter complexFilter= condition.getFilter().getComplexFilter();
				toReturn.append("(").append(label).append(" has as id: ").append(Arrays.toString(complexFilter.getDimensionIdsvalueArray()));
				toReturn.append(")");
				return toReturn;
			} else if (condition.getFilter().getSimpleFilter()!=null){
				SimpleFilter simpleFilter= condition.getFilter().getSimpleFilter();
				if (simpleFilter.getOperator().getNumberOperator()!=null){
					String operator=resolveNumberOperator(simpleFilter.getOperator().getNumberOperator());
					return toReturn.append(" (").append(label).append(operator).append(simpleFilter.getValue()).append(")");
				}else if (simpleFilter.getOperator().getTextOperator()!=null){
					StringOperator stringOperator=resolveStringOperator(simpleFilter.getOperator().getTextOperator(), simpleFilter.getValue());
					return toReturn.append(" (").append(label).append(stringOperator.getSqlOperator()).append(stringOperator.getValue()).append(")");		
				}else if(simpleFilter.getOperator().getDateOperator()!=null) {
					String operator=resolveDateOperator(simpleFilter.getOperator().getDateOperator());
					return toReturn.append(" (").append(label).append(operator).append(simpleFilter.getValue()).append(")");
				}
			}
			
		}
		return toReturn;
	}
	
	private static StringOperator resolveStringOperator(TextOperator textOp, String originalValue){
		logger.trace("original value is "+originalValue+" textOp is "+textOp.getValue());
		String operator="";
		String value= originalValue;
		if (textOp==TextOperator.EQ) operator=" LIKE ";
		else if (textOp==TextOperator.CN){
			operator=" LIKE ";	
			value="%"+value+"%";
		}else if (textOp==TextOperator.NCN){
			operator=" NOT LIKE ";
			value="%"+value+"%";
		}else if (textOp==TextOperator.SW){
			operator=" LIKE ";
			value=value+"%";
		}else if (textOp==TextOperator.EW){
			operator=" LIKE ";
			value="%"+value;
		}else if (textOp==TextOperator.NEQ)	operator=" NOT LIKE ";
		else if (textOp==TextOperator.NSW){
			operator=" NOT LIKE ";
			value=value+"%";
		}else if (textOp==TextOperator.NEW){
			operator=" NOT LIKE ";
			value="%"+value;
		}
		return new StringOperator(operator, value);
	}
	
	private static String resolveNumberOperator(NumberOperator numberOp){
		if (numberOp==NumberOperator.EQ) return "=";
		else if (numberOp==NumberOperator.GT) return ">";	
		else if (numberOp==NumberOperator.LT) return "<";
		else if (numberOp==NumberOperator.GTEQ) return ">=";
		else if (numberOp==NumberOperator.LTEQ) return "<=";
		else if (numberOp==NumberOperator.NEQ)	return "!=";
		return "";
	}
	
	private static String resolveDateOperator(DateOperator dateOp){
		if (dateOp== DateOperator.AF)	return "<";
		else if (dateOp==DateOperator.BF)	return ">";
		else if (dateOp== DateOperator.EQ)	return "=";
		else if (dateOp== DateOperator.NEQ) return "!=";
		return "";
	}
}
