package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.attributes.AssignedAttribute;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.tables.TableFromSubselect;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.state.CurationResource;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.CompatibleColumnsMapping;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.FieldMapping;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.OperationType;


public class Union extends Operation {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8743629616088928149L;
	
	private static GCUBELog logger= new GCUBELog(Union.class);
	
	private String secondResourceId;
	
	private FieldMapping[] fieldMappingList;
	
	public Union() throws Exception{
		super();
		this.type= OperationType.Union;
		this.viewName="u"+uuidGen.nextUUID().replaceAll("-", "");
	}
	
	@Override
	public void initialize(String previuosTableName, ColumnDefinition[] previousTableDefinition, DBSession session) throws Exception {
		logger.trace("initializing union");
		List<Attribute> firstTableAttributes= new LinkedList<Attribute>();
		List<Attribute> secondTableAttributes= new LinkedList<Attribute>();
		List<ColumnDefinition> newColumnDefinition= new LinkedList<ColumnDefinition>();
		int fieldId=0;
		for (FieldMapping fieldMapping:this.fieldMappingList){
			String newFieldId="field"+fieldId;
			String dimensionId="";
			logger.trace("source field is "+fieldMapping.getSourceField()+", destination field is "+fieldMapping.getDestinationField()+", new field name is"+newFieldId );
			firstTableAttributes.add(new AssignedAttribute<SimpleAttribute>(new SimpleAttribute(newFieldId),new SimpleAttribute(fieldMapping.getSourceField())));
			secondTableAttributes.add(new AssignedAttribute<SimpleAttribute>(new SimpleAttribute(newFieldId),new SimpleAttribute(fieldMapping.getDestinationField())));
			ColumnDefinition definition=getColumnDefinitionReference(fieldMapping.getSourceField(), previousTableDefinition);
			if (definition.getColumnType()== EntryType.Dimension){
				dimensionId=newFieldId+CurationResource.ID_COLUMN_SUFFIX;
				firstTableAttributes.add(new AssignedAttribute<SimpleAttribute>(new SimpleAttribute(dimensionId),new SimpleAttribute(fieldMapping.getSourceField()+CurationResource.ID_COLUMN_SUFFIX)));
				secondTableAttributes.add(new AssignedAttribute<SimpleAttribute>(new SimpleAttribute(dimensionId),new SimpleAttribute(fieldMapping.getDestinationField()+CurationResource.ID_COLUMN_SUFFIX)));
			}
			newColumnDefinition.add(new ColumnDefinition(definition.getColumnType(),definition.getDimension(),dimensionId,newFieldId,definition.getKey(),fieldMapping.getLabel(),definition.getValueType()));
			fieldId++;
		}
		setColumnDefinition(newColumnDefinition.toArray(new ColumnDefinition[0]));
					
		org.gcube.common.dbinterface.queries.Union unionQuery= DBSession.getImplementation(org.gcube.common.dbinterface.queries.Union.class);
		Select leftQuery=DBSession.getImplementation(Select.class);
		leftQuery.setAttributes(firstTableAttributes.toArray(new Attribute[0]));
		leftQuery.setTables(new Table(previuosTableName));
		Select rightQuery= DBSession.getImplementation(Select.class);
		rightQuery.setAttributes(secondTableAttributes.toArray(new Attribute[0]));
		rightQuery.setTables(getResource(secondResourceId).getTable());
		unionQuery.setLeftQuery(leftQuery);
		unionQuery.setRightQuery(rightQuery);
		
		TableFromSubselect table= new TableFromSubselect("temp", unionQuery);
		Select query= DBSession.getImplementation(Select.class);
		query.setTables(table);
		
		this.createTable(query, session, true);
		
		this.viewTable.initializeCount();
		setCount(this.viewTable.getCount());
		logger.debug("the count for union is "+this.viewTable.getCount());
		//changeColumnId();
		setHistoryItem(new TSHistoryItem("TO DO","Union with ["+getResource(this.secondResourceId).getTitle()+"]",new Date(),OperationType.Union));
	}

	@Override
	public void setParameters(Object... parameters) throws Exception {
		this.secondResourceId=(String) parameters[0];
		this.fieldMappingList=(FieldMapping[]) parameters[1];
		
	}
	
	/**
	 * 
	 * @param sourceDefinition
	 * @param destinationDefinition
	 * @return
	 * @throws Exception
	 */
	public static boolean checkCompatibility(ColumnDefinition[] sourceDefinition, ColumnDefinition[] destinationDefinition){
		logger.trace("checking compatibility src size is "+sourceDefinition.length+" and dest size is "+destinationDefinition.length);
		for (ColumnDefinition sourceDef: sourceDefinition){
			boolean isColumncompatible= false;
			for (ColumnDefinition destinationdef: destinationDefinition){
				logger.trace("src def type is "+sourceDef.getColumnType()+" and dest type is "+destinationdef.getColumnType());
				if (sourceDef.getColumnType()== destinationdef.getColumnType()){
					logger.trace("src and dest are compatible .. cheching types");
					if(sourceDef.getColumnType()==EntryType.Value && sourceDef.getValueType()==destinationdef.getValueType()){
						logger.trace(sourceDef.getId()+","+destinationdef.getId()+" entry type for both is value and src type is "+sourceDef.getValueType().toString()+" dst type is "+destinationdef.getValueType().toString()); 
						isColumncompatible= true;
						break;
					}else if (sourceDef.getColumnType()==EntryType.Attribute && sourceDef.getValueType()==destinationdef.getValueType()){
						logger.trace(sourceDef.getId()+","+destinationdef.getId()+" entry type for both is attribute and src type is "+sourceDef.getValueType().toString()+" dst type is "+destinationdef.getValueType().toString());
						isColumncompatible= true;
						break;
					}else if (sourceDef.getColumnType()==EntryType.Dimension){
						logger.trace(sourceDef.getId()+","+destinationdef.getId()+" entry type for both is dimension and src id is "+sourceDef.getDimension().getId()+" dst id is "+destinationdef.getDimension().getId());
						if (sourceDef.getDimension().getId().equals(destinationdef.getDimension().getId())){
								isColumncompatible= true;
								break;
						}
					}
				}
			}
			logger.trace(sourceDef.getId()+" has a compatibility");
			if (!isColumncompatible) return false;
		}
		return true;
	}
	
	public static CompatibleColumnsMapping[] getCompatibileColumns(ColumnDefinition[] sourceDefinition, ColumnDefinition[] destinationDefinition) throws Exception{
		List<CompatibleColumnsMapping> compatibleColumnslist= new ArrayList<CompatibleColumnsMapping>(sourceDefinition.length);
		for (ColumnDefinition sourceDef: sourceDefinition){
			CompatibleColumnsMapping columnMapping=new CompatibleColumnsMapping();
			columnMapping.setSourceColumnDefinition(sourceDef);
			List<ColumnDefinition> columnDefinitionList=new ArrayList<ColumnDefinition>();			
			
			for (ColumnDefinition destinationDef: destinationDefinition){
				if (sourceDef.getColumnType()== destinationDef.getColumnType()){
					if(sourceDef.getColumnType()==EntryType.Value && sourceDef.getValueType()==destinationDef.getValueType()){
						columnDefinitionList.add(destinationDef);
					}else if (sourceDef.getColumnType()==EntryType.Attribute && sourceDef.getValueType()==destinationDef.getValueType()){
						columnDefinitionList.add(destinationDef);
					}else if (sourceDef.getColumnType()==EntryType.Dimension){
						if (sourceDef.getDimension().getId()==destinationDef.getDimension().getId()){
							columnDefinitionList.add(destinationDef);
						}
					}
				}
			}
			columnMapping.setCompatibleColumnsList(columnDefinitionList.toArray(new ColumnDefinition[0]));
			compatibleColumnslist.add(columnMapping);
		}
		return compatibleColumnslist.toArray(new CompatibleColumnsMapping[0]);
	}

	public FieldMapping[] getFieldMappingList() {
		return fieldMappingList;
	}

	public void setFieldMappingList(FieldMapping[] fieldMappingList) {
		this.fieldMappingList = fieldMappingList;
	}
}
