package org.gcube.contentmanagement.timeseriesservice.impl.utils;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.types.Type.Types;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.DataType;


public class Util {
	
	public static SimpleDateFormat dateFormatter = new SimpleDateFormat("dd-MMM-yy HH.mm.ss");
	
	private static final Map<DataType, Types> javaToDb= new HashMap<DataType, Types>();
	
	private static final Map<Types, DataType> dbToJava= new HashMap<Types, DataType>();
		
	//public static final Map<String, String> CastMapping= new HashMap<String, String>();
	
	static {
		//initializing dbToJava 
		dbToJava.put(Types.STRING,DataType.Text);
		dbToJava.put(Types.TEXT,DataType.Text);
		dbToJava.put(Types.INTEGER,DataType.Integer);
		//dbToJava.put(Types.FLOAT,DataType.Float);
		dbToJava.put(Types.FLOAT,DataType.Float);
		dbToJava.put(Types.LONG,DataType.Integer);
		dbToJava.put(Types.DATE,DataType.Date);	
		dbToJava.put(Types.TIME,DataType.Time);
		dbToJava.put(Types.TIMESTAMP,DataType.Timestamp);
		dbToJava.put(Types.BOOLEAN,DataType.Boolean);
		
		//initializing javaToDb 
		javaToDb.put(DataType.Text,Types.STRING);
		javaToDb.put(DataType.Integer,Types.INTEGER);
		javaToDb.put(DataType.Date,Types.DATE);
		javaToDb.put(DataType.Float,Types.FLOAT);
		javaToDb.put(DataType.Boolean,Types.BOOLEAN);
		javaToDb.put(DataType.Time,Types.TIME);
		javaToDb.put(DataType.Timestamp,Types.TIMESTAMP);
		
		//Initializing CastMapping
		/*
		CastMapping.put("varchar", "char");
		CastMapping.put("long", "signed");
		CastMapping.put("integer", "signed");
		CastMapping.put("float", "signed");
		CastMapping.put("int", "signed");*/
	}
	
	
		
	
	private static GCUBELog logger= new GCUBELog(Util.class);
	
	public static String toJSon(ResultSet resultSet) throws SQLException
	{
		StringBuilder json = new StringBuilder();

		json.append("{\"response\":{\"value\":{\"items\":[");

		ResultSetMetaData metaData = resultSet.getMetaData();
		int numberOfColumns = metaData.getColumnCount();

		logger.debug("number of columns "+numberOfColumns);
			
		int count = 0;

		while(resultSet.next()){

			if (count>0) json.append(",{");
			else json.append('{');
						
			
			for (int column = 1; column <=numberOfColumns; column++){
				if (column>1) json.append(',');
				json.append(quote(metaData.getColumnName(column)));
				json.append(':');
				/*
				switch(metaData.getColumnType(column)){
				case Types.DATE: 
					json.append(quote(Util.dateFormatter.format(resultSet.getDate(column))));
					break;
				case Types.TIME: 
					json.append(quote(resultSet.getTime(column).toString()));
					break;
				case Types.TIMESTAMP:
					json.append(quote(Util.dateFormatter.format(resultSet.getTimestamp(column).getTime())));
					break;
				default: 
					
					break;
				}*/
				json.append(quote(resultSet.getString(column)));
			}

			json.append('}');
			count++;
		}

		json.append("],\"total_count\":");
		
		return json.toString();

	}
	
	/**
     * Produce a string in double quotes with backslash sequences in all the
     * right places. A backslash will be inserted within </, allowing JSON
     * text to be delivered in HTML. In JSON text, a string cannot contain a
     * control character or an unescaped quote or backslash.
     * @param string A String
     * @return  A String correctly formatted for insertion in a JSON text.
     */
    protected static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }

        char         b;
        char         c = 0;
        int          i;
        int          len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        String       t;

        sb.append('"');
        for (i = 0; i < len; i += 1) {
            b = c;
            c = string.charAt(i);
            switch (c) {
            case '\\':
            case '"':
                sb.append('\\');
                sb.append(c);
                break;
            case '/':
                if (b == '<') {
                    sb.append('\\');
                }
                sb.append(c);
                break;
            case '\b':
                sb.append("\\b");
                break;
            case '\t':
                sb.append("\\t");
                break;
            case '\n':
                sb.append("\\n");
                break;
            case '\f':
                sb.append("\\f");
                break;
            case '\r':
                sb.append("\\r");
                break;
            default:
                if (c < ' ' || (c >= '\u0080' && c < '\u00a0') ||
                               (c >= '\u2000' && c < '\u2100')) {
                    t = "000" + Integer.toHexString(c);
                    sb.append("\\u" + t.substring(t.length() - 4));
                } else {
                    sb.append(c);
                }
            }
        }
        sb.append('"');
        return sb.toString();
    }

    public static void streamToFile(InputStream instream, OutputStream out) throws Exception{
		try{
			byte[] buf = new byte[8096];
			int len;
			int sum = 0;
			while ((len = instream.read(buf)) >= 0) {
				sum+=len;
				out.write(buf, 0, len);
			}
			
		}catch(Exception e){
			if(instream!=null) instream.close();
			if(out!=null) out.close();
			throw e;
		}
	}
    
    
    /**
	 * @param is the zip stream.
	 * @param os the output stream.
	 * @throws Exception
	 */
	public static void unzip(InputStream is, OutputStream os) throws Exception
	{
		ZipInputStream zis = new ZipInputStream(is);
		ZipEntry entry;
		
		while ((entry = zis.getNextEntry())!=null){
			if (!entry.isDirectory()){
				IOUtils.copy(zis, os);
				zis.closeEntry();
				zis.close();
				os.close();
				return;
			}
		}
		
		throw new Exception("No file entry found");
		
	}
	
	public static void getZip(OutputStream os, String name, InputStream is) throws Exception
	{
		ZipOutputStream zos = new ZipOutputStream(os);
		
		ZipEntry entry = new ZipEntry(name);
		
		zos.putNextEntry(entry);
		
		IOUtils.copy(is, zos);
		
		zos.closeEntry();
		
		zos.close();
	}
	
	
	public static String removeSizeFromDBType(String typeName){
		return typeName.replaceAll("\\([^\\)]*\\)", "").toLowerCase();
	}

	public static DataType mapSqlToJava(Types type) throws Exception{
		return dbToJava.get(type);
	}
	
	public static Types mapJavaToSql(DataType sqlType){
		return javaToDb.get(sqlType);
	}
	
	public static String replaceKeyType(String type) throws Exception{
		String cleanType= removeSizeFromDBType(type);
		if (cleanType.compareTo("date")==0 || cleanType.compareTo("datetime")==0 || cleanType.compareTo("timestamp")==0 || cleanType.compareTo("time")==0)  
			return cleanType;
		return type;
	}

}
