package org.gcube.contentmanagement.timeseriesservice.impl.utils;

import java.util.ArrayList;
import org.gcube.common.core.types.MapItemType;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.Attributes;

public class ConfigurationParserHandler extends DefaultHandler {

	ArrayList<Pair> pairs = new ArrayList<ConfigurationParserHandler.Pair>();	
	ArrayList<MapItemType> mapItems = new ArrayList<MapItemType>();
	String vre= null;
	String mode = null;
	String key = null;
	String value = null;
	
	/**
	 * @return the pair
	 */
	public ArrayList<Pair> getPairs() {
		return pairs;
	}

	
	
	/**
	 * @return the mapItems
	 */
	public ArrayList<MapItemType> getMapItems() {
		return mapItems;
	}



	public void startElement(String uri, String localName,String qName, 
			Attributes attributes) throws SAXException {
		
		if (qName.equalsIgnoreCase("CONFIGURATION")) {
			for (int i = 0; i<attributes.getLength(); i++)
				if (attributes.getQName(i).contains("vre")){
					vre = attributes.getValue(i);
					break;
				}
		}if (qName.equalsIgnoreCase("PROPERTY")) {
			for (int i = 0; i<attributes.getLength(); i++){
				if (attributes.getQName(i).equals("key"))
					key = attributes.getValue(i);
				if (attributes.getQName(i).equals("value"))
					value = attributes.getValue(i);
			}
			if (key!=null && value!=null) mapItems.add(new MapItemType(key, value));
		}

	}

	public void endElement(String uri, String localName,
			String qName) throws SAXException {
		if (vre!=null && mode!=null && qName.equalsIgnoreCase("CONFIGURATION")) pairs.add(new Pair(vre, mode));
		vre =null;
		mode=null;
	}

	public void characters(char ch[], int start, int length) throws SAXException {
		if (vre!=null) 
			mode = new String(ch, start, length);	
	}

	
	public class Pair{
		
		public String key;
		public String value;
		
		public Pair(String key, String value) {
			super();
			this.key = key;
			this.value = value;
		}
		
		
		
	}
	
}


