package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.state;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Order.OrderType;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CreateTableLike;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.queries.alters.RenameTable;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.graphtools.core.StatisticsGenerator;
import org.gcube.contentmanagement.timeseries.geotools.engine.TSGeoToolsConfiguration;
import org.gcube.contentmanagement.timeseries.geotools.engine.TimeSeriesGISConverter;
import org.gcube.contentmanagement.timeseries.geotools.filters.AFilter;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISInformation;
import org.gcube.contentmanagement.timeseries.geotools.vti.VTIEffortAggregator;
import org.gcube.contentmanagement.timeseriesservice.impl.context.CurationContext;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.context.TimeSeriesContext;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.state.CurationResource;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistory;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.TimeSeries;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.Operation;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Constants;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Export;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.GISTransformationObject;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateFromTsRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateTsRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetFishingMontlyEffortRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.OperationType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ExportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Limit;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Order;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Status;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetTransformationStatusResponse;
import org.globus.wsrf.ResourceException;


public class TimeSeriesResource extends GCUBEWSResource{

	private static volatile GCUBELog logger= new GCUBELog(TimeSeriesResource.class);
	
	private static volatile HashMap<String, GISTransformationObject> converterMapping = new HashMap<String, GISTransformationObject>();
	
	private static UUIDGen trasformationIdGeneretor = UUIDGenFactory.getUUIDGen();
	
	private Hashtable<String, LinkedList<Operation>> currentsOperations;
	
	private TSHistory history;
	
	protected static final String RP_ID = "Id";
	
	protected static final String RP_TITLE = "Title";
	
	protected static String[] RPNames = {RP_ID, RP_TITLE};
	
	public long count;
	
	public Status initializationState;
	
	public String relatedCurationId;
			
	public ColumnDefinition[] columnsDefinition;
	
	public String[] tableDefinition;
	
	private SimpleTable table;
	
	
	/**
     * {@inheritDoc}
     */
    public String[] getPropertyNames() {
    	return RPNames;
    }
	
    
	@Override
	protected void initialise(Object... arg) throws Exception {
		this.initializationState= Status.Open;
		currentsOperations= new Hashtable<String, LinkedList<Operation>>();
		this.count=-1;
		try{
			String id = (String) arg[0];
			this.setId(id);
			if ((Boolean)arg[2]) this._intialize((CreateTsRequest) arg[1]);
			else this._intialize((CreateFromTsRequest) arg[1]);
			
		}catch(Exception e){
			this.initializationState=Status.Error;
			logger.error("errror initializing TS",e);
			throw e;
		}	
	}
	/**
	 * 
	 * @return
	 */
	protected long getCount() {
		return this.count;
	}

	
	/**
	 * 
	 * @param count
	 */
	protected void setCount(long count) {
		this.count = count;
	}
	
	
	/**
	 * 
	 * @param request
	 * @throws Exception
	 */
	protected void _intialize(CreateTsRequest request ) throws Exception{
		try{
			this.relatedCurationId= request.getRelatedCurationId();
			final CurationResource curationResource=(CurationResource) CurationContext.getPortTypeContext().getWSHome().find(CurationContext.getPortTypeContext().makeKey(this.relatedCurationId));
			this.setColumnsDefinition(curationResource.getColumnDefinition());			
			String sourceId =curationResource.getId();
			String sourceName= curationResource.getTitle();
			this.setTitle(request.getTitle());
			//starting inserting entries			
			final DBSession session= DBSession.connect();
			
			int length = (int) curationResource.getCount(false); 
			
			TimeSeries ts= new TimeSeries(this.getId());
			ts.setTitle(request.getTitle());
			ts.setDescription(request.getDescription());
			ts.setCreator(request.getCreator());
			ts.setPublisher(request.getPublisher());
			ts.setType(request.getType());
			ts.setSourceId(sourceId);
			ts.setSourceName(sourceName);
			ts.setRights(request.getRights());
			ts.setLegth(length);
			ts.setUsers(" "+request.getCreator()+" ");
			ts.setScope(ServiceContext.getContext().getScope().toString());
			
			
			final String tsResourceid= this.getId();
			
			CreateTableLike createLikeQuery= DBSession.getImplementation(CreateTableLike.class);
			createLikeQuery.setTableLike(curationResource.getTable());
			createLikeQuery.setTableName(Constants.getTimeSeriesTable(tsResourceid));
			table=createLikeQuery.execute(session);
			ts.store();
			this.store();
			//logger.trace("values are:"+this.getId()+" "+this.relatedCurationId+" "+now+" "+ curationResource.getHistory().getItems().size()+" "+sourceName+" "+ request.getCreator());
			this.history= new TSHistory(this.getId(),this.relatedCurationId,new Date(System.currentTimeMillis()), curationResource.getHistory().getItems().size(),sourceName, request.getCreator());
			this.history.store();
			new Thread(){
				public void run(){
					try {
						Utility.dropColumn("id", getTable()).execute(session);
						
						List<Attribute> firstAttributes= new ArrayList<Attribute>();
						List<Attribute> lastAttributes=new ArrayList<Attribute>();
						for (ColumnDefinition def:curationResource.getColumnDefinition()){
							firstAttributes.add(new SimpleAttribute(def.getId()));
							if (def.getColumnType()== EntryType.Dimension){
								String fieldName= def.getId()+CurationResource.ID_COLUMN_SUFFIX;
								lastAttributes.add(new SimpleAttribute(fieldName));
								Utility.createIndexOnField(getTable(), fieldName, false);
							}	
						}
						Collections.addAll(firstAttributes, lastAttributes.toArray(new Attribute[0]));
						
						//Select from Curation table
						Select curationSelect= DBSession.getImplementation(Select.class);
						curationSelect.setAttributes(firstAttributes.toArray(new Attribute[0]));
						curationSelect.setTables(curationResource.getTable());
						
						InsertFromSelect insertTs= DBSession.getImplementation(InsertFromSelect.class);
						insertTs.setSubQuery(curationSelect);
						insertTs.setTable(getTable());
						insertTs.execute(session);
						//session.commit();
						setInitializationState("Close");
						logger.trace("initialization set to closed");
					} catch (Exception e) {
						setInitializationState("Error");
						logger.error("errror initializing TS",e);
						remove();
					} finally{
						if (session!= null)
							session.release();
					}
				}
			}.start();
				
		}catch(Exception e){
			this.initializationState=Status.Error;
			logger.error("errror initializing TS",e);
			throw e;
		}
	}
	
	
	/**
	 * 
	 * @param request
	 * @throws Exception
	 */
	protected void _intialize(CreateFromTsRequest request ) throws Exception{
		TimeSeriesResource resource =(TimeSeriesResource) TimeSeriesContext.getPortTypeContext().getWSHome().find(TimeSeriesContext.getPortTypeContext().makeKey(request.getTsSourceId()));
		logger.debug("the source Id is "+(request.getTsSourceId())+" and sourceTitle is "+resource.getTitle());
		logger.debug("the count is: "+resource.getElementCount(request.getCreator()));
		this.setTitle(request.getTitle());
		long elementCount= resource.getElementCount(request.getCreator());
		this.setCount(elementCount);
		this.setColumnsDefinition(resource.getCurrentColumnsDefinition(request.getCreator()));
		DBSession session= DBSession.connect();
		logger.trace("the source ID is " +request.getTsSourceId());		
		//table creation
		TimeSeries ts= null;
		try{
			RenameTable renameTable= DBSession.getImplementation(RenameTable.class);
			renameTable.setNewName(Constants.getTimeSeriesTable(this.getId()));
			renameTable.setTable(new Table(resource.getCurrentOperation(request.getCreator()).getViewName()));
			logger.trace("the new ts with id "+this.getId()+" is being created with query: "+renameTable.getExpression());
			this.table=renameTable.execute(session);
			
			ts= new TimeSeries(this.getId());
			ts.setTitle(request.getTitle());
			ts.setDescription(request.getDescription());
			ts.setCreator(request.getCreator());
			ts.setPublisher(request.getPublisher());
			ts.setType(request.getType());
			ts.setSourceId(request.getTsSourceId());
			ts.setSourceName(resource.getTitle());
			ts.setRights(request.getRights());
			ts.setLegth((int) elementCount);
			ts.setUsers(" "+request.getCreator()+" ");
			ts.setScope(ServiceContext.getContext().getScope().toString());
			ts.store();
		}catch (Exception e) {
			logger.error("error saving the TS with id "+this.getId()+" trying the rollback");
			try{
				if (ts!=null)
					ts.delete();
				Utility.drop(Constants.getTimeSeriesTable(this.getId())).execute(session);
			}catch (Exception e1) {
				logger.warn("errror rolling back");
			}
			throw e;
		}finally{
			session.release();
		}
		this.history=new TSHistory(this.getId(),request.getTsSourceId(),new Date(System.currentTimeMillis()), resource.getTitle(),request.getCreator());
		for(Operation applyedOp:resource.getCurrentsOperations().get(request.getCreator()))
			this.history.addHistoryItems(applyedOp.getHistoryItem());
		this.history.store();
		resource.discardAllOperations(request.getCreator());
		setInitializationState("Close");
	}
	
	/**
	 * 
	 */
	public void remove() {
		try{
			DBSession session= DBSession.connect();
			try{
				Utility.drop(this.getTable().getTableName()).execute(session);
			}catch(Exception e){logger.error("error deleting table",e);}
			try{	
				ObjectPersistency.get(TimeSeries.class).deleteByKey(this.getId());
			}catch(Exception e){logger.error("error deleting entry in TimeSeries table, it's could be already deleted",e);}
		}catch(Exception e){logger.error("error removing tables",e);}
		Enumeration<LinkedList<Operation>> opEnum= this.getCurrentsOperations().elements();
		while (opEnum.hasMoreElements()){
			try{
				for (Operation op: opEnum.nextElement())
					op.discard();
			}catch(Exception e){logger.error("error discarding operation");}
		}
	}

	protected void onRemove() throws ResourceException{
		this.remove();
		super.onRemove();
	}
	
	/**
     * Returns the id.
     * 
     * @return the id.
     */
    public String getId() throws ResourceException {
    	return (String) this.getResourcePropertySet().get(RP_ID).get(0);
    }
    
    /**
     * 
     * @param id
     * @throws ResourceException
     */
    public synchronized void setId(String id) throws ResourceException {
    	this.getResourcePropertySet().get(RP_ID).clear();
		this.getResourcePropertySet().get(RP_ID).add(id);
    }

    /**
     * 
     * @return
     * @throws ResourceException
     */
    public String getTitle() throws ResourceException {
    	return (String) this.getResourcePropertySet().get(RP_TITLE).get(0);
    }
    
    
    /**
     * 
     * @param title
     * @throws ResourceException
     */
    public synchronized void setTitle(String title) throws ResourceException {
    	this.getResourcePropertySet().get(RP_TITLE).clear();
		this.getResourcePropertySet().get(RP_TITLE).add(title);
    }

    /**
     * 
     * @return
     * @throws Exception
     */
    public SimpleTable getTable() throws Exception{
    	return this.table; 
    }
    
    /**
     * 
     * @return
     */
	public Status getInitializationState() {
		return initializationState;
	}

	/**
	 * 
	 * @param initializationState
	 */
	public void setInitializationState(Status initializationState) {
		this.initializationState = initializationState;
	}

	/**
	 * 
	 * @return
	 */
	public String getRelatedCurationId() {
		return relatedCurationId;
	}

	/**
	 * 
	 * @param relatedCurationId
	 */
	public void setRelatedCurationId(String relatedCurationId) {
		this.relatedCurationId = relatedCurationId;
	}

	/**
	 * 
	 * @return
	 */
	public ColumnDefinition[] getColumnsDefinition() {
		return columnsDefinition;
	}
	
	/**
	 * 
	 * @param user
	 * @return
	 */
	public ColumnDefinition[] getCurrentColumnsDefinition(String user){
		if (this.getCurrentOperation(user)!=null && this.getCurrentOperation(user).getColumnDefinition()!=null)
			return this.getCurrentOperation(user).getColumnDefinition();
		else return columnsDefinition;
		
	}

	/**
	 * 
	 * @param columnsDefinition
	 */
	public void setColumnsDefinition(ColumnDefinition[] columnsDefinition) {
		this.columnsDefinition = columnsDefinition;
	}
	
	/**
	 * 
	 * @param value
	 */
	public void setInitializationState(String value) {
		this.initializationState=Status.fromString(value);
	}   
	
	/**
	 * 
	 * @param limit
	 * @param order
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public String getAllDataAsJSon(Limit limit, Order order, String user) throws Exception{
		if (this.currentsOperations.get(user)==null){
			Select select= DBSession.getImplementation(Select.class);
			select.setTables(this.getTable());
			select.setLimit(new org.gcube.common.dbinterface.Limit(limit.getLowerLimit(), limit.getUpperLimit()));
			if (order!=null) select.setOrders(new org.gcube.common.dbinterface.Order((order.getOrder()==org.gcube.contentmanagement.timeseriesservice.stubs.types.OrderType.Ascending?OrderType.ASC:OrderType.DESC),new SimpleAttribute(order.getField())));
			return select.getResultAsJSon(true);
		}else return this.currentsOperations.get(user).getLast().getDataAsJSon(limit, order);
	}

	/**
	 * 
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public long getElementCount(String user) throws Exception{
		if (this.currentsOperations.get(user)==null){
			this.getTable().initializeCount();
			return this.getTable().getCount();
		}else return this.currentsOperations.get(user).getLast().getCount();
	}

	
	/**
	 * 
	 * @param fieldId
	 * @return
	 * @throws Exception
	 */
	public ColumnDefinition getColumnDefinitionReference(String fieldId) throws Exception{
		for (ColumnDefinition def: this.columnsDefinition)
			if (def.getId().compareTo(fieldId)==0)
				return def;
		throw new Exception("fieldId "+fieldId+" not found");	
	}

	
	/**
	 * 
	 * @param user
	 * @return
	 */
	public Operation getCurrentOperation(String user) {
		return this.currentsOperations.get(user)!=null?this.currentsOperations.get(user).getLast():null;
	}

	/**
	 * 
	 * @param user
	 * @return
	 */
	public OperationType[] getOperationList(String user){
		if (this.currentsOperations.get(user)==null) return new OperationType[0];
		OperationType[] listoperations= new OperationType[this.currentsOperations.get(user).size()];
		for (int i=0; i<this.currentsOperations.get(user).size(); i++)
			listoperations[i]=this.currentsOperations.get(user).get(i).getType();
		return listoperations;
	}
	
	/**
	 * 
	 * @param currentOperation
	 * @param user
	 */
	public void addOperation(Operation operation, String user ) {
		if (this.currentsOperations.get(user)==null){
			this.currentsOperations.put(user, new LinkedList<Operation>());
		}
		this.currentsOperations.get(user).add(operation);
	}
	
	/**
	 * 
	 * @param user
	 * @param operationClass
	 * @param parameters
	 * @throws Exception
	 */
	public synchronized void performOperation(String user,Class<? extends Operation> operationClass, Object ... parameters) throws Exception{
		logger.trace("operation");
		Operation current= operationClass.newInstance(); 
		current.setParameters(parameters);
		String previousTableName= this.getCurrentOperation(user)==null?this.getTable().getTableName():this.getCurrentOperation(user).getViewName();
		ColumnDefinition[] previousColumnsDefinition= this.getCurrentOperation(user)==null?this.getColumnsDefinition():this.getCurrentOperation(user).getColumnDefinition();
		this.addOperation(current,user);
		try{
			current.apply(previousTableName, previousColumnsDefinition);
		}catch(Exception e){ this.currentsOperations.remove(user); logger.error("error applying operation",e);throw e;}
	}
	
	/**
	 * 
	 * @param user
	 * @throws Exception
	 */
	public void discardOperation(String user) throws Exception{
		Operation op= this.currentsOperations.get(user).removeLast();
		if (this.currentsOperations.get(user).size()==0)
			this.currentsOperations.remove(user);
		try {
			op.discard();
		}catch(Exception e){logger.trace("error discarding the old operation");}
	}

	/**
	 * 
	 * @param user
	 * @throws Exception
	 */
	public void discardAllOperations(String user) throws Exception{
		LinkedList<Operation> listOperation= this.currentsOperations.get(user);
		this.currentsOperations.remove(user);
		if (listOperation!=null)
			for (Operation op: listOperation)
				try {
					op.discard();
				}catch(Exception e){logger.trace("error discarding the old operation");}
	}
	
	/**
	 * 
	 * @return
	 */
	public Hashtable<String, LinkedList<Operation>> getCurrentsOperations() {
		return this.currentsOperations;
	}

	/**
	 * 
	 * @param currentsOperations
	 */
	public void setCurrentsOperations(
			Hashtable<String, LinkedList<Operation>> currentsOperations) {
		this.currentsOperations = currentsOperations;
	}

	/**
	 * 
	 * @param req
	 * @return
	 * @throws Exception
	 */
	public String exportAsCsv(ExportRequest req) throws Exception {
		return Export.asCsv(req, this.columnsDefinition, this.getTable());
	}


	public TSHistory getHistory() {
		return history;
	}


	public void setHistory(TSHistory history) {
		this.history = history;
	}


	public void setTable(SimpleTable table) {
		this.table = table;
	}
	
	public void setTSPublished() throws Exception{
		ObjectPersistency<TimeSeries> pers= ObjectPersistency.get(TimeSeries.class);
		TimeSeries ts = pers.getByKey(this.getId());
		ts.setPublished(true);
		pers.update(ts);
	}
	
	public void publishAtVOLevel(GCUBEScope scope) throws Exception{
		ObjectPersistency<TimeSeries> pers= ObjectPersistency.get(TimeSeries.class);
		TimeSeries ts = pers.getByKey(this.getId());
		ts.setPublished(true);
		ts.setScope(scope.toString());
		pers.update(ts);
	}
	
	public String[] getDistinctValues(String fieldId, int start, int offset) throws Exception{
		DBSession session= null;
		try{
			session = DBSession.connect();
			Select select = DBSession.getImplementation(Select.class);
			select.setTables(this.getTable());
			select.setAttributes(new SimpleAttribute(fieldId));
			select.setUseDistinct(true);
			if (start>0)
				select.setLimit(new org.gcube.common.dbinterface.Limit(start,  offset));
			logger.trace("query for distinct values is "+select.getExpression());
			ResultSet result = select.getResults(session);
			ArrayList<String> listDistinctValues = new ArrayList<String>();
			while (result.next())
				listDistinctValues.add(result.getString(1));
			logger.trace("retrieved distinc values "+listDistinctValues.size());
			return listDistinctValues.toArray(new String[listDistinctValues.size()]);
		}finally{
			if (session!=null)
				session.release();
		}
	}
	
	public String getChartData(int maxDimension, String xDimension,	String yDimension,
			String groupDimension, String speciesColumn, String[] filters,
			String[] areas) throws Exception{
		StatisticsGenerator statisticsGenerator = ServiceContext.getContext().getStatisticsGenerator();
		statisticsGenerator.resetFilters();
		if (areas != null && areas.length > 0) 
			for (String area : areas)
				statisticsGenerator.addColumnFilter(groupDimension, area);
		return statisticsGenerator.generateStringGraphs(maxDimension, getTable().getTableName().toLowerCase(), xDimension, yDimension, groupDimension, speciesColumn, filters);
	}


	public String transform(final AFilter filter, String user) throws Exception{
		
		filter.setTimeSeriesName(this.currentsOperations.get(user)!=null? this.currentsOperations.get(user).getLast().getViewName(): this.getTable().getTableName());
		long start = System.currentTimeMillis();
		TSGeoToolsConfiguration geoToolConf = ServiceContext.getContext().getTSGeotoolsConfiguration();
		//TODO: eliminare ref country e ref species
		geoToolConf.setReferenceCountriesTable("ref_country");
		geoToolConf.setReferenceSpeciesTable("ref_species");
		final TimeSeriesGISConverter converter = new TimeSeriesGISConverter(geoToolConf);
		final GISInformation gisInfo= ServiceContext.getContext().getGISInformation();
		String groupName = trasformationIdGeneretor.nextUUID();
		logger.info((System.currentTimeMillis()-start)+" to initiliaze TS2Gis");
		final GISTransformationObject transformationObject = new GISTransformationObject(converter);
		converterMapping.put(groupName, transformationObject);
		
		logger.trace("stored groupName "+groupName+"? "+converterMapping.containsKey(groupName));
		new Thread(){
			public void run(){
				try{
					transformationObject.setTrasformationStatus(org.gcube.contentmanagement.timeseriesservice.stubs.types.Status.Open);
					transformationObject.setResultLayers(converter.TimeSeriesToGIS(Collections.singletonList(filter),gisInfo,false));
					transformationObject.setTrasformationStatus(org.gcube.contentmanagement.timeseriesservice.stubs.types.Status.Close);
				}catch (Exception e) {
					logger.warn("error transforming",e);
					transformationObject.setTrasformationStatus(org.gcube.contentmanagement.timeseriesservice.stubs.types.Status.Error);
					transformationObject.setCause(e.getMessage());
				}
			}
		}.start();
		
		logger.info((System.currentTimeMillis()-start)+" to start TS2Gis");
		return groupName;
	}


	public GetTransformationStatusResponse transformationStatus(String groupName) throws Exception {
		logger.trace("requesting status for groupName "+groupName);
		if (!converterMapping.containsKey(groupName)) throw new Exception("an error occurred getting the status");
		GISTransformationObject gisTrasformationObject = converterMapping.get(groupName);
		//TODO: remember to federico 
		//if (gisTrasformationObject.getTrasformationStatus()==Status.Error || gisTrasformationObject.getTrasformationStatus()==Status.Close) converterMapping.remove(groupName);
		GetTransformationStatusResponse toReturn =new GetTransformationStatusResponse();
		toReturn.setCause(gisTrasformationObject.getCause());
		toReturn.setStatus(gisTrasformationObject.getTrasformationStatus());
		if (gisTrasformationObject.getResultLayers()!=null)
			toReturn.setResutLayers(gisTrasformationObject.getResultLayers().toArray(new String[gisTrasformationObject.getResultLayers().size()]));
		switch (gisTrasformationObject.getType()) {
		case FishingMontlyEffort:
			toReturn.setPercent(gisTrasformationObject.getAggregator().getStatus());
			break;
		case GIStransformation:
			toReturn.setPercent(gisTrasformationObject.getConverter().getStatus());
			break;
		default:
			break;
		}
		return toReturn;
	}


	public String getFishingMontlyEffort(final GetFishingMontlyEffortRequest request) throws Exception {
		long start = System.currentTimeMillis();
		final String tableName = this.currentsOperations.get(request.getUser())!=null? this.currentsOperations.get(request.getUser()).getLast().getViewName(): this.getTable().getTableName() ;
		TSGeoToolsConfiguration geoToolConf = ServiceContext.getContext().getTSGeotoolsConfiguration();
		final VTIEffortAggregator effortAggregator = new VTIEffortAggregator(geoToolConf);
		final GISInformation gisInfo= ServiceContext.getContext().getGISInformation();
		String groupName = trasformationIdGeneretor.nextUUID();
		logger.info((System.currentTimeMillis()-start)+" to initiliaze FishingMontlyEffort with groupName "+groupName);
		final ColumnDefinition[] columnsDef = this.currentsOperations.get(request.getUser())!=null? this.currentsOperations.get(request.getUser()).getLast().getColumnDefinition() : this.getColumnsDefinition();
		final GISTransformationObject transformationObject = new GISTransformationObject(effortAggregator);
		converterMapping.put(groupName, transformationObject);
		new Thread(){
			public void run(){
				try{
					transformationObject.setTrasformationStatus(org.gcube.contentmanagement.timeseriesservice.stubs.types.Status.Open);
					HashMap<String , String> field2user = new HashMap<String, String>();
					for (ColumnDefinition def : columnsDef)
						field2user.put(def.getId(), def.getLabel());
					effortAggregator.produceMontlyEffort(tableName, request.getMessageIdColumn(), request.getXDimColumn(), request.getYDimColumn(), request.getDatesColumn(), request.getFishingHoursDimension(), request.getSpeedColumn(), gisInfo, request.isProduceVTI(), request.isAppendMode(), field2user);
					transformationObject.setResultLayers(effortAggregator.produceMontlyEffort(tableName, request.getMessageIdColumn(), request.getXDimColumn(), request.getYDimColumn(), request.getDatesColumn(), request.getFishingHoursDimension(), request.getSpeedColumn(), gisInfo, request.isProduceVTI(), request.isAppendMode(), field2user));
					transformationObject.setTrasformationStatus(org.gcube.contentmanagement.timeseriesservice.stubs.types.Status.Close);
				}catch (Exception e) {
					logger.warn("error getting FishingMontlyEffort",e);
					transformationObject.setTrasformationStatus(org.gcube.contentmanagement.timeseriesservice.stubs.types.Status.Error);
					transformationObject.setCause(e.getMessage());
				}
			}
		}.start();
		
		logger.info((System.currentTimeMillis()-start)+" to start getFishingMontlyEffort");
		return groupName;
	}
}
