package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.CastObject;
import org.gcube.common.dbinterface.attributes.AggregatedAttribute;
import org.gcube.common.dbinterface.attributes.AggregationFunctions;
import org.gcube.common.dbinterface.attributes.AssignedAttribute;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.state.CurationResource;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.AggregateRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.AggregationFunction;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.DataType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.OperationType;


public class Aggregation extends Operation{

	/**
	 * 
	 */
	private static final long serialVersionUID = -6364572465285031383L;

	private static GCUBELog logger= new GCUBELog(Aggregation.class);
	
	private AggregationFunction aggregationFuncion;
	private String[] aggregationfields;
	
	public Aggregation() {
		super();
		this.type= OperationType.Aggregation;
		this.viewName="a"+uuidGen.nextUUID().replaceAll("-", "");
	}
	
	
	@Override
	public void initialize(String previuosTableName, ColumnDefinition[] previousTableDefinition, DBSession session) throws Exception {
		List<SimpleAttribute> groupingAttributes= new ArrayList<SimpleAttribute>();
		ArrayList<ColumnDefinition> newColumnDefinition= new ArrayList<ColumnDefinition>();
		List<Attribute> selectAttributes= new ArrayList<Attribute>();
		for (ColumnDefinition def:previousTableDefinition){
			if (Arrays.binarySearch(aggregationfields, def.getId())<0){
				newColumnDefinition.add(def);
				if (def.getColumnType()==EntryType.Value){
					selectAttributes.add(new AssignedAttribute<AggregatedAttribute>(new SimpleAttribute(def.getId()),new AggregatedAttribute(def.getId(),AggregationFunctions.valueOf(this.aggregationFuncion.getValue()))));
				}else {
					SimpleAttribute attr= new SimpleAttribute(def.getId());
					if (def.getColumnType()==EntryType.Dimension){
						SimpleAttribute idAttribute= new SimpleAttribute(def.getId()+CurationResource.ID_COLUMN_SUFFIX);
						groupingAttributes.add(attr);
						groupingAttributes.add(idAttribute);
						selectAttributes.add(attr);
						selectAttributes.add(idAttribute);
					}else{
						groupingAttributes.add(attr);
						selectAttributes.add(attr);
					}
				}
			} else {
				newColumnDefinition.add(new ColumnDefinition(EntryType.Attribute,null, null, def.getId(),null, def.getLabel(), DataType.Text));
				selectAttributes.add(new AssignedAttribute<CastObject>(new SimpleAttribute(def.getId()),Utility.getCastToString("All")));
				//groupingAttributes.add(new SimpleAttribute(def.getId()));
			}
		}
				
		setColumnDefinition(newColumnDefinition.toArray(new ColumnDefinition[0]));
		Select query= DBSession.getImplementation(Select.class);
		query.setAttributes(selectAttributes.toArray(new Attribute[0]));
		query.setTables(new Table(previuosTableName));
		query.setGroups(groupingAttributes.toArray(new SimpleAttribute[0]));
		this.createTable(query, session, false);
		logger.trace("aggregation query: "+query.getExpression());
		
		InsertFromSelect insert=DBSession.getImplementation(InsertFromSelect.class);
		insert.setSubQuery(query);
		insert.setTable(this.viewTable);
				
		logger.trace("table created with query: "+insert.getExpression());
		insert.execute(session);
		//changeColumnId();
				
		setCount(this.viewTable.getCount());
		
		//History item creation
		String aggregatedFields=" ";
		for (String field: this.aggregationfields)
			aggregatedFields+=getColumnDefinitionReference(field, previousTableDefinition).getLabel()+" ";
		setHistoryItem(new TSHistoryItem(query.toString(),"aggregation applied at fields ["+aggregatedFields+"] using function "+this.aggregationFuncion,new Date(),OperationType.Aggregation));
		logger.trace("count calculated in "+getCount());
		logger.trace("aggragation intialization finished");
	}

	@Override
	public void setParameters(Object... parameters) throws Exception {
		AggregateRequest request= (AggregateRequest)parameters[0];
		this.aggregationFuncion= request.getAggregateFunction();
		this.aggregationfields= request.getFieldList();
		logger.trace("aggregation fields are "+this.aggregationfields.length);
	}

}

