package org.gcube.contentmanagement.timeseriesservice.impl.timeseries;

import java.sql.Timestamp;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.persistence.ObjectNotFoundException;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;

@TableRootDefinition
public class TimeSeries {

	@FieldDefinition(specifications={Specification.PRIMARY_KEY},precision={50})
	private String id;
	@FieldDefinition(specifications={Specification.NOT_NULL},precision={150})
	private String title;
	@FieldDefinition(specifications={Specification.NOT_NULL})
	private String description;
	@FieldDefinition(specifications={Specification.NOT_NULL},precision={150})
	private String creator;
	@FieldDefinition(specifications={Specification.NOT_NULL},precision={150})
	private String publisher;
	@FieldDefinition(specifications={Specification.NOT_NULL},precision={50})
	private String type;
	@FieldDefinition(specifications={Specification.NOT_NULL},precision={50})
	private String sourceId;
	@FieldDefinition(specifications={Specification.NOT_NULL},precision={150})
	private String sourceName;
	@FieldDefinition(precision={50})
	private String isVersionOf="";
	@FieldDefinition(specifications={Specification.NOT_NULL})
	private String rights;
	@FieldDefinition(specifications={Specification.NOT_NULL})
	private Timestamp date;
	@FieldDefinition(specifications={Specification.NOT_NULL},precision={10})
	private int legth;
	@FieldDefinition(specifications={Specification.NOT_NULL})
	private boolean published= false;
	@FieldDefinition(specifications={Specification.NOT_NULL})
	private String users;
	@FieldDefinition(specifications={Specification.NOT_NULL},precision={150})
	private String scope;
	
	
	
	public TimeSeries(String id){
		this.id = id;
		this.date= new Timestamp(System.currentTimeMillis());
	}
	
	@SuppressWarnings("unused")
	private TimeSeries(){}
		
	/**
	 * @return the type
	 */
	public String getType() {
		return type;
	}

	/**
	 * @param type the type to set
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * @return the title
	 */
	public String getTitle() {
		return title;
	}
	/**
	 * @param title the title to set
	 */
	public void setTitle(String title) {
		this.title = title;
	}
	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}
	/**
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}
		
	/**
	 * @return the cretor
	 */
	public String getCreator() {
		return creator;
	}

	/**
	 * @param cretor the cretor to set
	 */
	public void setCreator(String creator) {
		this.creator = creator;
	}

	
	
	
	/**
	 * @return the publisher
	 */
	public String getPublisher() {
		return publisher;
	}


	/**
	 * @param publisher the publisher to set
	 */
	public void setPublisher(String publisher) {
		this.publisher = publisher;
	}


	/**
	 * @return the sourceId
	 */
	public String getSourceId() {
		return sourceId;
	}
	/**
	 * @param sourceId the sourceId to set
	 */
	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}
	/**
	 * @return the sourceName
	 */
	public String getSourceName() {
		return sourceName;
	}
	/**
	 * @param sourceName the sourceName to set
	 */
	public void setSourceName(String sourceName) {
		this.sourceName = sourceName;
	}
	/**
	 * @return the isVersionOf
	 */
	public String getIsVersionOf() {
		return isVersionOf;
	}
	/**
	 * @param isVersionOf the isVersionOf to set
	 */
	public void setIsVersionOf(String isVersionOf) {
		this.isVersionOf = isVersionOf;
	}
	/**
	 * @return the rights
	 */
	public String getRights() {
		return rights;
	}
	/**
	 * @param rights the rights to set
	 */
	public void setRights(String rights) {
		this.rights = rights;
	}
	/**
	 * @return the date
	 */
	public Timestamp getDate() {
		return date;
	}
	/**
	 * @param date the date to set
	 */
	public void setDate(Timestamp date) {
		this.date = date;
	}
	/**
	 * @return the legth
	 */
	public int getLegth() {
		return legth;
	}
	/**
	 * @param legth the legth to set
	 */
	public void setLegth(int legth) {
		this.legth = legth;
	}
	/**
	 * @return the published
	 */
	public boolean isPublished() {
		return published;
	}
	/**
	 * @param published the published to set
	 */
	public void setPublished(boolean published) {
		this.published = published;
	}
	/**
	 * @return the users
	 */
	public String getUsers() {
		return users;
	}
	/**
	 * @param users the users to set
	 */
	public void setUsers(String users) {
		this.users = users;
	}
	/**
	 * @return the scope
	 */
	public String getScope() {
		return scope;
	}
	/**
	 * @param scope the scope to set
	 */
	public void setScope(String scope) {
		this.scope = scope;
	}
	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}
	
	public void store() throws Exception{
		ObjectPersistency<TimeSeries> persistency= ObjectPersistency.get(TimeSeries.class);
		if(!persistency.existsKey(this.id))
			persistency.insert(this);
		else persistency.update(this);
	}
	
	public void delete() throws Exception{
		ObjectPersistency<TimeSeries> persistency= ObjectPersistency.get(TimeSeries.class);
		if(persistency.getByKey(this.id)==null)
			return;
		else persistency.deleteByKey(this.getId());
	}
	
	public static TimeSeries get(String id) throws Exception{
		ObjectPersistency<TimeSeries> persistency= ObjectPersistency.get(TimeSeries.class);
		TimeSeries ts;
		if((ts=persistency.getByKey(id))==null)
			throw new ObjectNotFoundException();
		return ts;
	}
	
	public static String getTableName() throws Exception{
		return ObjectPersistency.get(TimeSeries.class).getTable().getTableName();
	}
	
}
