package org.gcube.contentmanagement.timeseriesservice.impl.curation.guessing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.contentmanagement.codelistmanager.entities.CodeList;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.data.SingleResult;
import org.gcube.contentmanagement.timeseriesservice.impl.codelist.wrappers.CLManagerWrapper;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Dimension;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.GuessDimension;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.GuessDimensionArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Key;

public class GuessingPrefetcher implements Runnable {

	private static GCUBELog logger= new GCUBELog(GuessingPrefetcher.class);
	
	private String tableName;
	private ColumnDefinition[] 	columnDefintionArray;
	private String resourceId;
	
	public GuessingPrefetcher(String tableName, String resourceId, ColumnDefinition[] columnDefintionArray) {
		super();
		this.columnDefintionArray = columnDefintionArray;
		this.tableName = tableName;		
		this.resourceId = resourceId;
	}



	public void run() {
		ObjectPersistency<GuessingObject> persistentGuessing;
		GuessingObject go;
		try{
			persistentGuessing = ObjectPersistency.get(GuessingObject.class);
			go = new GuessingObject(this.resourceId);
			persistentGuessing.insert(go);
		}catch (Exception e) {
			logger.error("error persisting the guess results",e);
			return;
		}
		HashMap<String,GuessDimensionArray> table= new HashMap<String, GuessDimensionArray>(columnDefintionArray.length);
		for (ColumnDefinition cd: columnDefintionArray){
			logger.trace("starting guessing for "+cd.getId());
			try {
				GuessDimensionArray dimArray= GuessingPrefetcher.guess(tableName,cd.getId(), ServiceContext.getContext().getScope());
				table.put(cd.getId(), dimArray);
				go.setGuessingMap(table);
				persistentGuessing.update(go);
			} catch (Exception e) {logger.warn("cannot calculate guess for field "+cd.getId(),e);}
		}
	}

	
	public static GuessDimensionArray guess(String tableName, String fieldId, GCUBEScope scope) throws Exception{
		logger.trace("starting the guessing method");
		ServiceContext.getContext().getGuesser().runGuesser(tableName, fieldId);
		ArrayList<SingleResult> results = ServiceContext.getContext().getGuesser().getClassification();
		
		logger.trace("initliazed LexicalEngine and get back "+results.size()+" results for "+fieldId);
		
		List<GuessDimension> guessDimlist= new ArrayList<GuessDimension>();
		
		for (SingleResult res: results){
			logger.trace(res.getColumn()+" "+res.getCategory()+" "+res.getScore());
			GuessDimension dim= new GuessDimension();
			SimpleTable dimTable= new SimpleTable(res.getTablename());
			Type type=dimTable.getFieldsMapping().get(res.getColumn());
			String fieldName;
			try{
				CLManagerWrapper clWrapper = CLManagerWrapper.get(res.getFamilyID());
				logger.info(clWrapper.getCodelistId()+" scope is "+clWrapper.getScope());
				logger.info(" passed scope is "+scope);
				if (!clWrapper.getScope().equals(scope)){
					logger.info("codelist skipped");
					continue;
				}
				CodeList codelist = CodeList.get(res.getFamilyID());
				fieldName= codelist.getLabelFieldMapping().get(res.getColumn()).getFieldName();
				dim.setDimension(new Dimension(res.getFamilyID(),new Key[]{new Key(res.getColumn(), fieldName, Util.mapSqlToJava(type.getType()))} , res.getCategory()));
				dim.setPercentage(res.getScore());
				guessDimlist.add(dim);
			}catch (Exception e) {
				logger.warn("result "+res.getColumn()+" | "+res.getCategory()+" cannot be retreived");
			}
		}
		return new GuessDimensionArray(guessDimlist.toArray(new GuessDimension[guessDimlist.size()]));
	}
	
	public static GuessDimensionArray getGuessing(String resourceId, String fieldId) throws Exception{
		return ObjectPersistency.get(GuessingObject.class).getByKey(resourceId).getGuessingMap().get(fieldId);
	}
	
	public static void deliteGuessing(String resourceId) throws Exception{
		ObjectPersistency.get(GuessingObject.class).deleteByKey(resourceId);
	}
}
