/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.test;

import com.Ostermiller.util.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateImportResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.StartResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.State;
import org.gcube.contentmanagement.timeseriesservice.stubs.calls.RSWrapper;
import org.gcube.contentmanagement.timeseriesservice.stubs.calls.curation.CurationFactoryCall;
import org.gcube.contentmanagement.timeseriesservice.stubs.calls.curation.CurationServiceCall;
import org.gcube.contentmanagement.timeseriesservice.stubs.calls.importer.ImporterFactoryCall;
import org.gcube.contentmanagement.timeseriesservice.stubs.calls.importer.ImporterServiceCall;

public class TestTotal {
    public static void main(String[] args) throws Exception {
        GCUBESecurityManagerImpl secMan = new GCUBESecurityManagerImpl(){

            public boolean isSecurityEnabled() {
                return false;
            }
        };
        ImporterFactoryCall ifc = new ImporterFactoryCall(GCUBEScope.getScope((String)"/gcube/devsec"), new GCUBESecurityManager[]{secMan});
        CreateImportResponse response = ifc.create("lucio-test", "test", "lucio.lelii", "pisa", "", "", "");
        System.out.println("resource importer created " + response.getReferenceId());
        ImporterServiceCall isc = new ImporterServiceCall(response.getEndpointReference(), GCUBEScope.getScope((String)"/gcube/devsec"), (GCUBESecurityManager)secMan);
        System.out.println("resource contacted");
        RSWrapper wrapRs = new RSWrapper(GCUBEScope.getScope((String)"/gcube/devsec"));
        File file = new File(args[0]);
        FileInputStream fis = new FileInputStream(file);
        File tmpFile = File.createTempFile("lucio", ".pippo");
        FileOutputStream outstream = new FileOutputStream(tmpFile);
        Base64.encode((InputStream)fis, (OutputStream)outstream);
        outstream.close();
        wrapRs.add(tmpFile);
        wrapRs.close();
        isc.importData(wrapRs, ',', "Utf-8", true, new boolean[]{true, true, true, true, true, true, false, false});
        System.out.println(isc.getProgress());
        Thread.sleep(4000L);
        while (isc.getProgress().getTotalLine() > isc.getProgress().getLineCount()) {
            Thread.sleep(3000L);
        }
        CurationFactoryCall fcall = new CurationFactoryCall(GCUBEScope.getScope((String)"/gcube/devsec"), new GCUBESecurityManager[]{secMan});
        StartResponse resp = fcall.startCuration("prova", "", "", response.getReferenceId());
        CurationServiceCall scall = new CurationServiceCall(resp.getEndpointReference(), GCUBEScope.getScope((String)"/gcube/devsec"), (GCUBESecurityManager)secMan);
        while (scall.isUnderInitialization() == State.Open) {
            Thread.sleep(1000L);
        }
        scall.replaceEntryValue("FAO", "MAO", "field0");
        scall.editDimension("4", "field1", "NAME_EN");
    }

    public static void streamToFile(InputStream instream, OutputStream out) throws Exception {
        try {
            int len;
            byte[] buf = new byte[8096];
            int sum = 0;
            while ((len = instream.read(buf)) >= 0) {
                sum += len;
                out.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            if (instream != null) {
                instream.close();
            }
            if (out != null) {
                out.close();
            }
            throw e;
        }
    }
}

