/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.test;

import java.io.InputStream;
import java.io.OutputStream;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.contentmanagement.timeseriesservice.stubs.AggregationFunction;
import org.gcube.contentmanagement.timeseriesservice.stubs.CurrentState;
import org.gcube.contentmanagement.timeseriesservice.stubs.Filter;
import org.gcube.contentmanagement.timeseriesservice.stubs.FilterCondition;
import org.gcube.contentmanagement.timeseriesservice.stubs.Limit;
import org.gcube.contentmanagement.timeseriesservice.stubs.NumberOperator;
import org.gcube.contentmanagement.timeseriesservice.stubs.OperationType;
import org.gcube.contentmanagement.timeseriesservice.stubs.Operator;
import org.gcube.contentmanagement.timeseriesservice.stubs.SimpleFilter;
import org.gcube.contentmanagement.timeseriesservice.stubs.calls.timeseries.TimeSeriesFactoryCall;
import org.gcube.contentmanagement.timeseriesservice.stubs.calls.timeseries.TimeSeriesServiceCall;

public class OpenTS {
    public static void main(String[] args) throws Exception {
        CurrentState currentState;
        GCUBESecurityManagerImpl secMan = new GCUBESecurityManagerImpl(){

            public boolean isSecurityEnabled() {
                return false;
            }
        };
        TimeSeriesFactoryCall fc = new TimeSeriesFactoryCall(GCUBEScope.getScope((String)"/gcube/devsec"), new GCUBESecurityManager[]{secMan});
        TimeSeriesServiceCall tscall = new TimeSeriesServiceCall("test.user", fc.open(args[0], args[1]), GCUBEScope.getScope((String)"/gcube/devsec"), (GCUBESecurityManager)secMan);
        tscall.aggregate(AggregationFunction.AVG, "field5", "field1");
        while ((currentState = tscall.getCurrentState()) == CurrentState.InProgress) {
            System.out.println(currentState);
            System.out.println("waiting for state closed");
            Thread.sleep(1000L);
        }
        if (currentState == CurrentState.Error) {
            System.out.println("an errror occurs");
            try {
                tscall.discardCurrentOperation();
            }
            catch (Exception e) {
                System.out.println("error discarding");
            }
            throw new Exception("an error occurs");
        }
        System.out.println(tscall.getAllDataAsJSon(new Limit(0, 30), null));
        tscall.filter(new FilterCondition(null, new Filter(null, new SimpleFilter("field5", new Operator(null, NumberOperator.GTEQ, null), "5"))));
        while ((currentState = tscall.getCurrentState()) == CurrentState.InProgress) {
            System.out.println(currentState);
            System.out.println("waiting for state closed");
            Thread.sleep(1000L);
        }
        if (currentState == CurrentState.Error) {
            System.out.println("an errror occurs");
            try {
                tscall.discardCurrentOperation();
            }
            catch (Exception e) {
                System.out.println("error discarding");
            }
            throw new Exception("an error occurs");
        }
        for (OperationType op : tscall.getOperationsList()) {
            System.out.println(op.getValue());
        }
    }

    public static void streamToFile(InputStream instream, OutputStream out) throws Exception {
        try {
            int len;
            byte[] buf = new byte[8096];
            int sum = 0;
            while ((len = instream.read(buf)) >= 0) {
                sum += len;
                out.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            if (instream != null) {
                instream.close();
            }
            if (out != null) {
                out.close();
            }
            throw e;
        }
    }
}

