/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.util.ArrayList;
import net.sf.csv4j.CSVWriter;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.stubs.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.ExportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.calls.RSWrapper;

public class Export {
    public static GCUBELog logger = new GCUBELog(Export.class);

    public static String asCsv(final ExportRequest req, ColumnDefinition[] definitionsArray, SimpleTable table) throws Exception {
        ResultSet selectQueryRS;
        CSVWriter csvWriter;
        OutputStreamWriter osw;
        logger.debug((Object)("export as csv method with delimiter " + req.getDelimiter() + " "));
        final ArrayList<SimpleAttribute> fieldsNameInDb = new ArrayList<SimpleAttribute>(definitionsArray.length);
        final ArrayList<String> fieldsName = new ArrayList<String>();
        for (int i = 0; i < definitionsArray.length; ++i) {
            ColumnDefinition columnDefinition = definitionsArray[i];
            if (!req.getFieldsMask()[i]) continue;
            fieldsName.add(columnDefinition.getLabel());
            fieldsNameInDb.add(new SimpleAttribute(columnDefinition.getId()));
        }
        final File file = File.createTempFile("tsExport", ".csv");
        DBSession session = null;
        try {
            FileOutputStream fos = new FileOutputStream(file);
            osw = new OutputStreamWriter((OutputStream)fos, req.getEncoding());
            csvWriter = new CSVWriter((Writer)osw, req.getDelimiter().charAt(0));
            session = DBSession.connect();
            Select selectQuery = (Select)DBSession.getImplementation(Select.class);
            selectQuery.setAttributes(fieldsNameInDb.toArray(new Attribute[0]));
            selectQuery.setTables(new Table[]{table});
            selectQueryRS = selectQuery.getResults(session, new boolean[0]);
        }
        catch (Exception e) {
            logger.error((Object)"error exporting the file", (Throwable)e);
            throw e;
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
        logger.debug((Object)"initializing the stream");
        final RSWrapper rsWrapper = new RSWrapper(ServiceContext.getContext().getScope());
        logger.debug((Object)"entering in the thread");
        new Thread(){

            @Override
            public void run() {
                try {
                    if (req.isHasHeader()) {
                        csvWriter.writeLine(fieldsName);
                    }
                    while (selectQueryRS.next()) {
                        ArrayList<String> rowString = new ArrayList<String>();
                        for (SimpleAttribute fieldAttribute : fieldsNameInDb) {
                            String value = selectQueryRS.getString(fieldAttribute.getAttributeName());
                            rowString.add(value == null ? "" : value);
                        }
                        try {
                            csvWriter.writeLine(rowString);
                        }
                        catch (Exception e) {
                            logger.error((Object)"error writing into outputStream ", (Throwable)e);
                        }
                    }
                    try {
                        osw.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"error closing the stream", (Throwable)e);
                    }
                    logger.trace((Object)file.getAbsolutePath());
                    rsWrapper.add(file);
                    rsWrapper.close();
                    logger.debug((Object)"export finished");
                }
                catch (Exception e) {
                    logger.error((Object)"error filling the RS thread ", (Throwable)e);
                }
            }
        }.start();
        return rsWrapper.getLocator().toString();
    }

    public static String codeListAsCsv(SimpleTable table, String codelistName, final boolean header) throws Exception {
        ResultSet selectQueryRS;
        CSVWriter csvWriter;
        OutputStreamWriter osw;
        final File file = File.createTempFile("tsExport", ".csv");
        DBSession session = null;
        try {
            FileOutputStream fos = new FileOutputStream(file);
            osw = new OutputStreamWriter((OutputStream)fos, "utf-8");
            csvWriter = new CSVWriter((Writer)osw, ',');
            session = DBSession.connect();
            Select selectQuery = (Select)DBSession.getImplementation(Select.class);
            selectQuery.setTables(new Table[]{table});
            selectQueryRS = selectQuery.getResults(session, new boolean[0]);
        }
        catch (Exception e) {
            logger.error((Object)"error exporting the file", (Throwable)e);
            throw e;
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
        logger.debug((Object)"initializing the stream");
        final RSWrapper rsWrapper = new RSWrapper(ServiceContext.getContext().getScope());
        logger.debug((Object)"entering in the thread");
        new Thread(){

            @Override
            public void run() {
                try {
                    int i;
                    if (header) {
                        ArrayList<String> columnsName = new ArrayList<String>();
                        for (i = 1; i <= selectQueryRS.getMetaData().getColumnCount(); ++i) {
                            columnsName.add(selectQueryRS.getMetaData().getColumnName(i));
                        }
                        csvWriter.writeLine(columnsName);
                    }
                    while (selectQueryRS.next()) {
                        ArrayList<String> rowString = new ArrayList<String>();
                        for (i = 1; i <= selectQueryRS.getMetaData().getColumnCount(); ++i) {
                            String value = selectQueryRS.getString(i);
                            rowString.add(value == null ? "" : value);
                        }
                        try {
                            csvWriter.writeLine(rowString);
                        }
                        catch (Exception e) {
                            logger.error((Object)"error writing into outputStream ", (Throwable)e);
                        }
                    }
                    try {
                        osw.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"error closing the stream", (Throwable)e);
                    }
                    logger.trace((Object)file.getAbsolutePath());
                    rsWrapper.add(file);
                    rsWrapper.close();
                    logger.debug((Object)" codelist export finished");
                }
                catch (Exception e) {
                    logger.error((Object)"error filling the RS thread ", (Throwable)e);
                }
            }
        }.start();
        return rsWrapper.getLocator().toString();
    }
}

