/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.state;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Order;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CreateTableLike;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.queries.alters.RenameTable;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.graphtools.core.StatisticsGenerator;
import org.gcube.contentmanagement.timeseries.geotools.engine.TSGeoToolsConfiguration;
import org.gcube.contentmanagement.timeseries.geotools.engine.TimeSeriesGISConverter;
import org.gcube.contentmanagement.timeseries.geotools.filters.AFilter;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISInformation;
import org.gcube.contentmanagement.timeseries.geotools.vti.VTIEffortAggregator;
import org.gcube.contentmanagement.timeseriesservice.impl.context.CurationContext;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.context.TimeSeriesContext;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.state.CurationResource;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistory;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.TimeSeries;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.Operation;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Constants;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Export;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.GISTransformationObject;
import org.gcube.contentmanagement.timeseriesservice.stubs.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateFromTsRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateTsRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.ExportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetFishingMontlyEffortRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetTransformationStatusResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.Limit;
import org.gcube.contentmanagement.timeseriesservice.stubs.OperationType;
import org.gcube.contentmanagement.timeseriesservice.stubs.OrderType;
import org.gcube.contentmanagement.timeseriesservice.stubs.State;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;

public class TimeSeriesResource
extends GCUBEWSResource {
    private static volatile GCUBELog logger = new GCUBELog(TimeSeriesResource.class);
    private static volatile HashMap<String, GISTransformationObject> converterMapping = new HashMap();
    private Hashtable<String, LinkedList<Operation>> currentsOperations;
    private TSHistory history;
    protected static final String RP_ID = "Id";
    protected static final String RP_TITLE = "Title";
    protected static String[] RPNames = new String[]{"Id", "Title"};
    public long count;
    public State initializationState;
    public String relatedCurationId;
    public ColumnDefinition[] columnsDefinition;
    public String[] tableDefinition;
    private SimpleTable table;

    public String[] getPropertyNames() {
        return RPNames;
    }

    protected void initialise(Object ... arg) throws Exception {
        this.initializationState = State.Open;
        this.currentsOperations = new Hashtable();
        this.count = -1L;
        try {
            String id = (String)arg[0];
            this.setId(id);
            if (((Boolean)arg[2]).booleanValue()) {
                this._intialize((CreateTsRequest)arg[1]);
            } else {
                this._intialize((CreateFromTsRequest)arg[1]);
            }
        }
        catch (Exception e) {
            this.initializationState = State.Error;
            logger.error((Object)"errror initializing TS", (Throwable)e);
            throw e;
        }
    }

    protected long getCount() {
        return this.count;
    }

    protected void setCount(long count) {
        this.count = count;
    }

    protected void _intialize(CreateTsRequest request) throws Exception {
        try {
            this.relatedCurationId = request.getRelatedCurationId();
            final CurationResource curationResource = (CurationResource)CurationContext.getPortTypeContext().getWSHome().find((ResourceKey)CurationContext.getPortTypeContext().makeKey(this.relatedCurationId));
            this.setColumnsDefinition(curationResource.getColumnDefinition());
            String sourceId = curationResource.getId();
            String sourceName = curationResource.getTitle();
            this.setTitle(request.getTitle());
            final DBSession session = DBSession.connect();
            int length = (int)curationResource.getCount(false);
            TimeSeries ts = new TimeSeries(this.getId());
            ts.setTitle(request.getTitle());
            ts.setDescription(request.getDescription());
            ts.setCreator(request.getCreator());
            ts.setPublisher(request.getPublisher());
            ts.setType(request.getType());
            ts.setSourceId(sourceId);
            ts.setSourceName(sourceName);
            ts.setRights(request.getRights());
            ts.setLegth(length);
            ts.setUsers(" " + request.getCreator() + " ");
            ts.setScope(ServiceContext.getContext().getScope().toString());
            String tsResourceid = this.getId();
            CreateTableLike createLikeQuery = (CreateTableLike)DBSession.getImplementation(CreateTableLike.class);
            createLikeQuery.setTableLike(curationResource.getTable());
            createLikeQuery.setTableName(Constants.getTimeSeriesTable(tsResourceid));
            this.table = createLikeQuery.execute(session);
            ts.store();
            this.store();
            this.history = new TSHistory(this.getId(), this.relatedCurationId, new Date(System.currentTimeMillis()), curationResource.getHistory().getItems().size(), sourceName, request.getCreator());
            this.history.store();
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Utility.dropColumn((String)"id", (Table)TimeSeriesResource.this.getTable()).execute(session);
                        ArrayList<SimpleAttribute> firstAttributes = new ArrayList<SimpleAttribute>();
                        ArrayList<SimpleAttribute> lastAttributes = new ArrayList<SimpleAttribute>();
                        for (ColumnDefinition def : curationResource.getColumnDefinition()) {
                            firstAttributes.add(new SimpleAttribute(def.getId()));
                            if (def.getColumnType() != EntryType.Dimension) continue;
                            String fieldName = def.getId() + "_id";
                            lastAttributes.add(new SimpleAttribute(fieldName));
                            Utility.createIndexOnField((Table)TimeSeriesResource.this.getTable(), (String)fieldName, (boolean)false);
                        }
                        Collections.addAll(firstAttributes, lastAttributes.toArray(new Attribute[0]));
                        Select curationSelect = (Select)DBSession.getImplementation(Select.class);
                        curationSelect.setAttributes(firstAttributes.toArray(new Attribute[0]));
                        curationSelect.setTables(new Table[]{curationResource.getTable()});
                        InsertFromSelect insertTs = (InsertFromSelect)DBSession.getImplementation(InsertFromSelect.class);
                        insertTs.setSubQuery(curationSelect);
                        insertTs.setTable(TimeSeriesResource.this.getTable());
                        insertTs.execute(session);
                        TimeSeriesResource.this.setInitializationState("Close");
                        logger.trace((Object)"initialization set to closed");
                    }
                    catch (Exception e) {
                        TimeSeriesResource.this.setInitializationState("Error");
                        logger.error((Object)"errror initializing TS", (Throwable)e);
                        TimeSeriesResource.this.remove();
                    }
                    finally {
                        if (session != null) {
                            session.release();
                        }
                    }
                }
            }.start();
        }
        catch (Exception e) {
            this.initializationState = State.Error;
            logger.error((Object)"errror initializing TS", (Throwable)e);
            throw e;
        }
    }

    protected void _intialize(CreateFromTsRequest request) throws Exception {
        TimeSeriesResource resource = (TimeSeriesResource)TimeSeriesContext.getPortTypeContext().getWSHome().find((ResourceKey)TimeSeriesContext.getPortTypeContext().makeKey(request.getTsSourceId()));
        logger.debug((Object)("the source Id is " + request.getTsSourceId() + " and sourceTitle is " + resource.getTitle()));
        logger.debug((Object)("the count is: " + resource.getElementCount(request.getCreator())));
        this.setTitle(request.getTitle());
        long elementCount = resource.getElementCount(request.getCreator());
        this.setCount(elementCount);
        this.setColumnsDefinition(resource.getCurrentColumnsDefinition(request.getCreator()));
        DBSession session = DBSession.connect();
        logger.trace((Object)("the source ID is " + request.getTsSourceId()));
        TimeSeries ts = null;
        try {
            RenameTable renameTable = (RenameTable)DBSession.getImplementation(RenameTable.class);
            renameTable.setNewName(Constants.getTimeSeriesTable(this.getId()));
            renameTable.setTable(new Table(resource.getCurrentOperation(request.getCreator()).getViewName()));
            logger.trace((Object)("the new ts with id " + this.getId() + " is being created with query: " + renameTable.getExpression()));
            this.table = renameTable.execute(session);
            ts = new TimeSeries(this.getId());
            ts.setTitle(request.getTitle());
            ts.setDescription(request.getDescription());
            ts.setCreator(request.getCreator());
            ts.setPublisher(request.getPublisher());
            ts.setType(request.getType());
            ts.setSourceId(request.getTsSourceId());
            ts.setSourceName(resource.getTitle());
            ts.setRights(request.getRights());
            ts.setLegth((int)elementCount);
            ts.setUsers(" " + request.getCreator() + " ");
            ts.setScope(ServiceContext.getContext().getScope().toString());
            ts.store();
        }
        catch (Exception e) {
            logger.error((Object)("error saving the TS with id " + this.getId() + " trying the rollback"));
            try {
                if (ts != null) {
                    ts.delete();
                }
                Utility.drop((String)Constants.getTimeSeriesTable(this.getId())).execute(session);
            }
            catch (Exception e1) {
                logger.warn((Object)"errror rolling back");
            }
            throw e;
        }
        finally {
            session.release();
        }
        this.history = new TSHistory(this.getId(), request.getTsSourceId(), new Date(System.currentTimeMillis()), resource.getTitle(), request.getCreator());
        for (Operation applyedOp : resource.getCurrentsOperations().get(request.getCreator())) {
            this.history.addHistoryItems(applyedOp.getHistoryItem());
        }
        this.history.store();
        resource.discardAllOperations(request.getCreator());
        this.setInitializationState("Close");
    }

    public void remove() {
        try {
            DBSession session = DBSession.connect();
            try {
                Utility.drop((String)this.getTable().getTableName()).execute(session);
            }
            catch (Exception e) {
                logger.error((Object)"error deleting table", (Throwable)e);
            }
            try {
                ObjectPersistency.get(TimeSeries.class).deleteByKey((Object)this.getId());
            }
            catch (Exception e) {
                logger.error((Object)"error deleting entry in TimeSeries table, it's could be already deleted", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error((Object)"error removing tables", (Throwable)e);
        }
        Enumeration<LinkedList<Operation>> opEnum = this.getCurrentsOperations().elements();
        while (opEnum.hasMoreElements()) {
            try {
                for (Operation op : opEnum.nextElement()) {
                    op.discard();
                }
            }
            catch (Exception e) {
                logger.error((Object)"error discarding operation");
            }
        }
    }

    protected void onRemove() throws ResourceException {
        this.remove();
        super.onRemove();
    }

    public String getId() throws ResourceException {
        return (String)this.getResourcePropertySet().get(RP_ID).get(0);
    }

    public synchronized void setId(String id) throws ResourceException {
        this.getResourcePropertySet().get(RP_ID).clear();
        this.getResourcePropertySet().get(RP_ID).add((Object)id);
    }

    public String getTitle() throws ResourceException {
        return (String)this.getResourcePropertySet().get(RP_TITLE).get(0);
    }

    public synchronized void setTitle(String title) throws ResourceException {
        this.getResourcePropertySet().get(RP_TITLE).clear();
        this.getResourcePropertySet().get(RP_TITLE).add((Object)title);
    }

    public SimpleTable getTable() throws Exception {
        return this.table;
    }

    public State getInitializationState() {
        return this.initializationState;
    }

    public void setInitializationState(State initializationState) {
        this.initializationState = initializationState;
    }

    public String getRelatedCurationId() {
        return this.relatedCurationId;
    }

    public void setRelatedCurationId(String relatedCurationId) {
        this.relatedCurationId = relatedCurationId;
    }

    public ColumnDefinition[] getColumnsDefinition() {
        return this.columnsDefinition;
    }

    public ColumnDefinition[] getCurrentColumnsDefinition(String user) {
        if (this.getCurrentOperation(user) != null && this.getCurrentOperation(user).getColumnDefinition() != null) {
            return this.getCurrentOperation(user).getColumnDefinition();
        }
        return this.columnsDefinition;
    }

    public void setColumnsDefinition(ColumnDefinition[] columnsDefinition) {
        this.columnsDefinition = columnsDefinition;
    }

    public void setInitializationState(String value) {
        this.initializationState = State.fromString((String)value);
    }

    public String getAllDataAsJSon(Limit limit, org.gcube.contentmanagement.timeseriesservice.stubs.Order order, String user) throws Exception {
        if (this.currentsOperations.get(user) == null) {
            Select select = (Select)DBSession.getImplementation(Select.class);
            select.setTables(new Table[]{this.getTable()});
            select.setLimit(new org.gcube.common.dbinterface.Limit(limit.getLowerLimit(), limit.getUpperLimit()));
            if (order != null) {
                select.setOrders(new Order[]{new Order(order.getOrder() == OrderType.Ascending ? Order.OrderType.ASC : Order.OrderType.DESC, (Attribute)new SimpleAttribute(order.getField()))});
            }
            return select.getResultAsJSon(true, new boolean[0]);
        }
        return this.currentsOperations.get(user).getLast().getDataAsJSon(limit, order);
    }

    public long getElementCount(String user) throws Exception {
        if (this.currentsOperations.get(user) == null) {
            this.getTable().initializeCount();
            return this.getTable().getCount();
        }
        return this.currentsOperations.get(user).getLast().getCount();
    }

    public ColumnDefinition getColumnDefinitionReference(String fieldId) throws Exception {
        for (ColumnDefinition def : this.columnsDefinition) {
            if (def.getId().compareTo(fieldId) != 0) continue;
            return def;
        }
        throw new Exception("fieldId " + fieldId + " not found");
    }

    public Operation getCurrentOperation(String user) {
        return this.currentsOperations.get(user) != null ? this.currentsOperations.get(user).getLast() : null;
    }

    public OperationType[] getOperationList(String user) {
        if (this.currentsOperations.get(user) == null) {
            return new OperationType[0];
        }
        OperationType[] listoperations = new OperationType[this.currentsOperations.get(user).size()];
        for (int i = 0; i < this.currentsOperations.get(user).size(); ++i) {
            listoperations[i] = this.currentsOperations.get(user).get(i).getType();
        }
        return listoperations;
    }

    public void addOperation(Operation operation, String user) {
        if (this.currentsOperations.get(user) == null) {
            this.currentsOperations.put(user, new LinkedList());
        }
        this.currentsOperations.get(user).add(operation);
    }

    public synchronized void performOperation(String user, Class<? extends Operation> operationClass, Object ... parameters) throws Exception {
        logger.trace((Object)"operation");
        Operation current = operationClass.newInstance();
        current.setParameters(parameters);
        String previousTableName = this.getCurrentOperation(user) == null ? this.getTable().getTableName() : this.getCurrentOperation(user).getViewName();
        ColumnDefinition[] previousColumnsDefinition = this.getCurrentOperation(user) == null ? this.getColumnsDefinition() : this.getCurrentOperation(user).getColumnDefinition();
        this.addOperation(current, user);
        try {
            current.apply(previousTableName, previousColumnsDefinition);
        }
        catch (Exception e) {
            this.currentsOperations.remove(user);
            logger.error((Object)"error applying operation", (Throwable)e);
            throw e;
        }
    }

    public void discardOperation(String user) throws Exception {
        Operation op = this.currentsOperations.get(user).removeLast();
        if (this.currentsOperations.get(user).size() == 0) {
            this.currentsOperations.remove(user);
        }
        try {
            op.discard();
        }
        catch (Exception e) {
            logger.trace((Object)"error discarding the old operation");
        }
    }

    public void discardAllOperations(String user) throws Exception {
        LinkedList<Operation> listOperation = this.currentsOperations.get(user);
        this.currentsOperations.remove(user);
        if (listOperation != null) {
            for (Operation op : listOperation) {
                try {
                    op.discard();
                }
                catch (Exception e) {
                    logger.trace((Object)"error discarding the old operation");
                }
            }
        }
    }

    public Hashtable<String, LinkedList<Operation>> getCurrentsOperations() {
        return this.currentsOperations;
    }

    public void setCurrentsOperations(Hashtable<String, LinkedList<Operation>> currentsOperations) {
        this.currentsOperations = currentsOperations;
    }

    public String exportAsCsv(ExportRequest req) throws Exception {
        return Export.asCsv(req, this.columnsDefinition, this.getTable());
    }

    public TSHistory getHistory() {
        return this.history;
    }

    public void setHistory(TSHistory history) {
        this.history = history;
    }

    public void setTable(SimpleTable table) {
        this.table = table;
    }

    public void setTSPublished() throws Exception {
        ObjectPersistency pers = ObjectPersistency.get(TimeSeries.class);
        TimeSeries ts = (TimeSeries)pers.getByKey((Object)this.getId());
        ts.setPublished(true);
        pers.update((Object)ts);
    }

    public void publishAtVOLevel(GCUBEScope scope) throws Exception {
        ObjectPersistency pers = ObjectPersistency.get(TimeSeries.class);
        TimeSeries ts = (TimeSeries)pers.getByKey((Object)this.getId());
        ts.setPublished(true);
        ts.setScope(scope.toString());
        pers.update((Object)ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDistinctValues(String fieldId, int start, int offset) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.connect();
            Select select = (Select)DBSession.getImplementation(Select.class);
            select.setTables(new Table[]{this.getTable()});
            select.setAttributes(new Attribute[]{new SimpleAttribute(fieldId)});
            select.setUseDistinct(true);
            if (start > 0) {
                select.setLimit(new org.gcube.common.dbinterface.Limit(start, offset));
            }
            logger.trace((Object)("query for distinct values is " + select.getExpression()));
            ResultSet result = select.getResults(session, new boolean[0]);
            ArrayList<String> listDistinctValues = new ArrayList<String>();
            while (result.next()) {
                listDistinctValues.add(result.getString(1));
            }
            logger.trace((Object)("retrieved distinc values " + listDistinctValues.size()));
            String[] stringArray = listDistinctValues.toArray(new String[listDistinctValues.size()]);
            return stringArray;
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    public String getChartData(int maxDimension, String xDimension, String yDimension, String groupDimension, String speciesColumn, String[] filters, String[] areas) throws Exception {
        StatisticsGenerator statisticsGenerator = ServiceContext.getContext().getStatisticsGenerator();
        statisticsGenerator.resetFilters();
        if (areas != null && areas.length > 0) {
            for (String area : areas) {
                statisticsGenerator.addColumnFilter(groupDimension, area);
            }
        }
        return statisticsGenerator.generateStringGraphs(maxDimension, this.getTable().getTableName().toLowerCase(), xDimension, yDimension, groupDimension, speciesColumn, filters);
    }

    public String transform(final AFilter filter, String user) throws Exception {
        filter.setTimeSeriesName(this.currentsOperations.get(user) != null ? this.currentsOperations.get(user).getLast().getViewName() : this.getTable().getTableName());
        long start = System.currentTimeMillis();
        TSGeoToolsConfiguration geoToolConf = ServiceContext.getContext().getTsGeoToolsConfiguration();
        geoToolConf.setReferenceCountriesTable("ref_country");
        geoToolConf.setReferenceSpeciesTable("ref_species");
        final TimeSeriesGISConverter converter = new TimeSeriesGISConverter(geoToolConf);
        final GISInformation gisInfo = ServiceContext.getContext().getGisInfo();
        converter.createNewGroup(Collections.singletonList(filter), gisInfo);
        String groupName = converter.getGroupName();
        logger.info((Object)(System.currentTimeMillis() - start + " to initiliaze TS2Gis"));
        final GISTransformationObject transformationObject = new GISTransformationObject(converter);
        converterMapping.put(groupName, transformationObject);
        new Thread(){

            @Override
            public void run() {
                try {
                    transformationObject.setTrasformationStatus(State.Open);
                    converter.TimeSeriesToGIS(Collections.singletonList(filter), gisInfo, false);
                    transformationObject.setTrasformationStatus(State.Close);
                }
                catch (Exception e) {
                    logger.warn((Object)"error transforming", (Throwable)e);
                    transformationObject.setTrasformationStatus(State.Error);
                    transformationObject.setCause(e.getMessage());
                }
            }
        }.start();
        logger.info((Object)(System.currentTimeMillis() - start + " to start TS2Gis"));
        return groupName;
    }

    public GetTransformationStatusResponse transformationStatus(String groupName) throws Exception {
        GISTransformationObject gisTrasformationObject = converterMapping.get(groupName);
        if (gisTrasformationObject == null) {
            throw new Exception("an error occurred getting the status");
        }
        if (gisTrasformationObject.getTrasformationStatus() == State.Error || gisTrasformationObject.getTrasformationStatus() == State.Close) {
            converterMapping.remove(groupName);
        }
        GetTransformationStatusResponse toReturn = null;
        switch (gisTrasformationObject.getType()) {
            case FishingMontlyEffort: {
                toReturn = new GetTransformationStatusResponse(gisTrasformationObject.getCause(), gisTrasformationObject.getAggregator().getStatus(), gisTrasformationObject.getTrasformationStatus());
                break;
            }
            case GIStransformation: {
                toReturn = new GetTransformationStatusResponse(gisTrasformationObject.getCause(), gisTrasformationObject.getConverter().getStatus(), gisTrasformationObject.getTrasformationStatus());
                break;
            }
        }
        return toReturn;
    }

    public String getFishingMontlyEffort(final GetFishingMontlyEffortRequest request) throws Exception {
        long start = System.currentTimeMillis();
        final String tableName = this.currentsOperations.get(request.getUser()) != null ? this.currentsOperations.get(request.getUser()).getLast().getViewName() : this.getTable().getTableName();
        TSGeoToolsConfiguration geoToolConf = ServiceContext.getContext().getTsGeoToolsConfiguration();
        final VTIEffortAggregator effortAggregator = new VTIEffortAggregator(geoToolConf);
        final GISInformation gisInfo = ServiceContext.getContext().getGisInfo();
        effortAggregator.createNewGroup(gisInfo, tableName, request.getXDimColumn(), request.getYDimColumn(), request.getDatesColumn(), request.getFishingHoursDimension(), request.getSpeedColumn());
        String groupName = effortAggregator.getGroupName();
        logger.info((Object)(System.currentTimeMillis() - start + " to initiliaze FishingMontlyEffort with groupName " + groupName));
        final ColumnDefinition[] columnsDef = this.currentsOperations.get(request.getUser()) != null ? this.currentsOperations.get(request.getUser()).getLast().getColumnDefinition() : this.getColumnsDefinition();
        final GISTransformationObject transformationObject = new GISTransformationObject(effortAggregator);
        converterMapping.put(groupName, transformationObject);
        new Thread(){

            @Override
            public void run() {
                try {
                    transformationObject.setTrasformationStatus(State.Open);
                    HashMap<String, String> field2user = new HashMap<String, String>();
                    for (ColumnDefinition def : columnsDef) {
                        field2user.put(def.getId(), def.getLabel());
                    }
                    effortAggregator.produceMontlyEffort(tableName, request.getMessageIdColumn(), request.getXDimColumn(), request.getYDimColumn(), request.getDatesColumn(), request.getFishingHoursDimension(), request.getSpeedColumn(), gisInfo, request.isProduceVTI(), request.isAppendMode(), field2user);
                    transformationObject.setTrasformationStatus(State.Close);
                }
                catch (Exception e) {
                    logger.warn((Object)"error getting FishingMontlyEffort", (Throwable)e);
                    transformationObject.setTrasformationStatus(State.Error);
                    transformationObject.setCause(e.getMessage());
                }
            }
        }.start();
        logger.info((Object)(System.currentTimeMillis() - start + " to start getFishingMontlyEffort"));
        return groupName;
    }
}

