/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations;

import java.util.Date;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.Operation;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.util.FilterExplorer;
import org.gcube.contentmanagement.timeseriesservice.stubs.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.FilterCondition;
import org.gcube.contentmanagement.timeseriesservice.stubs.OperationType;

public class Filter
extends Operation {
    private static final long serialVersionUID = 2846171625113232313L;
    private static GCUBELog logger = new GCUBELog(Filter.class);
    public static final String _TABLE_ALIAS = "tableAlias";
    private FilterCondition filterCondition;

    public Filter() throws Exception {
        this.type = OperationType.Filter;
        this.viewName = "f" + uuidGen.nextUUID().replaceAll("-", "");
    }

    @Override
    public void initialize(String previuosTableName, ColumnDefinition[] previousTableDefinition, DBSession session) throws Exception {
        Select query = (Select)DBSession.getImplementation(Select.class);
        query.setFilter(FilterExplorer.getCondition(this.filterCondition, previousTableDefinition, _TABLE_ALIAS, new String[0]));
        query.setTables(new Table[]{new Table(previuosTableName, _TABLE_ALIAS)});
        logger.trace((Object)("the filter is " + query.getExpression()));
        this.createTable(previuosTableName, session);
        this.setColumnDefinition(previousTableDefinition);
        InsertFromSelect insert = (InsertFromSelect)DBSession.getImplementation(InsertFromSelect.class);
        insert.setSubQuery(query);
        insert.setTable(this.viewTable);
        insert.execute(session);
        this.setCount(this.viewTable.getCount());
        String filterDescription = "description not available";
        try {
            filterDescription = FilterExplorer.getFilterDescription(this.filterCondition, previousTableDefinition).toString();
        }
        catch (Exception e) {
            logger.warn((Object)"error getting the filter description", (Throwable)e);
        }
        this.setHistoryItem(new TSHistoryItem(insert.toString(), filterDescription, new Date(), OperationType.Filter));
        logger.trace((Object)("the elements of the new Table are " + this.getCount()));
    }

    public FilterCondition getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(FilterCondition filterCondition) {
        this.filterCondition = filterCondition;
    }

    @Override
    public void setParameters(Object ... parameters) throws Exception {
        this.filterCondition = (FilterCondition)parameters[0];
    }
}

