/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.queries.alters.DropColumn;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.contentmanagement.timeseries.geotools.utils.Tuple;
import org.gcube.contentmanagement.timeseries.geotools.vti.VTIDataExtender;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.Operation;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.DataType;
import org.gcube.contentmanagement.timeseriesservice.stubs.EnrichRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.OperationType;

public class Enrichment
extends Operation {
    private static final long serialVersionUID = 2065606324772681068L;
    private static GCUBELog logger = new GCUBELog(Enrichment.class);
    private String messageIdColumn;
    private String xDimColumn;
    private String yDimColumn;
    private String speedColumn;
    private String rawDatesColumn;
    private String vesselIDColumn;

    public Enrichment() {
        this.type = OperationType.Enrichment;
        this.viewName = "e" + uuidGen.nextUUID().replaceAll("-", "");
    }

    @Override
    public void setParameters(Object ... parameters) throws Exception {
        EnrichRequest request = (EnrichRequest)parameters[0];
        this.messageIdColumn = request.getMessageIdColumn();
        this.xDimColumn = request.getXDimColumn();
        this.yDimColumn = request.getYDimColumn();
        this.speedColumn = request.getSpeedColumn();
        this.rawDatesColumn = request.getRawDatesColumn();
        this.vesselIDColumn = request.getVesselIDColumn();
    }

    @Override
    protected void initialize(String previuosTableName, ColumnDefinition[] previousTableDefinition, DBSession session) throws Exception {
        try {
            DataType valueType;
            logger.trace((Object)"initializing Enrichment");
            Select select = (Select)DBSession.getImplementation(Select.class);
            select.setTables(new Table[]{new Table(previuosTableName)});
            this.setColumnDefinition(previousTableDefinition);
            this.createTable(select, session, true);
            ArrayList<ColumnDefinition> newColumnDefinition = new ArrayList<ColumnDefinition>();
            newColumnDefinition.addAll(Arrays.asList(previousTableDefinition));
            this.viewTable.initializeFieldMapping();
            logger.debug((Object)("msgID: " + this.messageIdColumn + " x dim: " + this.xDimColumn + " y dim: " + this.yDimColumn + " spped: " + this.speedColumn + " data: " + this.rawDatesColumn + " vessel: " + this.vesselIDColumn));
            String tablePrimaryKeyType = (String)((Type)this.viewTable.getFieldsMapping().get(this.messageIdColumn)).getType().getListSqlTypes().get(0);
            VTIDataExtender extender = ServiceContext.getContext().getVtiDataExtender();
            extender.extendTable(this.viewName, this.messageIdColumn, tablePrimaryKeyType, this.xDimColumn, this.yDimColumn, VTIDataExtender.DataExtenderFunctionalities.bathymetry);
            List couples = extender.getColumnsAType(VTIDataExtender.DataExtenderFunctionalities.bathymetry);
            for (Tuple couple : couples) {
                logger.trace((Object)("enrichment found " + (String)couple.getElements().get(0)));
                DataType valueType2 = Util.mapSqlToJava(Type.parseType((String)((String)couple.getElements().get(1)), (int)50, (int)10, (int)5).getType());
                newColumnDefinition.add(new ColumnDefinition(EntryType.Attribute, null, null, (String)couple.getElements().get(0), null, (String)couple.getElements().get(0), valueType2));
            }
            String bathymetryColumn = (String)((Tuple)extender.getColumnsAType(VTIDataExtender.DataExtenderFunctionalities.bathymetry).get(0)).getElements().get(0);
            extender.extendTable(this.viewName, this.messageIdColumn, tablePrimaryKeyType, this.speedColumn, bathymetryColumn, VTIDataExtender.DataExtenderFunctionalities.classify);
            couples = extender.getColumnsAType(VTIDataExtender.DataExtenderFunctionalities.classify);
            for (Tuple couple : couples) {
                logger.trace((Object)("enrichment found " + (String)couple.getElements().get(0)));
                valueType = Util.mapSqlToJava(Type.parseType((String)((String)couple.getElements().get(1)), (int)50, (int)10, (int)5).getType());
                newColumnDefinition.add(new ColumnDefinition(EntryType.Attribute, null, null, (String)couple.getElements().get(0), null, (String)couple.getElements().get(0), valueType));
            }
            extender.extendTable(this.viewName, this.messageIdColumn, tablePrimaryKeyType, this.rawDatesColumn, VTIDataExtender.DataExtenderFunctionalities.vti_dates);
            couples = extender.getColumnsAType(VTIDataExtender.DataExtenderFunctionalities.vti_dates);
            for (Tuple couple : couples) {
                logger.trace((Object)("enrichment found " + (String)couple.getElements().get(0)));
                valueType = Util.mapSqlToJava(Type.parseType((String)((String)couple.getElements().get(1)), (int)50, (int)10, (int)5).getType());
                newColumnDefinition.add(new ColumnDefinition(EntryType.Attribute, null, null, (String)couple.getElements().get(0), null, (String)couple.getElements().get(0), valueType));
            }
            DropColumn dropColumn = (DropColumn)DBSession.getImplementation(DropColumn.class);
            dropColumn.setTable(new Table(this.getViewName()));
            dropColumn.setColumn(new SimpleAttribute(this.rawDatesColumn));
            dropColumn.execute(session);
            int index = -1;
            for (int i = 0; i < newColumnDefinition.size(); ++i) {
                if (!((ColumnDefinition)newColumnDefinition.get(i)).getId().equals(this.rawDatesColumn)) continue;
                index = i;
                break;
            }
            newColumnDefinition.remove(index);
            String formattedDatesColumn = (String)((Tuple)extender.getColumnsAType(VTIDataExtender.DataExtenderFunctionalities.vti_dates).get(0)).getElements().get(0);
            extender.extendTable(this.viewName, this.messageIdColumn, tablePrimaryKeyType, this.vesselIDColumn, formattedDatesColumn, VTIDataExtender.DataExtenderFunctionalities.fishing_hours);
            couples = extender.getColumnsAType(VTIDataExtender.DataExtenderFunctionalities.fishing_hours);
            for (Tuple couple : couples) {
                logger.trace((Object)("enrichment found " + (String)couple.getElements().get(0)));
                DataType valueType3 = Util.mapSqlToJava(Type.parseType((String)((String)couple.getElements().get(1)), (int)50, (int)10, (int)5).getType());
                newColumnDefinition.add(new ColumnDefinition(EntryType.Attribute, null, null, (String)couple.getElements().get(0), null, (String)couple.getElements().get(0), valueType3));
            }
            this.viewTable.initializeFieldMapping();
            this.setColumnDefinition(newColumnDefinition.toArray(new ColumnDefinition[newColumnDefinition.size()]));
            this.setCount(this.viewTable.getCount());
            this.setHistoryItem(new TSHistoryItem("unknown", "enrichment applied", new Date(), OperationType.Enrichment));
            logger.trace((Object)"enrichment finished");
        }
        catch (Exception e) {
            logger.error((Object)"error during enrichment", (Throwable)e);
            throw e;
        }
    }
}

