/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Condition;
import org.gcube.common.dbinterface.attributes.AssignedAttribute;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.conditions.OperatorCondition;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.queries.alters.ModifyColumnType;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.contentmanagement.codelistmanager.entities.CodeList;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.Operation;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.DataType;
import org.gcube.contentmanagement.timeseriesservice.stubs.Dimension;
import org.gcube.contentmanagement.timeseriesservice.stubs.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.Key;
import org.gcube.contentmanagement.timeseriesservice.stubs.OperationType;

public class ColumnChange
extends Operation {
    private static final long serialVersionUID = 4477370022652327533L;
    private static transient GCUBELog logger = new GCUBELog(ColumnChange.class);
    private String fieldId;
    private String keyId;
    private String keyName;
    private String codeFieldIdInDim;

    public ColumnChange() throws Exception {
        this.type = OperationType.ColumnChange;
        this.viewName = "cc" + uuidGen.nextUUID().replaceAll("-", "");
    }

    @Override
    public void setParameters(Object ... parameters) throws Exception {
        this.fieldId = (String)parameters[0];
        this.keyId = (String)parameters[1];
    }

    @Override
    protected void initialize(String previuosTableName, ColumnDefinition[] previousTableDefinition, DBSession session) throws Exception {
        DataType keyDataType;
        logger.trace((Object)("initializing the columnChange with fieldID " + this.fieldId + " and keyId " + this.keyId));
        ColumnDefinition def = ColumnChange.getColumnDefinitionReference(this.fieldId, previousTableDefinition);
        Dimension dimension = def.getDimension();
        if (dimension == null) {
            throw new Exception("the selected field is not a dimension");
        }
        SimpleTable previousTable = new SimpleTable(previuosTableName);
        this.createTable(previuosTableName, session);
        CodeList codelist = CodeList.get((String)dimension.getId());
        SimpleTable dimensionTable = codelist.getTable();
        this.keyName = ((TableField)codelist.getLabelFieldMapping().get(this.keyId)).getFieldName();
        this.codeFieldIdInDim = codelist.getCodeColumnId();
        Type newKeyType = (Type)dimensionTable.getFieldsMapping().get(this.keyId);
        Type actualColumnType = (Type)previousTable.getFieldsMapping().get(this.fieldId);
        if (newKeyType.getType() != actualColumnType.getType() || !Arrays.equals(newKeyType.getPrecisionArray(), actualColumnType.getPrecisionArray())) {
            ModifyColumnType modifyColumn = (ModifyColumnType)DBSession.getImplementation(ModifyColumnType.class);
            modifyColumn.setColumn(new SimpleAttribute(this.fieldId));
            modifyColumn.setNewType(newKeyType);
            modifyColumn.setTable((Table)this.viewTable);
            modifyColumn.execute(session);
            keyDataType = Util.mapSqlToJava(newKeyType.getType());
        } else {
            keyDataType = Util.mapSqlToJava(actualColumnType.getType());
        }
        String query = this.insert(previousTableDefinition, previuosTableName, dimensionTable.getTableName(), session);
        this.setHistoryItem(new TSHistoryItem(query, "changed column type of " + def.getLabel(), new Date(), OperationType.ColumnChange));
        this.setNewColumnDefintion(previousTableDefinition, keyDataType);
    }

    private String insert(ColumnDefinition[] previousTableDefinition, String previuosTableName, String dimensiontableName, DBSession session) throws Exception {
        InsertFromSelect insert = (InsertFromSelect)DBSession.getImplementation(InsertFromSelect.class);
        insert.setTable(this.viewTable);
        String previusTableAlias = "prev";
        String dimensionTableAlias = "dim";
        Select select = (Select)DBSession.getImplementation(Select.class);
        select.setTables(new Table[]{new SimpleTable(previuosTableName, "prev"), new SimpleTable(dimensiontableName, "dim")});
        ArrayList<Object> listAttributes = new ArrayList<Object>();
        String relatedDimensionIdField = null;
        for (ColumnDefinition def : previousTableDefinition) {
            if (def.getId().equals(this.fieldId)) {
                listAttributes.add(new AssignedAttribute(new SimpleAttribute(this.fieldId), (Object)new SimpleAttribute(this.keyId, "dim")));
                relatedDimensionIdField = def.getDimensionRelatedFieldId();
            } else {
                listAttributes.add(new SimpleAttribute(def.getId(), "prev"));
            }
            if (def.getColumnType() != EntryType.Dimension) continue;
            listAttributes.add(new SimpleAttribute(def.getDimensionRelatedFieldId(), "prev"));
        }
        if (relatedDimensionIdField == null) {
            throw new Exception("error retrieving the associated fieldId");
        }
        select.setAttributes(listAttributes.toArray(new Attribute[listAttributes.size()]));
        select.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(relatedDimensionIdField, "prev"), (Object)new SimpleAttribute(this.codeFieldIdInDim, "dim"), "="));
        logger.trace((Object)("subquery is " + select.getExpression()));
        insert.setSubQuery(select);
        insert.execute(session);
        return insert.getExpression();
    }

    private void setNewColumnDefintion(ColumnDefinition[] previousTableDefinition, DataType keyDataType) throws Exception {
        ColumnDefinition[] newColumnDefintion = previousTableDefinition;
        ColumnDefinition def = ColumnChange.getColumnDefinitionReference(this.fieldId, newColumnDefintion);
        def.setKey(new Key(this.keyId, this.keyName, keyDataType));
        this.setColumnDefinition(newColumnDefintion);
    }
}

