/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.attributes.AggregatedAttribute;
import org.gcube.common.dbinterface.attributes.AggregationFunctions;
import org.gcube.common.dbinterface.attributes.AssignedAttribute;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.Operation;
import org.gcube.contentmanagement.timeseriesservice.stubs.AggregateRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.AggregationFunction;
import org.gcube.contentmanagement.timeseriesservice.stubs.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.DataType;
import org.gcube.contentmanagement.timeseriesservice.stubs.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.OperationType;

public class Aggregation
extends Operation {
    private static final long serialVersionUID = -6364572465285031383L;
    private static GCUBELog logger = new GCUBELog(Aggregation.class);
    private AggregationFunction aggregationFuncion;
    private String[] aggregationfields;

    public Aggregation() {
        this.type = OperationType.Aggregation;
        this.viewName = "a" + uuidGen.nextUUID().replaceAll("-", "");
    }

    @Override
    public void initialize(String previuosTableName, ColumnDefinition[] previousTableDefinition, DBSession session) throws Exception {
        ArrayList<SimpleAttribute> groupingAttributes = new ArrayList<SimpleAttribute>();
        ArrayList<ColumnDefinition> newColumnDefinition = new ArrayList<ColumnDefinition>();
        ArrayList<Object> selectAttributes = new ArrayList<Object>();
        for (ColumnDefinition def : previousTableDefinition) {
            if (Arrays.binarySearch(this.aggregationfields, def.getId()) < 0) {
                newColumnDefinition.add(def);
                if (def.getColumnType() == EntryType.Value) {
                    selectAttributes.add(new AssignedAttribute(new SimpleAttribute(def.getId()), (Object)new AggregatedAttribute(def.getId(), AggregationFunctions.valueOf((String)this.aggregationFuncion.getValue()))));
                    continue;
                }
                SimpleAttribute attr = new SimpleAttribute(def.getId());
                if (def.getColumnType() == EntryType.Dimension) {
                    SimpleAttribute idAttribute = new SimpleAttribute(def.getId() + "_id");
                    groupingAttributes.add(attr);
                    groupingAttributes.add(idAttribute);
                    selectAttributes.add(attr);
                    selectAttributes.add(idAttribute);
                    continue;
                }
                groupingAttributes.add(attr);
                selectAttributes.add(attr);
                continue;
            }
            newColumnDefinition.add(new ColumnDefinition(EntryType.Attribute, null, null, def.getId(), null, def.getLabel(), DataType.Text));
            selectAttributes.add(new AssignedAttribute(new SimpleAttribute(def.getId()), (Object)Utility.getCastToString((String)"All")));
        }
        this.setColumnDefinition(newColumnDefinition.toArray(new ColumnDefinition[0]));
        Select query = (Select)DBSession.getImplementation(Select.class);
        query.setAttributes(selectAttributes.toArray(new Attribute[0]));
        query.setTables(new Table[]{new Table(previuosTableName)});
        query.setGroups(groupingAttributes.toArray(new SimpleAttribute[0]));
        this.createTable(query, session, false);
        logger.trace((Object)("aggregation query: " + query.getExpression()));
        InsertFromSelect insert = (InsertFromSelect)DBSession.getImplementation(InsertFromSelect.class);
        insert.setSubQuery(query);
        insert.setTable(this.viewTable);
        logger.trace((Object)("table created with query: " + insert.getExpression()));
        insert.execute(session);
        this.setCount(this.viewTable.getCount());
        String aggregatedFields = " ";
        for (String field : this.aggregationfields) {
            aggregatedFields = aggregatedFields + Aggregation.getColumnDefinitionReference(field, previousTableDefinition).getLabel() + " ";
        }
        this.setHistoryItem(new TSHistoryItem(query.toString(), "aggregation applied at fields [" + aggregatedFields + "] using function " + this.aggregationFuncion, new Date(), OperationType.Aggregation));
        logger.trace((Object)("count calculated in " + this.getCount()));
        logger.trace((Object)"aggragation intialization finished");
    }

    @Override
    public void setParameters(Object ... parameters) throws Exception {
        AggregateRequest request = (AggregateRequest)parameters[0];
        this.aggregationFuncion = request.getAggregateFunction();
        this.aggregationfields = request.getFieldList();
        logger.trace((Object)("aggregation fields are " + this.aggregationfields.length));
    }
}

