/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.contentmanagement.timeseries.geotools.utils.Tuple;
import org.gcube.contentmanagement.timeseries.geotools.vti.VTIDataExtender;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.Enrichment;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.Operation;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.AddFAOAreasRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.DataType;
import org.gcube.contentmanagement.timeseriesservice.stubs.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.OperationType;

public class AddFAOAreas
extends Operation {
    private static final long serialVersionUID = -6868708330903612012L;
    private static GCUBELog logger = new GCUBELog(Enrichment.class);
    private String messageIdColumn;
    private String xDimColumn;
    private String yDimColumn;

    public AddFAOAreas() {
        this.type = OperationType.AddFAOAreas;
        this.viewName = "afa" + uuidGen.nextUUID().replaceAll("-", "");
    }

    @Override
    public void setParameters(Object ... parameters) throws Exception {
        AddFAOAreasRequest request = (AddFAOAreasRequest)parameters[0];
        this.messageIdColumn = request.getMessageIdColumn();
        this.xDimColumn = request.getXDimColumn();
        this.yDimColumn = request.getYDimColumn();
    }

    @Override
    protected void initialize(String previuosTableName, ColumnDefinition[] previousTableDefinition, DBSession session) throws Exception {
        try {
            logger.trace((Object)"initializing add fao areas");
            Select select = (Select)DBSession.getImplementation(Select.class);
            select.setTables(new Table[]{new Table(previuosTableName)});
            this.setColumnDefinition(previousTableDefinition);
            this.createTable(select, session, true);
            ArrayList<ColumnDefinition> newColumnDefinition = new ArrayList<ColumnDefinition>();
            newColumnDefinition.addAll(Arrays.asList(previousTableDefinition));
            this.viewTable.initializeFieldMapping();
            String tablePrimaryKeyType = (String)((Type)this.viewTable.getFieldsMapping().get(this.messageIdColumn)).getType().getListSqlTypes().get(0);
            VTIDataExtender extender = ServiceContext.getContext().getVtiDataExtender();
            extender.extendTable(this.viewName, this.messageIdColumn, tablePrimaryKeyType, this.xDimColumn, this.yDimColumn, VTIDataExtender.DataExtenderFunctionalities.fao_areas);
            List couples = extender.getColumnsAType(VTIDataExtender.DataExtenderFunctionalities.fao_areas);
            for (Tuple couple : couples) {
                logger.trace((Object)("enrichment found " + (String)couple.getElements().get(0)));
                DataType valueType = Util.mapSqlToJava(Type.parseType((String)((String)couple.getElements().get(1)), (int)50, (int)10, (int)5).getType());
                newColumnDefinition.add(new ColumnDefinition(EntryType.Attribute, null, null, (String)couple.getElements().get(0), null, (String)couple.getElements().get(0), valueType));
            }
            this.viewTable.initializeFieldMapping();
            this.setColumnDefinition(newColumnDefinition.toArray(new ColumnDefinition[newColumnDefinition.size()]));
            this.setCount(this.viewTable.getCount());
            this.setHistoryItem(new TSHistoryItem("unknown", "add fao areas applied", new Date(), OperationType.AddFAOAreas));
            logger.trace((Object)"add fao areas finished");
        }
        catch (Exception e) {
            logger.error((Object)"error adding fao areas", (Throwable)e);
            throw e;
        }
    }
}

