/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.timeseries;

import java.util.Calendar;
import java.util.LinkedList;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.types.StringArray;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.timeseries.geotools.filters.AFilter;
import org.gcube.contentmanagement.timeseries.geotools.filters.SpaceFilter;
import org.gcube.contentmanagement.timeseries.geotools.filters.SpeciesFilter;
import org.gcube.contentmanagement.timeseries.geotools.filters.custom.CountryYearFilter;
import org.gcube.contentmanagement.timeseries.geotools.filters.custom.FAOAreaFilter;
import org.gcube.contentmanagement.timeseriesservice.impl.context.CurationContext;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ImportContext;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.context.TimeSeriesContext;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.state.CurationResource;
import org.gcube.contentmanagement.timeseriesservice.impl.history.CurationHistory;
import org.gcube.contentmanagement.timeseriesservice.impl.history.CurationHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistory;
import org.gcube.contentmanagement.timeseriesservice.impl.history.TSHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.AddFAOAreas;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.Aggregation;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.ColumnChange;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.Denormalization;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.Enrichment;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.Filter;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.Grouping;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.Union;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.state.TimeSeriesResource;
import org.gcube.contentmanagement.timeseriesservice.stubs.AddFAOAreasRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.AggregateRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ChangeColumnRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ChartDataRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ColumnDefinitionArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.CompatibleColumnsMappingArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.CompatibleColumnsRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CurationHistoryOps;
import org.gcube.contentmanagement.timeseriesservice.stubs.CurrentState;
import org.gcube.contentmanagement.timeseriesservice.stubs.DenormalizeRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.DistinctValuesRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.EnrichRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.ExportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.FilterCondition;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetAllDataAsJsonRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetAreaTransformationResultRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetFishingMontlyEffortRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetSpaceSpeciesTransformationResultRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetSpaceTransformationResultRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetTimeCountriesTransformationResultRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetTransformationStatusResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.GroupRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.IsUnionAllowedRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.OperationType;
import org.gcube.contentmanagement.timeseriesservice.stubs.OperationsListArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.ParentType;
import org.gcube.contentmanagement.timeseriesservice.stubs.PublishingLevel;
import org.gcube.contentmanagement.timeseriesservice.stubs.State;
import org.gcube.contentmanagement.timeseriesservice.stubs.TimeseriesHistory;
import org.gcube.contentmanagement.timeseriesservice.stubs.TimeseriesHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.TsFilterRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.TsHistoryOps;
import org.gcube.contentmanagement.timeseriesservice.stubs.UnionRequest;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;

public class TimeSeriesManager {
    private static GCUBELog logger = new GCUBELog(TimeSeriesManager.class);

    protected TimeSeriesResource getResource() throws ResourceException {
        return (TimeSeriesResource)TimeSeriesContext.getPortTypeContext().getWSHome().find();
    }

    public String getAllDataAsJson(GetAllDataAsJsonRequest request) throws GCUBEFault {
        try {
            return this.getResource().getAllDataAsJSon(request.getLimit(), request.getOrder(), request.getUser());
        }
        catch (Exception e) {
            logger.error((Object)"error getting data", (Throwable)e);
            throw new GCUBEFault(new String[]{"error getting data"});
        }
    }

    public State getInitializationState(VOID req) throws GCUBEFault {
        try {
            return this.getResource().getInitializationState();
        }
        catch (Exception e) {
            logger.error((Object)"error getting initialization state", (Throwable)e);
            throw new GCUBEFault(new String[]{"error getting initialization state"});
        }
    }

    public String exportAsCsv(ExportRequest req) throws GCUBEFault {
        try {
            return this.getResource().exportAsCsv(req);
        }
        catch (Exception e) {
            logger.error((Object)"error exporting TS as CSV", (Throwable)e);
            throw new GCUBEFault(new String[]{"error exporting TS as CSV"});
        }
    }

    public ColumnDefinitionArray getColumnsDefinition(String user) throws GCUBEFault {
        try {
            return new ColumnDefinitionArray(this.getResource().getCurrentColumnsDefinition(user));
        }
        catch (Exception e) {
            logger.error((Object)"error in getColumnsDefinition", (Throwable)e);
            throw new GCUBEFault(new String[]{"error exporting TS as CSV"});
        }
    }

    public long getElementsCount(String user) throws GCUBEFault {
        try {
            return this.getResource().getElementCount(user);
        }
        catch (Exception e) {
            logger.error((Object)"error getting count", (Throwable)e);
            throw new GCUBEFault(new String[]{"error getting count"});
        }
    }

    public VOID tsFilter(TsFilterRequest request) throws GCUBEFault {
        try {
            this.getResource().performOperation(request.getUser(), Filter.class, request.getFilter());
            this.getResource().store();
            return new VOID();
        }
        catch (Exception e) {
            logger.error((Object)"error in tsFilter", (Throwable)e);
            throw new GCUBEFault(new String[]{"error filtering TS"});
        }
    }

    public VOID union(UnionRequest request) throws GCUBEFault {
        logger.debug((Object)"union operation requested");
        try {
            this.getResource().performOperation(request.getUser(), Union.class, request.getId(), request.getFieldMappingList());
            this.getResource().store();
            return new VOID();
        }
        catch (Exception e) {
            logger.error((Object)"error in union operation", (Throwable)e);
            throw new GCUBEFault(new String[]{"error in union operation"});
        }
    }

    public VOID changeColumn(ChangeColumnRequest request) throws GCUBEFault {
        logger.debug((Object)"union operation requested");
        try {
            this.getResource().performOperation(request.getUser(), ColumnChange.class, request.getFieldId(), request.getKeyId());
            this.getResource().store();
            return new VOID();
        }
        catch (Exception e) {
            logger.error((Object)"error in union operation", (Throwable)e);
            throw new GCUBEFault(new String[]{"error in union operation"});
        }
    }

    public VOID enrich(EnrichRequest request) throws GCUBEFault {
        logger.debug((Object)"enrichment operation requested");
        try {
            this.getResource().performOperation(request.getUser(), Enrichment.class, request);
            this.getResource().store();
            return new VOID();
        }
        catch (Exception e) {
            logger.error((Object)"error in enrichment operation", (Throwable)e);
            throw new GCUBEFault(new String[]{"error in enrichment operation"});
        }
    }

    public VOID addFAOAreas(AddFAOAreasRequest request) throws GCUBEFault {
        logger.debug((Object)"enrichment operation requested");
        try {
            this.getResource().performOperation(request.getUser(), AddFAOAreas.class, request);
            this.getResource().store();
            return new VOID();
        }
        catch (Exception e) {
            logger.error((Object)"error in enrichment operation", (Throwable)e);
            throw new GCUBEFault(new String[]{"error in enrichment operation"});
        }
    }

    public VOID aggregate(AggregateRequest request) throws GCUBEFault {
        logger.debug((Object)("aggregate operation requested with " + request.getFieldList().toString() + " as field list"));
        TimeSeriesResource res = null;
        try {
            res = this.getResource();
        }
        catch (Exception e) {
            logger.error((Object)"error getting the resource", (Throwable)e);
            new GCUBEFault((Throwable)e, new String[]{"error getting the resource"});
        }
        try {
            for (String fieldId : request.getFieldList()) {
                if (res.getColumnDefinitionReference(fieldId).getColumnType() == EntryType.Dimension) continue;
                throw new Exception("the parameters are not correct");
            }
        }
        catch (Exception e) {
            logger.error((Object)"aggragate: the parameters are not correct", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"aggragate: the parameters are not correct"});
        }
        try {
            this.getResource().performOperation(request.getUser(), Aggregation.class, request);
            this.getResource().store();
            return new VOID();
        }
        catch (Exception e) {
            logger.error((Object)"error in aggregate operation", (Throwable)e);
            throw new GCUBEFault(new String[]{"error in aggregate operation"});
        }
    }

    public VOID group(GroupRequest request) throws GCUBEFault {
        logger.debug((Object)"union operation requested");
        try {
            this.getResource().performOperation(request.getUser(), Grouping.class, request);
            this.getResource().store();
            return new VOID();
        }
        catch (Exception e) {
            logger.error((Object)"error in group operation", (Throwable)e);
            throw new GCUBEFault(new String[]{"error in group operation"});
        }
    }

    public VOID denormalize(DenormalizeRequest request) throws GCUBEFault {
        logger.debug((Object)"denormalize operation requested");
        try {
            if (this.getResource().getColumnDefinitionReference(request.getAttributeFieldId()).getColumnType() != EntryType.Attribute || this.getResource().getColumnDefinitionReference(request.getValueFieldId()).getColumnType() != EntryType.Value) {
                throw new GCUBEFault(new String[]{"the parameters are not correct"});
            }
            this.getResource().performOperation(request.getUser(), Denormalization.class, request.getAttributeFieldId(), request.getValueFieldId());
            this.getResource().store();
            return new VOID();
        }
        catch (Exception e) {
            logger.error((Object)"error denormalizing", (Throwable)e);
            throw new GCUBEFault(new String[]{"error denormalizing the time series"});
        }
    }

    public VOID discardCurrentOperation(String user) throws GCUBEFault {
        logger.trace((Object)"discarding operation");
        try {
            this.getResource().discardOperation(user);
            this.getResource().store();
            return new VOID();
        }
        catch (Exception e) {
            logger.error((Object)"error discarding operation", (Throwable)e);
            throw new GCUBEFault(new String[]{"error discarding operation"});
        }
    }

    public VOID discardAllOperations(String user) throws GCUBEFault {
        try {
            this.getResource().discardAllOperations(user);
            this.getResource().store();
            return new VOID();
        }
        catch (Exception e) {
            logger.error((Object)"error discarding operation", (Throwable)e);
            throw new GCUBEFault(new String[]{"error discarding operation"});
        }
    }

    public FilterCondition getFilter(String user) throws GCUBEFault {
        try {
            return ((Filter)this.getResource().getCurrentOperation(user)).getFilterCondition();
        }
        catch (Exception e) {
            logger.error((Object)"error getCurrentOperation", (Throwable)e);
            throw new GCUBEFault(new String[]{"error getCurrentOperation"});
        }
    }

    public CurrentState getCurrentState(String user) throws GCUBEFault {
        try {
            if (this.getResource().getCurrentOperation(user) == null) {
                return CurrentState.Closed;
            }
            return this.getResource().getCurrentOperation(user).getCurrentState();
        }
        catch (Exception e) {
            logger.error((Object)"error getCurrentOperation", (Throwable)e);
            throw new GCUBEFault(new String[]{"error getCurrentOperation"});
        }
    }

    public OperationType getCurrentOperation(String user) throws GCUBEFault {
        try {
            if (this.getResource().getCurrentOperation(user) == null) {
                return OperationType.None;
            }
            return this.getResource().getCurrentOperation(user).getType();
        }
        catch (Exception e) {
            logger.error((Object)"error getCurrentOperation", (Throwable)e);
            throw new GCUBEFault(new String[]{"error getCurrentOperation"});
        }
    }

    public OperationsListArray getOperationsList(String user) throws GCUBEFault {
        try {
            if (this.getResource().getOperationList(user) == null) {
                return new OperationsListArray(new OperationType[0]);
            }
            return new OperationsListArray(this.getResource().getOperationList(user));
        }
        catch (Exception e) {
            logger.error((Object)"error getOperationsList", (Throwable)e);
            throw new GCUBEFault(new String[]{"error getOperationsList"});
        }
    }

    public boolean isUnionAllowed(IsUnionAllowedRequest request) throws GCUBEFault {
        logger.debug((Object)("check compatibility with " + request.getId()));
        try {
            TimeSeriesResource sourceResource = this.getResource();
            TimeSeriesResource destinationResource = (TimeSeriesResource)TimeSeriesContext.getPortTypeContext().getWSHome().find((ResourceKey)TimeSeriesContext.getPortTypeContext().makeKey(request.getId()));
            boolean returnValue = Union.checkCompatibility(sourceResource.getCurrentColumnsDefinition(request.getUser()), destinationResource.getCurrentColumnsDefinition(request.getUser()));
            logger.debug((Object)("the TimeSeries " + (returnValue ? "is compatible" : "is not compatible")));
            return returnValue;
        }
        catch (Exception e) {
            logger.error((Object)"error verifying union", (Throwable)e);
            return false;
        }
    }

    public VOID publish(PublishingLevel level) throws GCUBEFault {
        try {
            if (level == PublishingLevel.VRE) {
                this.getResource().setTSPublished();
            } else {
                GCUBEScope scope = ServiceContext.getContext().getScope();
                GCUBEWSResourceKey resourceKey = (GCUBEWSResourceKey)this.getResource().getID();
                if (scope.getType() == GCUBEScope.Type.VRE) {
                    ServiceContext.getContext().setScope(scope.getEnclosingScope());
                }
                TimeSeriesContext.getPortTypeContext().getWSHome().create(resourceKey, new Object[0]);
                this.getResource().publishAtVOLevel(ServiceContext.getContext().getScope());
                ServiceContext.getContext().setScope(scope);
            }
        }
        catch (Exception e) {
            logger.error((Object)"error publishing the ts", (Throwable)e);
            throw new GCUBEFault(new String[]{"error publishing the ts"});
        }
        return new VOID();
    }

    public TimeseriesHistory getHistory(VOID request) throws GCUBEFault {
        Calendar tsCalendar;
        TSHistory tsHistory;
        LinkedList<TimeseriesHistoryItem> historyItemsList = new LinkedList<TimeseriesHistoryItem>();
        try {
            tsHistory = this.getResource().getHistory();
        }
        catch (Exception e) {
            logger.error((Object)"impossible to find the resource", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
        while (tsHistory.getParentType() == TSHistory.ParentType.TS) {
            TsHistoryOps[] tsOperations = new TsHistoryOps[tsHistory.getHistoryList().size()];
            for (int i = 0; i < tsHistory.getHistoryList().size(); ++i) {
                TSHistoryItem tempItem = tsHistory.getHistoryList().get(i);
                Calendar tsItemCalendar = Calendar.getInstance();
                tsItemCalendar.setTime(tempItem.getDate());
                tsOperations[i] = new TsHistoryOps(tsItemCalendar, tempItem.getHumanDescription(), tempItem.getOpType());
            }
            boolean parentAlive = true;
            TimeSeriesResource tsResource = null;
            try {
                tsResource = (TimeSeriesResource)TimeSeriesContext.getPortTypeContext().getWSHome().find((ResourceKey)TimeSeriesContext.getPortTypeContext().makeKey(tsHistory.getParentId()));
            }
            catch (ResourceException re) {
                logger.debug((Object)("the parent TS with id " + tsHistory.getParentId() + " is not alive!!"));
                parentAlive = false;
            }
            tsCalendar = Calendar.getInstance();
            tsCalendar.setTime(tsHistory.getHistoryCreationDate());
            historyItemsList.add(new TimeseriesHistoryItem(tsHistory.getAuthor(), tsCalendar, tsOperations, parentAlive, tsHistory.getParentId(), tsHistory.getParentName(), ParentType.fromString((String)tsHistory.getParentType().toString())));
            try {
                tsHistory = parentAlive ? tsResource.getHistory() : TSHistory.retrieveHistory(tsHistory.getParentId());
            }
            catch (Exception e) {
                logger.error((Object)"unexpected error preparing history response", (Throwable)e);
                throw new GCUBEFault(new String[]{"unexpected error preparing history response"});
            }
        }
        org.gcube.contentmanagement.timeseriesservice.stubs.CurationHistoryItem curationHistoryItem = null;
        try {
            CurationHistory curationHistory;
            CurationResource curResource = null;
            boolean parentCurAlive = true;
            try {
                String parentId = tsHistory.getParentId();
                logger.trace((Object)("the curation Id is " + parentId));
                curResource = (CurationResource)CurationContext.getPortTypeContext().getWSHome().find((ResourceKey)CurationContext.getPortTypeContext().makeKey(parentId));
            }
            catch (ResourceException re) {
                logger.debug((Object)("the parent Curation with id " + tsHistory.getParentId() + " is not alive!!"));
                parentCurAlive = false;
            }
            tsCalendar = Calendar.getInstance();
            tsCalendar.setTime(tsHistory.getHistoryCreationDate());
            historyItemsList.add(new TimeseriesHistoryItem(tsHistory.getAuthor(), tsCalendar, new TsHistoryOps[0], parentCurAlive, tsHistory.getParentId(), tsHistory.getParentName(), ParentType.fromString((String)tsHistory.getParentType().toString())));
            try {
                curationHistory = parentCurAlive ? curResource.getHistory() : CurationHistory.retrieveHistory(tsHistory.getParentId());
            }
            catch (Exception e) {
                logger.error((Object)"unexpected error preparing history response", (Throwable)e);
                throw new GCUBEFault(new String[]{"unexpected error preparing history response"});
            }
            CurationHistoryOps[] curationItemList = new CurationHistoryOps[tsHistory.getItemLimit()];
            for (int i = 0; i < tsHistory.getItemLimit(); ++i) {
                CurationHistoryItem curationItem = curationHistory.getItems().get(i);
                Calendar curItemCalendar = Calendar.getInstance();
                curItemCalendar.setTime(curationItem.getDate());
                curationItemList[i] = new CurationHistoryOps(curItemCalendar, curationItem.getHumanDescription(), curationItem.getOpType().toString());
            }
            boolean parentImporterAlive = true;
            try {
                ImportContext.getPortTypeContext().getWSHome().find((ResourceKey)ImportContext.getPortTypeContext().makeKey(curationHistory.getCsvParentId()));
            }
            catch (ResourceException re) {
                logger.debug((Object)("the parent csv with id " + curationHistory.getCsvParentId() + " is not alive!!"));
                parentImporterAlive = false;
            }
            Calendar curCalendar = Calendar.getInstance();
            curCalendar.setTime(curationHistory.getDate());
            curationHistoryItem = new org.gcube.contentmanagement.timeseriesservice.stubs.CurationHistoryItem(curationHistory.getCreator(), curCalendar, curationItemList, parentImporterAlive, curationHistory.getCsvParentId(), curationHistory.getParentTitle());
        }
        catch (Exception e) {
            logger.error((Object)"error retrieve curation history", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
        return new TimeseriesHistory(null, curationHistoryItem, historyItemsList.toArray(new TimeseriesHistoryItem[0]));
    }

    public CompatibleColumnsMappingArray getCompatibleColumns(CompatibleColumnsRequest request) throws GCUBEFault {
        TimeSeriesResource destinationResource;
        TimeSeriesResource sourceResource;
        logger.debug((Object)("call to getCompatibleColumns with request: " + request.getId() + " and user " + request.getUser()));
        try {
            sourceResource = this.getResource();
            destinationResource = (TimeSeriesResource)TimeSeriesContext.getPortTypeContext().getWSHome().find((ResourceKey)TimeSeriesContext.getPortTypeContext().makeKey(request.getId()));
        }
        catch (Exception e) {
            logger.error((Object)"impossible to retrieve resource", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error retrieving resource"});
        }
        if (!Union.checkCompatibility(sourceResource.getCurrentColumnsDefinition(request.getUser()), destinationResource.getCurrentColumnsDefinition(request.getUser()))) {
            throw new GCUBEFault(new String[]{"Selected TimeSeries are not compatible"});
        }
        try {
            return new CompatibleColumnsMappingArray(Union.getCompatibileColumns(sourceResource.getCurrentColumnsDefinition(request.getUser()), destinationResource.getCurrentColumnsDefinition(request.getUser())));
        }
        catch (Exception e) {
            logger.error((Object)"error getting compatible columns", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error getting compatible columns"});
        }
    }

    public StringArray getDistinctValues(DistinctValuesRequest request) throws GCUBEFault {
        try {
            int startElement = -1;
            int offset = -1;
            if (request.getLimit() != null) {
                startElement = request.getLimit().getLowerLimit();
                offset = request.getLimit().getUpperLimit();
            }
            StringArray arrayString = new StringArray(this.getResource().getDistinctValues(request.getFieldId(), startElement, offset));
            logger.trace((Object)("returning " + arrayString.getItems().length + " distinct values"));
            return arrayString;
        }
        catch (Exception e) {
            logger.error((Object)"error getting distinct values", (Throwable)e);
            throw new GCUBEFault(new String[]{"error getting distinct values"});
        }
    }

    public String getChartData(ChartDataRequest req) throws GCUBEFault {
        try {
            return this.getResource().getChartData(req.getMaxDimension(), req.getXDimension(), req.getYDimension(), req.getGroupDimension(), req.getAttributeColumn(), req.getFilters().getItems(), req.getAreas().getItems());
        }
        catch (Exception e) {
            logger.error((Object)"error getting chart data", (Throwable)e);
            throw new GCUBEFault(new String[]{"error getting chart data"});
        }
    }

    public String getAreaTransformationResult(GetAreaTransformationResultRequest request) throws GCUBEFault {
        try {
            FAOAreaFilter filter = new FAOAreaFilter(this.getResource().getTable().getTableName(), request.getAggregationColumn(), request.getQuantitiesColumn());
            return this.getResource().transform((AFilter)filter, request.getUser());
        }
        catch (Exception e) {
            logger.error((Object)"error transforming timeseries", (Throwable)e);
            throw new GCUBEFault(new String[]{"error transforming timeseries"});
        }
    }

    public String getSpaceTransformationResult(GetSpaceTransformationResultRequest request) throws GCUBEFault {
        try {
            SpaceFilter filter = new SpaceFilter(this.getResource().getTable().getTableName(), request.getAggregationColumn(), request.getQuantitiesColumn());
            return this.getResource().transform((AFilter)filter, request.getUser());
        }
        catch (Exception e) {
            logger.error((Object)"error transforming timeseries", (Throwable)e);
            throw new GCUBEFault(new String[]{"error transforming timeseries"});
        }
    }

    public String getTimeCountriesTransformationResult(GetTimeCountriesTransformationResultRequest request) throws GCUBEFault {
        try {
            CountryYearFilter filter = new CountryYearFilter(this.getResource().getTable().getTableName(), request.getAggregationColumn(), request.getInformationColumn(), request.getQuantitiesColumn());
            return this.getResource().transform((AFilter)filter, request.getUser());
        }
        catch (Exception e) {
            logger.error((Object)"error transforming timeseries", (Throwable)e);
            throw new GCUBEFault(new String[]{"error transforming timeseries"});
        }
    }

    public String getSpaceSpeciesTransformationResult(GetSpaceSpeciesTransformationResultRequest request) throws GCUBEFault {
        try {
            SpeciesFilter filter = new SpeciesFilter(this.getResource().getTable().getTableName(), request.getAggregationColumn(), request.getInformationColumn(), request.getQuantitiesColumn());
            return this.getResource().transform((AFilter)filter, request.getUser());
        }
        catch (Exception e) {
            logger.error((Object)"error transforming timeseries", (Throwable)e);
            throw new GCUBEFault(new String[]{"error transforming timeseries"});
        }
    }

    public String getFishingMontlyEffort(GetFishingMontlyEffortRequest request) throws GCUBEFault {
        try {
            return this.getResource().getFishingMontlyEffort(request);
        }
        catch (Exception e) {
            logger.error((Object)"error transforming timeseries", (Throwable)e);
            throw new GCUBEFault(new String[]{"error transforming timeseries"});
        }
    }

    public GetTransformationStatusResponse getTransformationStatus(String groupName) throws GCUBEFault {
        try {
            return this.getResource().transformationStatus(groupName);
        }
        catch (Exception e) {
            logger.error((Object)("error transformation status for groupName " + groupName), (Throwable)e);
            throw new GCUBEFault(new String[]{"error transformation status for groupName " + groupName});
        }
    }
}

