/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.thread;

import java.io.File;
import java.net.URI;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReaderProcessor;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CreateTable;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ImportContext;
import org.gcube.contentmanagement.timeseriesservice.impl.importer.ImporterItem;
import org.gcube.contentmanagement.timeseriesservice.impl.importer.state.ImportResource;
import org.gcube.contentmanagement.timeseriesservice.impl.importer.state.ImportResourceHome;
import org.gcube.contentmanagement.timeseriesservice.stubs.calls.RSWrapper;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;

public abstract class InsertThread
extends Thread {
    protected GCUBELog logger = new GCUBELog(InsertThread.class);
    protected DBSession session;
    protected String rslocator;
    protected String tableName;
    protected boolean[] fieldsMask;
    protected int totalEntries;
    protected int columnsNumber;
    protected boolean hasHeader = true;
    protected char delimiter = (char)44;
    protected String encoding;
    protected ImporterItem importer;

    public InsertThread(String rslocator, String tableName, boolean[] fieldsMask, boolean hasHeader, char delimiter, String encoding, ImporterItem importer) {
        this.rslocator = rslocator;
        this.tableName = tableName;
        this.fieldsMask = fieldsMask;
        this.columnsNumber = -1;
        this.hasHeader = hasHeader;
        this.delimiter = delimiter;
        this.encoding = encoding;
        this.importer = importer;
    }

    protected ImportResource getResource() throws ResourceException {
        ImportResourceHome home = (ImportResourceHome)ImportContext.getPortTypeContext().getWSHome();
        return (ImportResource)home.find((ResourceKey)this.importer.getResourceKey());
    }

    protected SimpleTable createTable(List<ColumnDefinition> tableDefintion) throws Exception {
        SimpleTable toReturn = null;
        try {
            this.logger.debug((Object)("definition size is " + tableDefintion.size()));
            for (ColumnDefinition cd : tableDefintion) {
                this.logger.debug((Object)cd.getDefinition());
            }
            CreateTable create = (CreateTable)DBSession.getImplementation(CreateTable.class);
            create.setTableName(this.tableName);
            create.setColumnsDefinition(tableDefintion.toArray(new ColumnDefinition[tableDefintion.size()]));
            this.logger.debug((Object)create.getExpression());
            toReturn = create.execute(this.session);
        }
        catch (Exception e) {
            this.logger.error((Object)"error creating table", (Throwable)e);
            throw e;
        }
        return toReturn;
    }

    protected File readStream() throws Exception {
        this.logger.trace((Object)("the locator is " + this.rslocator));
        long starttrasm = System.currentTimeMillis();
        File importFile = RSWrapper.getStreamFromLocator(new URI(this.rslocator));
        this.logger.debug((Object)("trasmission time: " + (System.currentTimeMillis() - starttrasm)));
        this.logger.trace((Object)("the file exists??" + importFile.exists()));
        this.logger.trace((Object)("file name is " + importFile.getAbsolutePath()));
        return importFile;
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        try {
            this.session = DBSession.connect();
            CSVReaderProcessor processor = new CSVReaderProcessor();
            processor.setDelimiter(this.delimiter);
            processor.setHasHeader(this.hasHeader);
            File temp_stream = this.readStream();
            this.execute(processor, temp_stream);
            this.getResource().store();
            long end = System.currentTimeMillis();
            this.logger.trace((Object)("the inserting took " + (end - start) + " millis "));
            this.importer.setEncoding(this.encoding);
            this.importer.store();
            temp_stream.delete();
            this.importer.setClosed();
        }
        catch (Exception e) {
            this.logger.error((Object)"error inserting data", (Throwable)e);
            try {
                this.getResource().remove();
            }
            catch (ResourceException e1) {
                this.logger.error((Object)"error removing resource (after import error)", (Throwable)e1);
            }
            this.importer.setErrorState();
        }
    }

    public abstract void execute(CSVReaderProcessor var1, File var2) throws Exception;

    public class LineProcessor
    implements CSVLineProcessor {
        public boolean continueProcessing() {
            return true;
        }

        public void processDataLine(int arg0, List<String> arg1) {
        }

        public void processHeaderLine(int arg0, List<String> arg1) {
        }
    }
}

