/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.thread;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReaderProcessor;
import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CopyFromCsv;
import org.gcube.common.dbinterface.queries.Insert;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.codelistmanager.util.csv.ImportUtil;
import org.gcube.contentmanagement.timeseriesservice.impl.importer.ImporterItem;
import org.gcube.contentmanagement.timeseriesservice.impl.thread.InsertThread;

public class InsertNormalizedT
extends InsertThread {
    private static final char tempSeparator = ',';
    private static final char tempQuoting = '\"';

    public InsertNormalizedT(String rslocator, String tableName, boolean hasHeader, char delimiter, String encoding, boolean[] fieldsMask, ImporterItem importer) {
        super(rslocator, tableName, fieldsMask, hasHeader, delimiter, encoding, importer);
    }

    @Override
    public void execute(CSVReaderProcessor processor, File fileStream) throws Exception {
        final ArrayList<String> fieldSetTmp = new ArrayList<String>();
        final ArrayList<ColumnDefinition> tableDefinition = new ArrayList<ColumnDefinition>();
        File tempCSV = File.createTempFile("dataTest", ".csv");
        this.logger.trace((Object)tempCSV.getAbsolutePath());
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tempCSV));
        final OutputStreamWriter sw = new OutputStreamWriter((OutputStream)bos, Charset.forName("utf-8"));
        processor.processStream((Reader)new InputStreamReader((InputStream)new FileInputStream(fileStream), this.encoding), (CSVLineProcessor)new InsertThread.LineProcessor(){

            @Override
            public void processDataLine(int lineNum, List<String> fields) {
                if (fields.size() != InsertNormalizedT.this.fieldsMask.length) {
                    InsertNormalizedT.this.logger.trace((Object)("the line " + lineNum + " is not correct"));
                    return;
                }
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < fields.size(); ++i) {
                    if (!InsertNormalizedT.this.fieldsMask[i]) continue;
                    buffer.append('\"' + fields.get(i) + '\"' + ',');
                }
                try {
                    sw.write(buffer.substring(0, buffer.length() - 1) + '\n');
                }
                catch (IOException e) {
                    InsertNormalizedT.this.logger.warn((Object)"error writing line");
                }
                InsertNormalizedT.this.processInitializationDataLine(lineNum, fields, fieldSetTmp, tableDefinition);
                InsertNormalizedT.this.totalEntries = lineNum;
            }

            @Override
            public void processHeaderLine(int line, List<String> fieldsLabel) {
                InsertNormalizedT.this.processInitializationHeaderLine(line, fieldsLabel, fieldSetTmp, tableDefinition);
            }
        });
        this.logger.trace((Object)("the column number is " + this.columnsNumber + " and the field mask size is " + this.fieldsMask.length));
        sw.close();
        if (this.columnsNumber != this.fieldsMask.length) {
            throw new Exception("the fieldMask size is different respect the field number");
        }
        this.importer.setFieldNames(fieldSetTmp);
        if (this.hasHeader) {
            --this.totalEntries;
        }
        this.importer.setExstimatedLines(this.totalEntries);
        this.logger.trace((Object)("lines read are " + this.totalEntries));
        this.logger.trace((Object)("creating table " + this.tableName + " with " + tableDefinition.size() + " fields"));
        SimpleTable table = this.createTable(tableDefinition);
        Insert insertValues = (Insert)DBSession.getImplementation(Insert.class);
        insertValues.setTable(table);
        ArrayList<String> fieldsNameOnTable = new ArrayList<String>();
        HashMap<String, int[]> fieldLenght = new HashMap<String, int[]>();
        for (int i = 1; i < tableDefinition.size(); ++i) {
            fieldLenght.put("field" + (i - 1), ((ColumnDefinition)tableDefinition.get(i)).getType().getPrecisionArray());
            fieldsNameOnTable.add("field" + (i - 1));
        }
        this.importer.setImportProgress(0);
        this.importer.store();
        CopyFromCsv copyFromCsv = (CopyFromCsv)DBSession.getImplementation(CopyFromCsv.class);
        copyFromCsv.setFile(tempCSV);
        copyFromCsv.setQuoting('\"');
        copyFromCsv.setSeparator(',');
        copyFromCsv.setTable((Table)table);
        copyFromCsv.setColumnList(fieldsNameOnTable);
        this.logger.trace((Object)("the copy query is " + copyFromCsv.getExpression()));
        copyFromCsv.execute(this.session);
        this.importer.setImportProgress(this.totalEntries);
        this.importer.store();
        tempCSV.delete();
        this.importer.setTotalLines(this.totalEntries);
        this.importer.setTable(table);
        this.getResource().setFieldLenght(fieldLenght);
        this.getResource().setTable(table);
    }

    private final void processInitializationDataLine(int lineNumber, List<String> fields, List<String> fieldSetTmp, List<ColumnDefinition> tableDefinition) {
        try {
            int i;
            int k;
            if (tableDefinition.size() == 0) {
                tableDefinition.add(Utility.getColumnDefinition((String)"id", (Type)new Type(Type.Types.INTEGER, new int[]{8}), (Specification[])new Specification[]{Specification.NOT_NULL, Specification.AUTO_INCREMENT}));
                k = 0;
                for (i = 0; i < fields.size(); ++i) {
                    if (!this.fieldsMask[i]) continue;
                    tableDefinition.add(Utility.getColumnDefinition((String)("field" + k), (Type)new Type(Type.Types.STRING, new int[]{1, 0}), (Specification[])new Specification[0]));
                    fieldSetTmp.add("field" + k);
                    ++k;
                }
            }
            if (this.columnsNumber == -1) {
                this.columnsNumber = fields.size();
            }
            k = 1;
            for (i = 0; i < fields.size(); ++i) {
                if (!this.fieldsMask[i]) continue;
                if (fields.get(i).length() > tableDefinition.get(k).getType().getPrecisionArray()[0]) {
                    tableDefinition.get((int)k).getType().getPrecisionArray()[0] = fields.get(i).length();
                }
                int templength = 0;
                templength = ImportUtil.getAfterDotLength((String)fields.get(i));
                if (templength > tableDefinition.get(k).getType().getPrecisionArray()[1]) {
                    tableDefinition.get((int)k).getType().getPrecisionArray()[1] = templength;
                }
                ++k;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"error reading lines", (Throwable)e);
        }
    }

    private final void processInitializationHeaderLine(int lineNumber, List<String> fieldsLabel, List<String> fieldSetTmp, List<ColumnDefinition> tableDefinition) {
        try {
            this.columnsNumber = fieldsLabel.size();
            tableDefinition.add(Utility.getColumnDefinition((String)"id", (Type)new Type(Type.Types.INTEGER, new int[]{8}), (Specification[])new Specification[]{Specification.NOT_NULL, Specification.AUTO_INCREMENT}));
            int k = 0;
            for (int i = 0; i < fieldsLabel.size(); ++i) {
                if (!this.fieldsMask[i]) continue;
                tableDefinition.add(Utility.getColumnDefinition((String)("field" + k), (Type)new Type(Type.Types.STRING, new int[]{1, 0}), (Specification[])new Specification[0]));
                if (fieldsLabel != null && fieldsLabel.get(i) != "") {
                    fieldSetTmp.add(fieldsLabel.get(i));
                } else {
                    fieldSetTmp.add("field" + k);
                }
                ++k;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"error initialization", (Throwable)e);
        }
    }
}

