/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.thread;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReaderProcessor;
import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Insert;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.codelistmanager.util.csv.ImportUtil;
import org.gcube.contentmanagement.timeseriesservice.impl.importer.ImporterItem;
import org.gcube.contentmanagement.timeseriesservice.impl.thread.InsertThread;

public class InsertDenomalizedT
extends InsertThread {
    private boolean[] attributesFieldMask;
    private String attributeLabel;
    private String valueLabel;

    public InsertDenomalizedT(String rslocator, String tableName, boolean hasHeader, char delimiter, String encoding, boolean[] fieldsMask, boolean[] attributesFieldMask, String attributeLabel, String valueLabel, ImporterItem importer) {
        super(rslocator, tableName, fieldsMask, hasHeader, delimiter, encoding, importer);
        this.attributeLabel = attributeLabel;
        this.valueLabel = valueLabel;
        this.attributesFieldMask = attributesFieldMask;
    }

    @Override
    public void execute(CSVReaderProcessor processor, File fileStream) throws Exception {
        this.logger.trace((Object)"starting denormalized import");
        if (!this.hasHeader) {
            throw new Exception("denormalized csv import MUST contain header");
        }
        final ArrayList<String> fieldSetTmp = new ArrayList<String>();
        final ArrayList<ColumnDefinition> tableDefinition = new ArrayList<ColumnDefinition>();
        final ArrayList attributesLabels = new ArrayList();
        processor.processStream((Reader)new InputStreamReader((InputStream)new FileInputStream(fileStream), this.encoding), (CSVLineProcessor)new InsertThread.LineProcessor(){

            @Override
            public void processDataLine(int lineNumber, List<String> fields) {
                InsertDenomalizedT.this.processInitializationDataLine(lineNumber, fields, tableDefinition);
                InsertDenomalizedT.this.totalEntries = lineNumber;
            }

            @Override
            public void processHeaderLine(int lineNumber, List<String> fields) {
                InsertDenomalizedT.this.columnDefinitionCreation(fields, fieldSetTmp, tableDefinition, attributesLabels);
            }
        });
        int attributesNumber = 0;
        int fieldSelected = 0;
        for (int i = 0; i < this.attributesFieldMask.length; ++i) {
            if (this.attributesFieldMask[i]) {
                ++attributesNumber;
            }
            if (!this.fieldsMask[i]) continue;
            ++fieldSelected;
        }
        if (this.hasHeader) {
            --this.totalEntries;
        }
        this.logger.trace((Object)("the column number is " + this.columnsNumber + " and the selected field are  " + fieldSelected + " ant the attributes are " + attributesNumber));
        this.importer.setExstimatedLines(this.totalEntries * attributesNumber);
        this.logger.trace((Object)("extimated lines are " + this.totalEntries * attributesNumber));
        this.importer.setFieldNames(fieldSetTmp);
        this.logger.trace((Object)("creating table " + this.tableName + " with " + tableDefinition.size() + " fields"));
        SimpleTable table = this.createTable(tableDefinition);
        final Insert insertValues = (Insert)DBSession.getImplementation(Insert.class);
        insertValues.setTable(table);
        this.totalEntries = 0;
        processor.processStream((Reader)new InputStreamReader((InputStream)new FileInputStream(fileStream), this.encoding), (CSVLineProcessor)new InsertThread.LineProcessor(){

            @Override
            public void processDataLine(int lineNumber, List<String> fields) {
                InsertDenomalizedT.this.insertingProcess(lineNumber, fields, insertValues, attributesLabels);
            }

            @Override
            public void processHeaderLine(int LineNumber, List<String> fields) {
            }
        });
        HashMap<String, int[]> fieldLenght = new HashMap<String, int[]>();
        for (int i = 1; i < tableDefinition.size(); ++i) {
            fieldLenght.put("field" + (i - 1), ((ColumnDefinition)tableDefinition.get(i)).getType().getPrecisionArray());
        }
        this.importer.setTotalLines(this.totalEntries);
        this.importer.setTable(table);
        this.getResource().setFieldLenght(fieldLenght);
        this.getResource().setTable(table);
    }

    private final void insertingProcess(int lineNumber, List<String> fields, Insert insertValues, List<String> attributesLabels) {
        try {
            int i;
            ArrayList<String> selectedValues = new ArrayList<String>();
            selectedValues.add("DEFAULT");
            int[] orderedAttributesValue = new int[attributesLabels.size()];
            int attributeIndex = 0;
            for (i = 0; i < fields.size(); ++i) {
                if (this.fieldsMask[i] & !this.attributesFieldMask[i]) {
                    selectedValues.add(fields.get(i) != null ? fields.get(i) : "");
                    continue;
                }
                if (!this.attributesFieldMask[i]) continue;
                orderedAttributesValue[attributeIndex++] = i;
            }
            for (i = 0; i < orderedAttributesValue.length; ++i) {
                try {
                    ArrayList<String> objectList = new ArrayList<String>();
                    objectList.addAll(selectedValues);
                    objectList.add(attributesLabels.get(i));
                    objectList.add(fields.get(orderedAttributesValue[i]));
                    insertValues.setInsertValues(objectList.toArray(new Object[objectList.size()]));
                    insertValues.execute(this.session);
                    ++this.totalEntries;
                    continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)"error inserting value", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)"error inserting values", (Throwable)e);
        }
        this.importer.setImportProgress(this.totalEntries);
    }

    private final void columnDefinitionCreation(List<String> fieldsLabel, List<String> fieldSetTmp, List<ColumnDefinition> tableDefinition, List<String> attributesLabels) {
        try {
            tableDefinition.add(Utility.getColumnDefinition((String)"id", (Type)new Type(Type.Types.INTEGER, new int[]{8}), (Specification[])new Specification[]{Specification.NOT_NULL, Specification.AUTO_INCREMENT}));
            int k = 0;
            this.columnsNumber = 0;
            int attributeMaxLength = -1;
            int attributeMaxDotLength = 0;
            for (int i = 0; i < fieldsLabel.size(); ++i) {
                if (this.fieldsMask[i] & !this.attributesFieldMask[i]) {
                    tableDefinition.add(Utility.getColumnDefinition((String)("field" + k), (Type)new Type(Type.Types.STRING, new int[]{1, 0}), (Specification[])new Specification[0]));
                    if (fieldsLabel != null && fieldsLabel.get(i) != "") {
                        fieldSetTmp.add(fieldsLabel.get(i));
                    } else {
                        fieldSetTmp.add("field" + k);
                    }
                    ++this.columnsNumber;
                    ++k;
                    continue;
                }
                if (!this.attributesFieldMask[i]) continue;
                if (attributeMaxLength < fieldsLabel.get(i).length()) {
                    attributeMaxLength = fieldsLabel.get(i).length();
                }
                int templength = 0;
                templength = ImportUtil.getAfterDotLength((String)fieldsLabel.get(i));
                if (templength > attributeMaxDotLength) {
                    attributeMaxDotLength = templength;
                }
                attributesLabels.add(fieldsLabel.get(i));
            }
            tableDefinition.add(Utility.getColumnDefinition((String)("field" + k), (Type)new Type(Type.Types.STRING, new int[]{attributeMaxLength, attributeMaxDotLength}), (Specification[])new Specification[0]));
            fieldSetTmp.add(this.attributeLabel);
            tableDefinition.add(Utility.getColumnDefinition((String)("field" + (k + 1)), (Type)new Type(Type.Types.STRING, new int[]{1, 0}), (Specification[])new Specification[0]));
            fieldSetTmp.add(this.valueLabel);
            this.columnsNumber += 2;
        }
        catch (Exception e) {
            this.logger.error((Object)"error reading column definition", (Throwable)e);
        }
    }

    private final void processInitializationDataLine(int lineNumber, List<String> fields, List<ColumnDefinition> tableDefinition) {
        if (fields.size() != this.fieldsMask.length) {
            return;
        }
        try {
            int k = 1;
            for (int i = 0; i < fields.size(); ++i) {
                int templength;
                if (this.fieldsMask[i] & !this.attributesFieldMask[i]) {
                    if (fields.get(i).length() > tableDefinition.get(k).getType().getPrecisionArray()[0]) {
                        tableDefinition.get((int)k).getType().getPrecisionArray()[0] = fields.get(i).length();
                    }
                    templength = 0;
                    templength = ImportUtil.getAfterDotLength((String)fields.get(i));
                    if (templength > tableDefinition.get(k).getType().getPrecisionArray()[1]) {
                        tableDefinition.get((int)k).getType().getPrecisionArray()[1] = templength;
                    }
                    ++k;
                    continue;
                }
                if (!this.attributesFieldMask[i]) continue;
                if (fields.get(i).length() > tableDefinition.get(tableDefinition.size() - 1).getType().getPrecisionArray()[0]) {
                    tableDefinition.get((int)(tableDefinition.size() - 1)).getType().getPrecisionArray()[0] = fields.get(i).length();
                }
                templength = 0;
                templength = ImportUtil.getAfterDotLength((String)fields.get(i));
                if (templength <= tableDefinition.get(tableDefinition.size() - 1).getType().getPrecisionArray()[1]) continue;
                tableDefinition.get((int)(tableDefinition.size() - 1)).getType().getPrecisionArray()[1] = templength;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"error reading lines", (Throwable)e);
        }
    }
}

