/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.importer;

import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ImportContext;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.importer.state.ImportResource;
import org.gcube.contentmanagement.timeseriesservice.impl.importer.state.ImportResourceHome;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Export;
import org.gcube.contentmanagement.timeseriesservice.stubs.ColumnDefinitionArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.DenormalizedImportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ExportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetProgressResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.ImportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.Limit;
import org.gcube.contentmanagement.timeseriesservice.stubs.State;
import org.globus.wsrf.ResourceException;

public class ImportManager {
    private GCUBELog logger = new GCUBELog(ImportManager.class);

    private ImportResource getResource() throws ResourceException {
        ImportResourceHome home = (ImportResourceHome)ImportContext.getPortTypeContext().getWSHome();
        return (ImportResource)home.find();
    }

    public VOID importOperation(ImportRequest request) throws GCUBEFault {
        try {
            this.getResource().getImporterReference().storeData(request);
        }
        catch (Exception e) {
            this.logger.error((Object)"error importing data", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error importing data"});
        }
        return new VOID();
    }

    public VOID denormalizedImportOperation(DenormalizedImportRequest request) throws GCUBEFault {
        try {
            this.getResource().getImporterReference().storeDenormalizedData(request);
        }
        catch (Exception e) {
            this.logger.error((Object)"error importing data", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error importing data"});
        }
        return new VOID();
    }

    public State getImportState(VOID request) throws GCUBEFault {
        try {
            return this.getResource().getImporterReference().getState();
        }
        catch (Exception e) {
            this.logger.error((Object)"error importing data");
            throw new GCUBEFault((Throwable)e, new String[]{"error importing data"});
        }
    }

    public String getDataAsJson(Limit limit) throws GCUBEFault {
        try {
            return this.getResource().getDataAsJson(limit);
        }
        catch (Exception e) {
            this.logger.error((Object)"error getting data", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error getting data"});
        }
    }

    public ColumnDefinitionArray getColumnsDefinition(VOID request) throws GCUBEFault {
        this.logger.debug((Object)("the caller scope " + ServiceContext.getContext().getScope()));
        try {
            return new ColumnDefinitionArray(this.getResource().getImporterReference().getColumnsDefinition());
        }
        catch (Exception e) {
            this.logger.error((Object)"error columns definition", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error getting columns definition"});
        }
    }

    public GetProgressResponse getProgress(VOID request) throws GCUBEFault {
        try {
            return new GetProgressResponse(this.getResource().getImporterReference().getImportProgress(), this.getResource().getImporterReference().getExstimatedLines());
        }
        catch (Exception e) {
            this.logger.error((Object)"error getting data");
            throw new GCUBEFault((Throwable)e, new String[]{"error calculating progress"});
        }
    }

    public String exportAsCsv(ExportRequest request) throws GCUBEFault {
        try {
            return Export.asCsv(request, this.getResource().getImporterReference().getColumnsDefinition(), this.getResource().getTable());
        }
        catch (Exception e) {
            this.logger.error((Object)"error performing export in csv", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }
}

