/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.editing;

import java.io.Serializable;
import java.util.LinkedList;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.Condition;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.conditions.OperatorCondition;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Delete;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.timeseriesservice.impl.editing.EditProxy;
import org.gcube.contentmanagement.timeseriesservice.impl.exceptions.OperationNotSupportedException;
import org.gcube.contentmanagement.timeseriesservice.impl.history.CurationHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.State;

public abstract class Edit
extends EditProxy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static GCUBELog logger = new GCUBELog(Edit.class);
    protected TYPE editorType = null;
    protected String ROW_ID_LABEL = "ID";
    protected final String CURATION_TABLE_ALIAS = "curtab";
    protected final String DIMENSION_TABLE_ALIAS = "dimtab";
    protected final String COUNT_ALIAS = "count";
    private SimpleTable correctsTable = null;
    private SimpleTable wrongsTable = null;
    protected String fieldId;
    protected boolean withoutErrors;
    protected String resourceId;
    protected int[] fieldlength;
    protected State isUnderInitialization;
    protected SimpleTable resourceTable;
    protected ColumnDefinition[] internalColumndefinition;
    protected LinkedList<CurationHistoryItem> historyEditorList = new LinkedList();

    public Edit(String resourceId, String fieldId, SimpleTable resourceTable, int[] fieldlength, boolean withoutError, String ... rowIdLabel) {
        this.resourceId = resourceId;
        this.resourceTable = resourceTable;
        this.fieldId = fieldId;
        this.fieldlength = fieldlength;
        this.withoutErrors = withoutError;
        if (rowIdLabel.length > 0) {
            this.ROW_ID_LABEL = rowIdLabel[0];
        }
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public TYPE getEditorType() {
        return this.editorType;
    }

    public int[] getFieldLength() {
        return this.fieldlength;
    }

    protected SimpleTable getCorrectsTable() {
        if (this.correctsTable == null) {
            this.correctsTable = new SimpleTable(this.getCorrectsTableName());
            try {
                this.correctsTable.initializeCount();
                this.correctsTable.initializeFieldMapping();
            }
            catch (Exception e) {
                logger.warn((Object)"error initializing corrects table", (Throwable)e);
            }
        }
        return this.correctsTable;
    }

    protected SimpleTable getWrongsTable() {
        if (this.wrongsTable == null) {
            this.wrongsTable = new SimpleTable(this.getWrongsTableName());
            try {
                this.wrongsTable.initializeCount();
                this.wrongsTable.initializeFieldMapping();
            }
            catch (Exception e) {
                logger.warn((Object)"error initializing wrongs table", (Throwable)e);
            }
        }
        return this.wrongsTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        this.setIsUnderInitialization(State.Open);
        DBSession session = null;
        logger.trace((Object)"entering in edit mode");
        try {
            session = DBSession.connect();
            long start = System.currentTimeMillis();
            this.internalInitialize(session);
            logger.debug((Object)("Enter in EditMode time is:" + (System.currentTimeMillis() - start) / 1000L + " sec"));
            this.setIsUnderInitialization(State.Close);
        }
        catch (Exception e) {
            logger.error((Object)"failed trying to enter in edit mode", (Throwable)e);
            this.dismiss();
            this.setIsUnderInitialization(State.Error);
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    protected abstract void internalInitialize(DBSession var1) throws Exception;

    public abstract long check() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws Exception {
        logger.debug((Object)"save started");
        if (this.errorCount() > 0L) {
            throw new Exception("the Time Series is not totally curated");
        }
        DBSession session = null;
        try {
            session = DBSession.connect();
            long start = System.currentTimeMillis();
            try {
                Utility.drop((String)this.getWrongsTableName()).execute(session);
            }
            catch (Exception e) {
                logger.debug((Object)"the wrong table have been already deleted");
            }
            String temporaryTable = this.resourceTable.getTableName() + "_TMP";
            Utility.renameTable((Table)this.resourceTable, (String)temporaryTable).execute(session);
            Utility.renameTable((Table)this.getCorrectsTable(), (String)this.resourceTable.getTableName()).execute(session);
            Utility.drop((String)temporaryTable).execute(session);
            this.resourceTable.initializeCount();
            this.resourceTable.initializeFieldMapping();
            logger.trace((Object)("save column time with drop " + (System.currentTimeMillis() - start) / 1000L + "s"));
            logger.trace((Object)("save column time is " + (System.currentTimeMillis() - start) / 1000L + "s"));
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResultAsJson(Select query, boolean onlyErrors) throws OperationNotSupportedException, Exception {
        DBSession session = null;
        if (onlyErrors) {
            try {
                session = DBSession.connect();
                query.setTables(new Table[]{this.getWrongsTable()});
                String string = query.getResultAsJSon(session, true, new boolean[0]);
                return string;
            }
            finally {
                if (session != null) {
                    session.release();
                }
            }
        }
        throw new OperationNotSupportedException();
    }

    public long errorCount() throws Exception {
        if (this.withoutErrors) {
            return 0L;
        }
        this.getWrongsTable().initializeCount();
        return this.getWrongsTable().getCount();
    }

    public long totalCount() throws Exception {
        this.getWrongsTable().initializeCount();
        this.getCorrectsTable().initializeCount();
        return this.getWrongsTable().getCount() + this.getCorrectsTable().getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dismiss() {
        DBSession session = null;
        try {
            session = DBSession.connect();
            try {
                Utility.drop((String)this.getWrongsTableName()).execute(session);
            }
            catch (Exception e) {
                logger.warn((Object)"error deleting wrongs fields table dismissing the field editor");
            }
            try {
                Utility.drop((String)this.getCorrectsTableName()).execute(session);
            }
            catch (Exception e) {
                logger.warn((Object)"error deleting corrects fields table dismissing the field editor");
            }
        }
        catch (Exception e) {
            logger.warn((Object)"an error occurs connection on the db");
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    public State getIsUnderInitialization() {
        return this.isUnderInitialization;
    }

    public void setIsUnderInitialization(State isUnderInitialization) {
        this.isUnderInitialization = isUnderInitialization;
    }

    public void setIsUnderInitialization(String isUnderInitialization) {
        this.isUnderInitialization = State.fromString((String)isUnderInitialization);
    }

    public LinkedList<CurationHistoryItem> getHistoryItems() {
        return this.historyEditorList;
    }

    public void setHistoryItems(LinkedList<CurationHistoryItem> historyEditorList) {
        this.historyEditorList = historyEditorList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeAllErrors() throws Exception {
        DBSession session = null;
        try {
            session = DBSession.connect();
            Delete delete = (Delete)DBSession.getImplementation(Delete.class);
            delete.setTable((Table)this.getWrongsTable());
            delete.execute(session);
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
        this.getCorrectsTable().initializeCount();
        return this.getCorrectsTable().getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeSingleError(long rowId) throws Exception {
        DBSession session = null;
        try {
            Delete delete = (Delete)DBSession.getImplementation(Delete.class);
            delete.setTable((Table)this.getWrongsTable());
            delete.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(this.ROW_ID_LABEL), (Object)rowId, "="));
            delete.execute(session);
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
        return (int)this.totalCount();
    }

    protected String getCorrectsTableName() {
        return "C" + this.fieldId + this.resourceId.replaceAll("-", "_");
    }

    protected String getWrongsTableName() {
        return "W" + this.fieldId + this.resourceId.replaceAll("-", "_");
    }

    public static enum TYPE {
        Dimesion,
        Column,
        CodeListRelation;

    }
}

