/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.editing;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.CastObject;
import org.gcube.common.dbinterface.ColumnDefinition;
import org.gcube.common.dbinterface.Condition;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.attributes.AggregatedAttribute;
import org.gcube.common.dbinterface.attributes.AggregationFunctions;
import org.gcube.common.dbinterface.attributes.AssignedAttribute;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.conditions.ANDCondition;
import org.gcube.common.dbinterface.conditions.IsInOperator;
import org.gcube.common.dbinterface.conditions.Listable;
import org.gcube.common.dbinterface.conditions.OperatorCondition;
import org.gcube.common.dbinterface.conditions.StringArray;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CreateTable;
import org.gcube.common.dbinterface.queries.Delete;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.queries.Selection;
import org.gcube.common.dbinterface.queries.Update;
import org.gcube.common.dbinterface.queries.alters.ModifyColumnType;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.tables.TableFromSubselect;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.codelistmanager.entities.CodeList;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.data.SingleResult;
import org.gcube.contentmanagement.lexicalmatcher.analysis.run.CategoryGuesser;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.editing.Edit;
import org.gcube.contentmanagement.timeseriesservice.impl.exceptions.OperationNotSupportedException;
import org.gcube.contentmanagement.timeseriesservice.impl.history.CurationHistoryItem;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.Dimension;
import org.gcube.contentmanagement.timeseriesservice.stubs.EntryType;
import org.gcube.contentmanagement.timeseriesservice.stubs.ErrorPair;
import org.gcube.contentmanagement.timeseriesservice.stubs.Key;
import org.gcube.contentmanagement.timeseriesservice.stubs.ValueNotCompatibleFault;

public class DimensionEditor
extends Edit {
    private static final long serialVersionUID = -2639004246980289519L;
    private static transient GCUBELog logger = new GCUBELog(DimensionEditor.class);
    private Type oldColumnType;
    private String keyId;
    private String keyName;
    private Type keyType;
    private String codeFieldIdInDimension;
    private Type codeTypeInDimension;
    private String dimensionTableNameHuman;
    private Collection<Attribute> attributesList;
    private String codelistId;
    protected SimpleTable dimensionTable;

    public DimensionEditor(String resourceId, String fieldId, String codelistId, String keyId, SimpleTable resourceTable, int[] fieldlength, int resourceTableCount, boolean withoutErrors) throws Exception {
        super(resourceId, fieldId, resourceTable, fieldlength, withoutErrors, new String[0]);
        this.editorType = Edit.TYPE.Dimesion;
        CodeList codelist = CodeList.get((String)codelistId);
        this.dimensionTable = codelist.getTable();
        this.dimensionTableNameHuman = codelist.getName();
        this.keyName = ((TableField)codelist.getLabelFieldMapping().get(keyId)).getFieldName();
        this.codelistId = codelistId;
        this.keyId = keyId;
        this.codeFieldIdInDimension = codelist.getCodeColumnId();
        this.codeTypeInDimension = (Type)codelist.getTable().getFieldsMapping().get(this.codeFieldIdInDimension);
        this.historyEditorList.add(new CurationHistoryItem("", "for column " + fieldId + " setting dimension " + this.dimensionTableNameHuman + " and key id " + this.keyId, new Timestamp(System.currentTimeMillis()), CurationHistoryItem.OperationType.COLUMN_TYPE_SET));
    }

    @Override
    public void internalInitialize(DBSession session) throws Exception {
        this.keyType = (Type)this.dimensionTable.getFieldsMapping().get(this.keyId);
        this.resourceTable.initializeFieldMapping();
        ArrayList<SimpleAttribute> correctTableReplaceAttributes = new ArrayList<SimpleAttribute>();
        ArrayList<Attribute> correctCurationTableAttributeToTake = new ArrayList<Attribute>();
        ArrayList<Attribute> wrongCurationTableAttributeToTake = new ArrayList<Attribute>();
        ArrayList<ColumnDefinition> correctColumnDefinitionArray = new ArrayList<ColumnDefinition>(this.resourceTable.getFieldsMapping().size());
        ArrayList<ColumnDefinition> wrongColumnDefinitionArray = new ArrayList<ColumnDefinition>(this.resourceTable.getFieldsMapping().size());
        for (Map.Entry entry : this.resourceTable.getFieldsMapping().entrySet()) {
            ColumnDefinition colDef = null;
            if (((String)entry.getKey()).equals(this.fieldId)) {
                colDef = Utility.getColumnDefinition((String)((String)entry.getKey()), (Type)this.keyType, (Specification[])new Specification[0]);
                CastObject castCur = Utility.getCast((SimpleAttribute)new SimpleAttribute((String)entry.getKey(), "curtab"), (Type)this.keyType);
                castCur.setUseCastFunction(true);
                correctCurationTableAttributeToTake.add((Attribute)new AssignedAttribute(new SimpleAttribute((String)entry.getKey()), (Object)castCur));
                wrongCurationTableAttributeToTake.add((Attribute)new SimpleAttribute((String)entry.getKey()));
                this.oldColumnType = (Type)entry.getValue();
                correctColumnDefinitionArray.add(colDef);
                wrongColumnDefinitionArray.add(Utility.getColumnDefinition((String)((String)entry.getKey()), (Type)((Type)entry.getValue()), (Specification[])new Specification[0]));
                continue;
            }
            if (((String)entry.getKey()).equals(this.fieldId + "_id")) continue;
            colDef = Utility.getColumnDefinition((String)((String)entry.getKey()), (Type)((Type)entry.getValue()), (Specification[])new Specification[0]);
            correctTableReplaceAttributes.add(new SimpleAttribute((String)entry.getKey()));
            correctCurationTableAttributeToTake.add((Attribute)new AssignedAttribute(new SimpleAttribute((String)entry.getKey()), (Object)new SimpleAttribute((String)entry.getKey(), "curtab")));
            wrongCurationTableAttributeToTake.add((Attribute)new AssignedAttribute(new SimpleAttribute((String)entry.getKey()), (Object)new SimpleAttribute((String)entry.getKey(), "curtab")));
            correctColumnDefinitionArray.add(colDef);
            wrongColumnDefinitionArray.add(colDef);
        }
        ColumnDefinition colDef = Utility.getColumnDefinition((String)(this.fieldId + "_id"), (Type)this.codeTypeInDimension, (Specification[])new Specification[0]);
        correctColumnDefinitionArray.add(colDef);
        wrongColumnDefinitionArray.add(colDef);
        CreateTable createQuery = (CreateTable)DBSession.getImplementation(CreateTable.class);
        createQuery.setTableName(this.getCorrectsTableName());
        createQuery.setColumnsDefinition(correctColumnDefinitionArray.toArray(new ColumnDefinition[correctColumnDefinitionArray.size()]));
        logger.trace((Object)("corrects table: " + createQuery.getExpression()));
        createQuery.execute(session);
        wrongColumnDefinitionArray.add(Utility.getColumnDefinition((String)"count", (Type)new Type(Type.Types.INTEGER, new int[]{8}), (Specification[])new Specification[0]));
        CreateTable createWrongQuery = (CreateTable)DBSession.getImplementation(CreateTable.class);
        createWrongQuery.setTableName(this.getWrongsTableName());
        createWrongQuery.setColumnsDefinition(wrongColumnDefinitionArray.toArray(new ColumnDefinition[0]));
        logger.trace((Object)("wrongs table:  " + createWrongQuery.getExpression()));
        createWrongQuery.execute(session);
        this.insertCorretElementsTable(session, correctCurationTableAttributeToTake);
        this.insertWrongElementsTable(session, wrongCurationTableAttributeToTake);
        this.attributesList = Collections.unmodifiableCollection(correctTableReplaceAttributes);
    }

    @Override
    public String getFieldId() {
        return this.fieldId;
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public void setKeyType(Type keyType) {
        this.keyType = keyType;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyName(String keyId) {
        this.keyId = keyId;
    }

    public String getCodelistId() {
        return this.codelistId;
    }

    public void setCodelistId(String codelistId) {
        this.codelistId = codelistId;
    }

    public String getDimensionTableNameHuman() {
        return this.dimensionTableNameHuman;
    }

    public void setDimensionTableNameHuman(String dimensionTableNameHuman) {
        this.dimensionTableNameHuman = dimensionTableNameHuman;
    }

    @Override
    public void modifyEntryId(String fieldId, String newId, long rowId) throws Exception {
        logger.info((Object)("modifying a column under editing with values " + fieldId + " " + newId + " " + rowId));
        DBSession session = DBSession.connect();
        Select selectQuery = (Select)DBSession.getImplementation(Select.class);
        selectQuery.setAttributes(new Attribute[]{new SimpleAttribute(this.keyId)});
        CastObject idCast = Utility.getCast((String)newId, (Type)this.codeTypeInDimension);
        selectQuery.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(this.codeFieldIdInDimension), (Object)idCast, "="));
        selectQuery.setTables(new Table[]{this.dimensionTable});
        logger.trace((Object)("select query for check value compatibility is " + selectQuery.getExpression()));
        ResultSet selectQueryRS = selectQuery.getResults(session, new boolean[0]);
        if (selectQueryRS.next()) {
            String newValue = selectQueryRS.getString(1);
            try {
                ArrayList<Attribute> attributesToTake = this.cloneAttributeList();
                CastObject cast = Utility.getCast((String)newValue, (Type)this.keyType);
                attributesToTake.add((Attribute)new AssignedAttribute(new SimpleAttribute(fieldId), (Object)cast));
                attributesToTake.add((Attribute)new AssignedAttribute(new SimpleAttribute(fieldId + "_id"), (Object)idCast));
                Select modifiedEntriesQuery = (Select)DBSession.getImplementation(Select.class);
                modifiedEntriesQuery.setAttributes(attributesToTake.toArray(new Attribute[0]));
                modifiedEntriesQuery.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(this.ROW_ID_LABEL), (Object)new Long(rowId), "="));
                modifiedEntriesQuery.setTables(new Table[]{this.getWrongsTable()});
                InsertFromSelect insert = (InsertFromSelect)DBSession.getImplementation(InsertFromSelect.class);
                insert.setSubQuery(modifiedEntriesQuery);
                insert.setTable(this.getCorrectsTable());
                logger.trace((Object)("insert query for modifyEntryId is " + insert.getExpression()));
                insert.execute(session);
                Delete deleteQuery = (Delete)DBSession.getImplementation(Delete.class);
                deleteQuery.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(this.ROW_ID_LABEL), (Object)new Long(rowId), "="));
                deleteQuery.setTable((Table)this.getWrongsTable());
                deleteQuery.execute(session);
            }
            catch (Exception e) {
                logger.warn((Object)"error updating wrong entries table", (Throwable)e);
            }
        } else {
            throw new ValueNotCompatibleFault();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyDistinctEntryId(String fieldId, String newId, long rowId, String dimensionId, String keyName) throws Exception {
        block9: {
            logger.info((Object)"modifying a column under editing");
            DBSession session = DBSession.connect();
            try {
                CodeList codelist = CodeList.get((String)dimensionId);
                String dimTableName = codelist.getTable().getTableName();
                String codeFieldId = codelist.getCodeColumnId();
                Type codeColumnType = (Type)codelist.getTable().getFieldsMapping().get(codeFieldId);
                CastObject idCast = Utility.getCast((String)newId, (Type)codeColumnType);
                Select newValueQuery = (Select)DBSession.getImplementation(Select.class);
                newValueQuery.setAttributes(new Attribute[]{new SimpleAttribute(keyName)});
                newValueQuery.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(codeFieldId), (Object)idCast, "="));
                newValueQuery.setTables(new Table[]{new Table(dimTableName)});
                ResultSet newValueRS = newValueQuery.getResults(session, new boolean[0]);
                if (newValueRS.next()) {
                    String newValue = newValueRS.getString(0);
                    Type keyType = (Type)this.resourceTable.getFieldsMapping().get(fieldId);
                    CastObject cast = Utility.getCast((String)newValue, (Type)keyType);
                    this.valueSizeControl(newValue, keyType);
                    try {
                        Update updateWrong = (Update)DBSession.getImplementation(Update.class);
                        updateWrong.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(this.ROW_ID_LABEL), (Object)new Long(rowId), "="));
                        updateWrong.setOperators(new OperatorCondition[]{new OperatorCondition((Object)new SimpleAttribute(fieldId), (Object)cast, "="), new OperatorCondition((Object)new SimpleAttribute(fieldId + "_id"), (Object)idCast, "=")});
                        updateWrong.setTable((Table)this.getWrongsTable());
                        updateWrong.execute(session);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"error updating wrong entries table", (Throwable)e);
                    }
                    try {
                        Update updateCorrect = (Update)DBSession.getImplementation(Update.class);
                        updateCorrect.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(this.ROW_ID_LABEL), (Object)new Long(rowId), "="));
                        updateCorrect.setOperators(new OperatorCondition[]{new OperatorCondition((Object)new SimpleAttribute(fieldId), (Object)cast, "="), new OperatorCondition((Object)new SimpleAttribute(fieldId + "_id"), (Object)idCast, "=")});
                        updateCorrect.setTable((Table)this.getCorrectsTable());
                        updateCorrect.execute(session);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"error updating correct entries table", (Throwable)e);
                    }
                    break block9;
                }
                throw new ValueNotCompatibleFault();
            }
            finally {
                if (session != null) {
                    session.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyDistinctEntryValue(String fieldId, long rowId, String newValue) throws Exception {
        DBSession session = DBSession.connect();
        try {
            Update updateCorrect;
            this.valueSizeControl(newValue, this.keyType);
            CastObject cast = Utility.getCast((String)newValue, (Type)this.keyType);
            try {
                updateCorrect = (Update)DBSession.getImplementation(Update.class);
                updateCorrect.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(this.ROW_ID_LABEL), (Object)new Long(rowId), "="));
                updateCorrect.setOperators(new OperatorCondition[]{new OperatorCondition((Object)new SimpleAttribute(fieldId), (Object)cast, "=")});
                updateCorrect.setTable((Table)this.getCorrectsTable());
                updateCorrect.execute(session);
            }
            catch (Exception e) {
                logger.warn((Object)"rowId not found in correct entries table");
            }
            try {
                updateCorrect = (Update)DBSession.getImplementation(Update.class);
                updateCorrect.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(this.ROW_ID_LABEL), (Object)new Long(rowId), "="));
                updateCorrect.setOperators(new OperatorCondition[]{new OperatorCondition((Object)new SimpleAttribute(fieldId), (Object)cast, "=")});
                updateCorrect.setTable((Table)this.getWrongsTable());
                updateCorrect.execute(session);
            }
            catch (Exception e) {
                logger.warn((Object)"rowId not found in wrong entries table");
            }
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceIds(String fieldId, String oldId, String newId) throws Exception {
        block7: {
            DBSession session = DBSession.connect();
            try {
                Select selectQuery = (Select)DBSession.getImplementation(Select.class);
                selectQuery.setAttributes(new Attribute[]{new SimpleAttribute(this.keyId)});
                CastObject idCast = Utility.getCast((String)newId, (Type)this.codeTypeInDimension);
                selectQuery.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(this.codeFieldIdInDimension), (Object)idCast, "="));
                selectQuery.setTables(new Table[]{this.dimensionTable});
                ResultSet selectQueryRS = selectQuery.getResults(session, new boolean[0]);
                if (selectQueryRS.next()) {
                    String newValue = selectQueryRS.getString(0);
                    try {
                        ArrayList<Attribute> attributesToTake = this.cloneAttributeList();
                        CastObject cast = Utility.getCast((String)newValue, (Type)this.keyType);
                        attributesToTake.add((Attribute)new AssignedAttribute(new SimpleAttribute(fieldId), (Object)cast));
                        attributesToTake.add((Attribute)new AssignedAttribute(new SimpleAttribute(fieldId + "_id"), (Object)idCast));
                        CastObject oldIdCast = Utility.getCast((String)oldId, (Type)this.codeTypeInDimension);
                        Select modifiedEntriesQuery = (Select)DBSession.getImplementation(Select.class);
                        modifiedEntriesQuery.setAttributes(attributesToTake.toArray(new Attribute[0]));
                        modifiedEntriesQuery.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(fieldId + "_id"), (Object)oldIdCast, "="));
                        modifiedEntriesQuery.setTables(new Table[]{this.getWrongsTable()});
                        InsertFromSelect insert = (InsertFromSelect)DBSession.getImplementation(InsertFromSelect.class);
                        insert.setSubQuery(modifiedEntriesQuery);
                        insert.setTable(this.getCorrectsTable());
                        insert.execute(session);
                        Delete deleteQuery = (Delete)DBSession.getImplementation(Delete.class);
                        deleteQuery.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(fieldId + "_id"), (Object)oldIdCast, "="));
                        deleteQuery.setTable((Table)this.getWrongsTable());
                        deleteQuery.execute(session);
                    }
                    catch (Exception e) {
                        logger.error((Object)"error replacing entries", (Throwable)e);
                    }
                    break block7;
                }
                throw new ValueNotCompatibleFault();
            }
            finally {
                if (session != null) {
                    session.release();
                }
            }
        }
    }

    @Override
    public void replaceDistinctValue(String fieldId, String newValue, String oldValue) throws Exception {
    }

    @Override
    public void replaceDistinctIds(String fieldId, String oldId, String newId, String keyName) throws Exception {
    }

    @Override
    public int[] getFieldLength() {
        return this.fieldlength;
    }

    public void setFieldLength(int[] fieldLength) {
        this.fieldlength = fieldLength;
    }

    private void valueSizeControl(String value, Type keyType) throws Exception {
        if (value.length() > this.fieldlength[0]) {
            DBSession session = DBSession.connect();
            ModifyColumnType modColumn = (ModifyColumnType)DBSession.getImplementation(ModifyColumnType.class);
            modColumn.setColumn(new SimpleAttribute(this.fieldId));
            modColumn.setNewType(new Type(keyType.getType(), new int[]{value.length()}));
            modColumn.setTable((Table)this.getCorrectsTable());
            modColumn.execute(session);
            modColumn.setTable((Table)this.getWrongsTable());
            modColumn.execute(session);
            int precisionFloat = 0;
            if (value.contains(".")) {
                precisionFloat = value.split("\\.")[1].length();
            }
            this.fieldlength = new int[]{value.length(), precisionFloat};
            session.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceEntryValueWithId(String oldValue, String newId, String fieldId) throws Exception {
        block7: {
            logger.trace((Object)("replaceEntryValueWithId method with oldValue " + oldValue + " newId " + newId + " fieldId " + fieldId));
            DBSession session = DBSession.connect();
            try {
                Select selectQuery = (Select)DBSession.getImplementation(Select.class);
                selectQuery.setAttributes(new Attribute[]{new SimpleAttribute(this.keyId)});
                CastObject idCast = Utility.getCast((String)newId, (Type)this.codeTypeInDimension);
                selectQuery.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(this.codeFieldIdInDimension), (Object)idCast, "="));
                selectQuery.setTables(new Table[]{this.dimensionTable});
                logger.trace((Object)selectQuery.getExpression());
                ResultSet selectQueryRS = selectQuery.getResults(session, new boolean[0]);
                if (selectQueryRS.next()) {
                    String newValue = selectQueryRS.getString(1);
                    logger.trace((Object)("new value is " + newValue));
                    try {
                        ArrayList<Attribute> attributesToTake = this.cloneAttributeList();
                        CastObject cast = Utility.getCast((String)newValue, (Type)this.keyType);
                        attributesToTake.add((Attribute)new AssignedAttribute(new SimpleAttribute(fieldId), (Object)cast));
                        attributesToTake.add((Attribute)new AssignedAttribute(new SimpleAttribute(fieldId + "_id"), (Object)idCast));
                        CastObject castOldValue = Utility.getCast((String)oldValue, (Type)this.oldColumnType);
                        Select modifiedEntriesQuery = (Select)DBSession.getImplementation(Select.class);
                        modifiedEntriesQuery.setAttributes(attributesToTake.toArray(new Attribute[0]));
                        modifiedEntriesQuery.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(fieldId), (Object)castOldValue, "="));
                        modifiedEntriesQuery.setTables(new Table[]{this.getWrongsTable()});
                        InsertFromSelect insert = (InsertFromSelect)DBSession.getImplementation(InsertFromSelect.class);
                        insert.setSubQuery(modifiedEntriesQuery);
                        insert.setTable(this.getCorrectsTable());
                        logger.trace((Object)insert.getExpression());
                        insert.execute(session);
                        Delete deleteQuery = (Delete)DBSession.getImplementation(Delete.class);
                        deleteQuery.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(fieldId), (Object)castOldValue, "="));
                        deleteQuery.setTable((Table)this.getWrongsTable());
                        logger.trace((Object)deleteQuery.getExpression());
                        deleteQuery.execute(session);
                    }
                    catch (Exception e) {
                        logger.error((Object)"error replacing entries", (Throwable)e);
                    }
                    break block7;
                }
                throw new ValueNotCompatibleFault();
            }
            finally {
                if (session != null) {
                    session.release();
                }
            }
        }
    }

    private void insertCorretElementsTable(DBSession session, List<Attribute> curationTableAttributeToTake) throws Exception {
        String TEMPORARY_DIMENSION_TABLE = "tempdimtable";
        String SELECTED_FIELD = "selected_field";
        Select goodCellsCount = (Select)DBSession.getImplementation(Select.class);
        goodCellsCount.setTables(new Table[]{this.dimensionTable});
        goodCellsCount.setAttributes(new Attribute[]{new AssignedAttribute(new SimpleAttribute("count"), (Object)new AggregatedAttribute("*", AggregationFunctions.COUNT)), new AssignedAttribute(new SimpleAttribute("selected_field"), (Object)new SimpleAttribute(this.keyId))});
        goodCellsCount.setGroups(new SimpleAttribute[]{new SimpleAttribute("selected_field")});
        Select totalCorrectQuery = (Select)DBSession.getImplementation(Select.class);
        ArrayList<Object> attributes = new ArrayList<Object>();
        attributes.addAll(curationTableAttributeToTake);
        attributes.add(new AssignedAttribute(new SimpleAttribute(this.fieldId + "_id"), (Object)new SimpleAttribute(this.codeFieldIdInDimension, "tempdimtable")));
        totalCorrectQuery.setAttributes(attributes.toArray(new Attribute[0]));
        CastObject castFieldToText = Utility.getCastToString((SimpleAttribute)new SimpleAttribute(this.fieldId, "curtab"));
        CastObject castSelectDimFieldToText = Utility.getCastToString((SimpleAttribute)new SimpleAttribute("selected_field", "dimtab"));
        totalCorrectQuery.setFilter((Condition)new ANDCondition(new Condition[]{new OperatorCondition((Object)new SimpleAttribute(this.keyId, "tempdimtable"), (Object)new SimpleAttribute("selected_field", "dimtab"), "="), new OperatorCondition((Object)castFieldToText, (Object)castSelectDimFieldToText, "="), new OperatorCondition((Object)new SimpleAttribute("count", "dimtab"), (Object)1, "=")}));
        totalCorrectQuery.setTables(new Table[]{new Table(this.dimensionTable.getTableName(), "tempdimtable"), new Table(this.resourceTable.getTableName(), "curtab"), new TableFromSubselect("dimtab", (Selection)goodCellsCount)});
        totalCorrectQuery.setUseDistinct(true);
        InsertFromSelect insertCorrect = (InsertFromSelect)DBSession.getImplementation(InsertFromSelect.class);
        insertCorrect.setSubQuery(totalCorrectQuery);
        insertCorrect.setTable(this.getCorrectsTable());
        logger.trace((Object)insertCorrect.getExpression());
        insertCorrect.execute(session);
        logger.trace((Object)("the count for correct element is " + this.getCorrectsTable().getCount()));
    }

    private void insertWrongElementsTable(DBSession session, List<Attribute> curationTableAttributeToTake) throws Exception {
        String SELECTED_FIELD = "selected_field";
        Select wrongCellsCount = (Select)DBSession.getImplementation(Select.class);
        wrongCellsCount.setTables(new Table[]{this.dimensionTable});
        wrongCellsCount.setAttributes(new Attribute[]{new AssignedAttribute(new SimpleAttribute("count"), (Object)new AggregatedAttribute("*", AggregationFunctions.COUNT)), new AssignedAttribute(new SimpleAttribute("selected_field"), (Object)new SimpleAttribute(this.keyId))});
        wrongCellsCount.setGroups(new SimpleAttribute[]{new SimpleAttribute("selected_field")});
        Select totalWrongQuery = (Select)DBSession.getImplementation(Select.class);
        ArrayList<Object> attributes = new ArrayList<Object>();
        attributes.addAll(curationTableAttributeToTake);
        attributes.add(new AssignedAttribute(new SimpleAttribute(this.fieldId + "_id"), null));
        attributes.add(new AssignedAttribute(new SimpleAttribute("count"), (Object)new SimpleAttribute("count", "dimtab")));
        totalWrongQuery.setAttributes(attributes.toArray(new Attribute[0]));
        CastObject castFieldToText = Utility.getCastToString((SimpleAttribute)new SimpleAttribute(this.fieldId, "curtab"));
        CastObject castSelectDimFieldToText = Utility.getCastToString((SimpleAttribute)new SimpleAttribute("selected_field", "dimtab"));
        totalWrongQuery.setFilter((Condition)new ANDCondition(new Condition[]{new OperatorCondition((Object)castFieldToText, (Object)castSelectDimFieldToText, "="), new OperatorCondition((Object)new SimpleAttribute("count", "dimtab"), (Object)1, ">")}));
        totalWrongQuery.setTables(new Table[]{new Table(this.resourceTable.getTableName(), "curtab"), new TableFromSubselect("dimtab", (Selection)wrongCellsCount)});
        InsertFromSelect insertWrongWithIds = (InsertFromSelect)DBSession.getImplementation(InsertFromSelect.class);
        insertWrongWithIds.setSubQuery(totalWrongQuery);
        insertWrongWithIds.setTable(this.getWrongsTable());
        logger.trace((Object)insertWrongWithIds.getExpression());
        insertWrongWithIds.execute(session);
        logger.trace((Object)"inserted value in wrong table (first part)");
        Select withoutIdsWrongQuery = (Select)DBSession.getImplementation(Select.class);
        attributes = new ArrayList();
        attributes.addAll(curationTableAttributeToTake);
        attributes.add(new AssignedAttribute(new SimpleAttribute(this.fieldId + "_id"), null));
        attributes.add(new AssignedAttribute(new SimpleAttribute("count"), (Object)0));
        withoutIdsWrongQuery.setAttributes(attributes.toArray(new Attribute[0]));
        withoutIdsWrongQuery.setTables(new Table[]{new Table(this.resourceTable.getTableName(), "curtab")});
        Select internalWrongQuery = (Select)DBSession.getImplementation(Select.class);
        CastObject castKeyFieldToText = Utility.getCastToString((SimpleAttribute)new SimpleAttribute(this.keyId));
        internalWrongQuery.setAttributes(new Attribute[]{new SimpleAttribute(this.keyId)});
        internalWrongQuery.setFilter((Condition)new OperatorCondition((Object)castFieldToText, (Object)castKeyFieldToText, "="));
        internalWrongQuery.setTables(new Table[]{this.dimensionTable});
        withoutIdsWrongQuery.setFilter((Condition)new OperatorCondition((Object)internalWrongQuery, "NOT EXISTS"));
        InsertFromSelect insertWrongWithoutIds = (InsertFromSelect)DBSession.getImplementation(InsertFromSelect.class);
        insertWrongWithoutIds.setSubQuery(withoutIdsWrongQuery);
        insertWrongWithoutIds.setTable(this.getWrongsTable());
        logger.trace((Object)insertWrongWithoutIds.getExpression());
        insertWrongWithoutIds.execute(session);
        logger.trace((Object)"inserted value in wrong table (second part)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ErrorPair> getDistinctErrors() throws Exception {
        Select select = (Select)DBSession.getImplementation(Select.class);
        select.setUseDistinct(true);
        select.setAttributes(new Attribute[]{new AggregatedAttribute("*", AggregationFunctions.COUNT), new SimpleAttribute(this.getFieldId())});
        select.setTables(new Table[]{this.getWrongsTable()});
        select.setGroups(new SimpleAttribute[]{new SimpleAttribute(this.getFieldId())});
        DBSession session = DBSession.connect();
        ArrayList<ErrorPair> resultlist = new ArrayList<ErrorPair>();
        try {
            ResultSet result = select.getResults(new boolean[0]);
            while (result.next()) {
                resultlist.add(new ErrorPair(result.getInt(1), result.getString(2)));
            }
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
        return resultlist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long check() throws Exception {
        DBSession session = DBSession.connect();
        try {
            String curationTableAlias = "curtab";
            String dimensionTableAlias = "dimtab";
            String countAlias = "count";
            Select goodCellsCount = (Select)DBSession.getImplementation(Select.class);
            goodCellsCount.setAttributes(new Attribute[]{new AssignedAttribute(new SimpleAttribute("count"), (Object)new AggregatedAttribute(this.keyId, AggregationFunctions.COUNT)), new SimpleAttribute(this.keyId)});
            goodCellsCount.setTables(new Table[]{this.dimensionTable});
            goodCellsCount.setGroups(new SimpleAttribute[]{new SimpleAttribute(this.keyId)});
            Select totalCorrectCount = (Select)DBSession.getImplementation(Select.class);
            totalCorrectCount.setAttributes(new Attribute[]{new AggregatedAttribute("*", AggregationFunctions.COUNT)});
            CastObject fieldCastToString = Utility.getCastToString((SimpleAttribute)new SimpleAttribute(this.fieldId, "curtab"));
            CastObject dimCastToString = Utility.getCastToString((SimpleAttribute)new SimpleAttribute(this.keyId, "dimtab"));
            totalCorrectCount.setFilter((Condition)new ANDCondition(new Condition[]{new OperatorCondition((Object)fieldCastToString, (Object)dimCastToString, "="), new OperatorCondition((Object)new SimpleAttribute("count", "dimtab"), (Object)1, "=")}));
            totalCorrectCount.setTables(new Table[]{new Table(this.resourceTable.getTableName(), "curtab"), new TableFromSubselect("dimtab", (Selection)goodCellsCount)});
            logger.trace((Object)totalCorrectCount.getExpression());
            ResultSet totalCorrectRes = totalCorrectCount.getResults(session, new boolean[0]);
            totalCorrectRes.next();
            this.resourceTable.initializeCount(session);
            long size = (long)this.resourceTable.getCount() - totalCorrectRes.getLong(1);
            logger.debug((Object)("the dimension check count is " + size));
            long l = size;
            return l;
        }
        finally {
            session.release();
        }
    }

    public SimpleTable getDimensionTable() {
        return this.dimensionTable;
    }

    @Override
    public void replaceValue(int rowId, Object value) throws Exception {
        throw new OperationNotSupportedException();
    }

    private String toJSon(ResultSet resultSet) throws SQLException {
        StringBuilder json = new StringBuilder();
        json.append("{\"response\":{\"value\":{\"items\":[");
        ResultSetMetaData metaData = resultSet.getMetaData();
        int numberOfColumns = metaData.getColumnCount();
        int count = 0;
        while (resultSet.next()) {
            if (count > 0) {
                json.append(",{");
            } else {
                json.append('{');
            }
            for (int column = 1; column <= numberOfColumns; ++column) {
                if (column > 1) {
                    json.append(',');
                }
                json.append(DimensionEditor.quote(metaData.getColumnName(column)));
                json.append(':');
                json.append(DimensionEditor.quote(resultSet.getString(column)));
            }
            json.append('}');
            ++count;
        }
        json.append("],\"total_count\":" + count);
        json.append(",\"version\":1}}}");
        return json.toString();
    }

    private static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPossibleValues(String word) throws Exception {
        String json;
        logger.trace((Object)"running the suggest word method");
        CategoryGuesser guesser = new CategoryGuesser((String)ServiceContext.getContext().getProperty("configDir", new boolean[]{true}));
        guesser.runGuesser(word, ServiceContext.getContext().getPossibleValueRetrieverConfiguration(), this.getDimensionTableNameHuman(), this.getKeyId());
        ArrayList results = guesser.getDetailedMatches();
        logger.trace((Object)("initliazed LexicalEngine and get back " + results.size() + " results"));
        ArrayList<String> listWords = new ArrayList<String>();
        for (SingleResult res : results) {
            listWords.add(res.getCategory());
        }
        Select retrieveDimensionRow = (Select)DBSession.getImplementation(Select.class);
        retrieveDimensionRow.setAttributes(new Attribute[]{SimpleAttribute.ALL});
        retrieveDimensionRow.setFilter((Condition)new IsInOperator(new SimpleAttribute(this.getKeyId()), (Listable)new StringArray(listWords)));
        retrieveDimensionRow.setTables(new Table[]{this.getDimensionTable()});
        DBSession session = null;
        try {
            session = DBSession.connect();
            logger.debug((Object)("possible value is " + retrieveDimensionRow.getExpression()));
            ResultSet toReturn = retrieveDimensionRow.getResults(session, new boolean[0]);
            json = this.toJSon(toReturn);
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
        return json;
    }

    @Override
    public org.gcube.contentmanagement.timeseriesservice.stubs.ColumnDefinition getTemporaryColumnDefinition(org.gcube.contentmanagement.timeseriesservice.stubs.ColumnDefinition oldColumnDefinition) throws Exception {
        org.gcube.contentmanagement.timeseriesservice.stubs.ColumnDefinition definition = new org.gcube.contentmanagement.timeseriesservice.stubs.ColumnDefinition();
        definition.setId(this.fieldId);
        definition.setDimensionRelatedFieldId(this.getFieldId() + "_id");
        definition.setColumnType(EntryType.Dimension);
        definition.setDimension(new Dimension(this.getCodelistId(), null, this.getDimensionTableNameHuman()));
        definition.setKey(new Key(this.getKeyId(), this.keyName, Util.mapSqlToJava(this.getKeyType().getType())));
        definition.setValueType(Util.mapSqlToJava(this.keyType.getType()));
        definition.setLabel(oldColumnDefinition.getLabel());
        return definition;
    }

    private ArrayList<Attribute> cloneAttributeList() throws Exception {
        ArrayList<Attribute> toReturn = new ArrayList<Attribute>();
        for (Attribute attrib : this.attributesList) {
            toReturn.add(attrib);
        }
        return toReturn;
    }
}

