/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.editing;

import java.sql.ResultSet;
import java.util.ArrayList;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.CastObject;
import org.gcube.common.dbinterface.Condition;
import org.gcube.common.dbinterface.attributes.AggregatedAttribute;
import org.gcube.common.dbinterface.attributes.AggregationFunctions;
import org.gcube.common.dbinterface.attributes.AssignedAttribute;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.conditions.IsInOperator;
import org.gcube.common.dbinterface.conditions.ListSelect;
import org.gcube.common.dbinterface.conditions.Listable;
import org.gcube.common.dbinterface.conditions.NotInOperator;
import org.gcube.common.dbinterface.conditions.ORCondition;
import org.gcube.common.dbinterface.conditions.OperatorCondition;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.CreateTableFromSelect;
import org.gcube.common.dbinterface.queries.CreateTableLike;
import org.gcube.common.dbinterface.queries.Delete;
import org.gcube.common.dbinterface.queries.InsertFromSelect;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.queries.alters.ModifyColumnType;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.common.dbinterface.utils.Utility;
import org.gcube.contentmanagement.codelistmanager.exception.ValueNotFoundException;
import org.gcube.contentmanagement.timeseriesservice.impl.editing.ColumnEditor;
import org.gcube.contentmanagement.timeseriesservice.impl.editing.Edit;

public class CodeListRelationEdit
extends ColumnEditor {
    private static transient GCUBELog logger = new GCUBELog(CodeListRelationEdit.class);
    private static final long serialVersionUID = 4411160417374524492L;
    private String codeFieldId;
    private SimpleTable relationTable;

    public CodeListRelationEdit(String resourceId, String fieldId, SimpleTable resourceTable, int[] fieldLength, boolean withoutError, String codeFieldId, SimpleTable relationTable, String ... rowIdLabel) throws Exception {
        super(resourceId, fieldId, resourceTable, fieldLength, withoutError, (Type)relationTable.getFieldsMapping().get(codeFieldId), rowIdLabel);
        logger.debug((Object)("the type in edit mode is " + this.getDataType().getType().getValue()));
        this.codeFieldId = codeFieldId;
        this.editorType = Edit.TYPE.CodeListRelation;
        this.relationTable = relationTable;
    }

    public CodeListRelationEdit(String resourceId, String fieldId, SimpleTable resourceTable, int[] fieldLength, boolean withoutError, String codeFieldId, String ... rowIdLabel) throws Exception {
        super(resourceId, fieldId, resourceTable, fieldLength, withoutError, (Type)resourceTable.getFieldsMapping().get(codeFieldId), rowIdLabel);
        logger.debug((Object)("the type in edit mode is " + this.getDataType().getType().getValue()));
        this.codeFieldId = codeFieldId;
        this.editorType = Edit.TYPE.CodeListRelation;
        this.relationTable = resourceTable;
    }

    @Override
    public void internalInitialize(DBSession session) throws Exception {
        this.resourceTable.initializeFieldMapping();
        CreateTableFromSelect createFromSelect = (CreateTableFromSelect)DBSession.getImplementation(CreateTableFromSelect.class);
        createFromSelect.setTableName(this.getCorrectsTableName());
        Select select = (Select)DBSession.getImplementation(Select.class);
        select.setTables(new Table[]{this.resourceTable});
        CastObject cast = Utility.getCast((SimpleAttribute)new SimpleAttribute(this.fieldId), (Type)this.getDataType());
        cast.setUseCastFunction(true);
        Select subSelect = (Select)DBSession.getImplementation(Select.class);
        subSelect.setTables(new Table[]{this.relationTable});
        subSelect.setAttributes(new Attribute[]{new SimpleAttribute(this.codeFieldId)});
        select.setFilter((Condition)new IsInOperator(new SimpleAttribute(cast.getCast()), (Listable)new ListSelect(subSelect)));
        logger.debug((Object)("query for correct : " + select.getExpression()));
        createFromSelect.setSelect(select);
        createFromSelect.setWithData();
        createFromSelect.execute(session);
        ModifyColumnType modifyColumn = (ModifyColumnType)DBSession.getImplementation(ModifyColumnType.class);
        modifyColumn.setNewType(this.getDataType());
        modifyColumn.setTable(new Table(this.getCorrectsTableName()));
        modifyColumn.setColumn(new SimpleAttribute(this.fieldId));
        modifyColumn.setUseCast(true);
        modifyColumn.execute(session);
        logger.debug((Object)("the code data type is " + this.getDataType().getType().toString()));
        CreateTableLike createTableLike = (CreateTableLike)DBSession.getImplementation(CreateTableLike.class);
        createTableLike.setTableName(this.getWrongsTableName());
        createTableLike.setTableLike(this.resourceTable);
        SimpleTable wrongTable = createTableLike.execute(session);
        InsertFromSelect insertFromSelectQuery = (InsertFromSelect)DBSession.getImplementation(InsertFromSelect.class);
        insertFromSelectQuery.setTable(wrongTable);
        select = (Select)DBSession.getImplementation(Select.class);
        select.setTables(new Table[]{this.resourceTable});
        cast = Utility.getCast((SimpleAttribute)new SimpleAttribute(this.fieldId), (Type)this.getDataType());
        cast.setUseCastFunction(true);
        select.setFilter((Condition)new ORCondition(new Condition[]{new NotInOperator(new SimpleAttribute(cast.getCast()), (Listable)new ListSelect(subSelect)), new OperatorCondition((Object)cast, null, " IS ")}));
        logger.debug((Object)("query for wrong : " + select.getExpression()));
        insertFromSelectQuery.setSubQuery(select);
        insertFromSelectQuery.execute(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long check() throws Exception {
        DBSession session = null;
        try {
            session = DBSession.connect();
            Select select = (Select)DBSession.getImplementation(Select.class);
            select.setAttributes(new Attribute[]{new AggregatedAttribute("*", AggregationFunctions.COUNT)});
            Select subSelect = (Select)DBSession.getImplementation(Select.class);
            subSelect.setAttributes(new Attribute[]{new SimpleAttribute(this.codeFieldId)});
            subSelect.setTables(new Table[]{this.relationTable});
            CastObject cast = Utility.getCast((SimpleAttribute)new SimpleAttribute(this.fieldId), (Type)this.getDataType());
            cast.setUseCastFunction(true);
            select.setTables(new Table[]{this.resourceTable});
            select.setFilter((Condition)new NotInOperator(new SimpleAttribute(cast.getCast()), (Listable)new ListSelect(subSelect)));
            ResultSet rs = select.getResults(new boolean[]{false});
            rs.next();
            long l = rs.getLong(1);
            return l;
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceValue(int rowId, Object value) throws Exception {
        Select select = (Select)DBSession.getImplementation(Select.class);
        select.setTables(new Table[]{this.relationTable});
        select.setAttributes(new Attribute[]{new AggregatedAttribute("*", AggregationFunctions.COUNT)});
        CastObject castObject = Utility.getCast((String)value.toString(), (Type)((Type)this.relationTable.getFieldsMapping().get(this.codeFieldId)));
        castObject.setUseCastFunction(true);
        select.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(this.codeFieldId), (Object)castObject, "="));
        DBSession session = null;
        try {
            session = DBSession.connect();
            ResultSet result = select.getResults(session, new boolean[0]);
            result.next();
            if (result.getInt(1) == 0) {
                throw new ValueNotFoundException();
            }
            session.disableAutoCommit();
            select = (Select)DBSession.getImplementation(Select.class);
            ArrayList<Object> attributes = new ArrayList<Object>();
            for (String key : this.getCorrectsTable().getFieldsMapping().keySet()) {
                if (key.equals(this.fieldId)) {
                    attributes.add(new AssignedAttribute(new SimpleAttribute(this.fieldId), (Object)castObject));
                    continue;
                }
                attributes.add(new SimpleAttribute(key));
            }
            select.setAttributes(attributes.toArray(new Attribute[attributes.size()]));
            select.setTables(new Table[]{new Table(this.getWrongsTableName())});
            select.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(this.ROW_ID_LABEL), (Object)rowId, "="));
            InsertFromSelect insertFromSelect = (InsertFromSelect)DBSession.getImplementation(InsertFromSelect.class);
            insertFromSelect.setTable(new SimpleTable(this.getCorrectsTableName()));
            insertFromSelect.setSubQuery(select);
            insertFromSelect.execute(session);
            Delete deleteEntry = (Delete)DBSession.getImplementation(Delete.class);
            deleteEntry.setTable(new Table(this.getWrongsTableName()));
            deleteEntry.setFilter((Condition)new OperatorCondition((Object)new SimpleAttribute(this.ROW_ID_LABEL), (Object)rowId, "="));
            deleteEntry.execute(session);
            session.commit();
        }
        finally {
            if (session != null) {
                session.release();
            }
        }
    }
}

