/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.curation;

import java.util.ArrayList;
import java.util.Iterator;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Limit;
import org.gcube.common.dbinterface.Order;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.contentmanagement.timeseriesservice.impl.context.CurationContext;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.rules.Rule;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.state.CurationResource;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.state.CurationResourceHome;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.ApplyRulesRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CheckDimensionRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CheckRulesRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CheckTypeChangeRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.ColumnDefinitionArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.EditColumnRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.EditDimensionRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ErrorPair;
import org.gcube.contentmanagement.timeseriesservice.stubs.ErrorPairArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetDataAsJsonRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GuessDimensionArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.ModifyEntryByIdRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ModifyEntryByValueRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.OrderType;
import org.gcube.contentmanagement.timeseriesservice.stubs.ReplaceEntryIdRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ReplaceEntryValueRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ReplaceEntryValueWithIdRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.RuleItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.RulesArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.SetColumnAsRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.SetCurationProperties;
import org.gcube.contentmanagement.timeseriesservice.stubs.SetLabelRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.State;
import org.globus.wsrf.ResourceException;

public class CurationManager {
    private static GCUBELog logger = new GCUBELog(CurationManager.class);

    private CurationResource getResource() throws ResourceException {
        CurationResourceHome home = (CurationResourceHome)CurationContext.getPortTypeContext().getWSHome();
        return (CurationResource)home.find();
    }

    public long errorCount(VOID request) throws GCUBEFault {
        try {
            return this.getResource().getCount(true);
        }
        catch (Exception e) {
            logger.error((Object)"error in count", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    public void setProperties(SetCurationProperties properties) throws GCUBEFault {
        try {
            this.getResource().setProperties(properties.getTitle(), properties.getDescription(), properties.getPublisher(), properties.getRights());
        }
        catch (Exception e) {
            logger.error((Object)"error setting properties", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    public long count(VOID request) throws GCUBEFault {
        try {
            return this.getResource().getCount(false);
        }
        catch (Exception e) {
            logger.error((Object)"error in count", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    public VOID editDimension(EditDimensionRequest request) throws GCUBEFault {
        logger.info((Object)"edit dimension");
        try {
            logger.trace((Object)("keyId=" + request.getKeyId()));
            this.getResource().editDimension(request.getFieldId(), request.getDimensionId(), request.getKeyId());
            this.getResource().store();
        }
        catch (Exception e) {
            logger.error((Object)"error entering in edit mode", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
        return new VOID();
    }

    public VOID editColumn(EditColumnRequest request) throws GCUBEFault {
        logger.info((Object)"edit column");
        try {
            this.getResource().editColumn(request.getFieldId(), new Type(Util.mapJavaToSql(request.getType()), new int[0]));
            this.getResource().store();
        }
        catch (Exception e) {
            logger.error((Object)"error entering in edit mode", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
        return new VOID();
    }

    public VOID editRules(String fieldId) throws GCUBEFault {
        logger.info((Object)"edit rules");
        try {
            this.getResource().editRules(fieldId);
            this.getResource().store();
        }
        catch (Exception e) {
            logger.error((Object)"error entering in edit mode", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
        return new VOID();
    }

    public VOID closeEditing(VOID request) throws GCUBEFault {
        logger.info((Object)"closeEditing");
        try {
            this.getResource().closeEditing();
            this.getResource().store();
        }
        catch (Exception e) {
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
        return new VOID();
    }

    public String getDataAsJson(GetDataAsJsonRequest request) throws GCUBEFault {
        long start = System.currentTimeMillis();
        try {
            Select selectQuery = (Select)DBSession.getImplementation(Select.class);
            if (request.getQuery().getLimits() != null) {
                selectQuery.setLimit(new Limit(request.getQuery().getLimits().getLowerLimit(), request.getQuery().getLimits().getUpperLimit()));
            }
            if (request.getQuery().getOrders() != null) {
                Order[] orders = new Order[request.getQuery().getOrders().length];
                for (int i = 0; i < request.getQuery().getOrders().length; ++i) {
                    orders[i] = new Order(request.getQuery().getOrders()[i].getOrder() == OrderType.Ascending ? Order.OrderType.ASC : Order.OrderType.DESC, (Attribute)new SimpleAttribute(request.getQuery().getOrders()[i].getField()));
                }
                selectQuery.setOrders(orders);
            }
            logger.trace((Object)("requested query is " + selectQuery.getExpression()));
            logger.trace((Object)("getDataAsJson took " + (start - System.currentTimeMillis())));
            return this.getResource().getDataAsJson(selectQuery, request.isOnlyErrors());
        }
        catch (Exception e) {
            logger.error((Object)"error getting data", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    public VOID modifyEntryByValue(ModifyEntryByValueRequest request) throws GCUBEFault {
        logger.info((Object)("modifying value " + request.getFieldId() + " " + request.getNewValue()));
        try {
            this.getResource().modifyEntryValue(request.getFieldId(), request.getNewValue(), request.getRowId());
        }
        catch (Exception e) {
            logger.error((Object)"error modifying value", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error modifying value"});
        }
        return new VOID();
    }

    public VOID modifyEntryById(ModifyEntryByIdRequest request) throws GCUBEFault {
        logger.info((Object)("modifying id: " + request.getFieldId() + " " + request.getNewId()));
        try {
            this.getResource().modifyEntryId(request.getFieldId(), request.getNewId(), request.getRowId());
        }
        catch (Exception e) {
            logger.error((Object)"error modifying value", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error modifying value"});
        }
        return new VOID();
    }

    public VOID replaceEntryValue(ReplaceEntryValueRequest request) throws GCUBEFault {
        logger.info((Object)("modifying value " + request.getFieldId() + " " + request.getNewValue()));
        try {
            this.getResource().replaceByValue(request.getOldValue(), request.getNewValue(), request.getFieldId());
        }
        catch (Exception e) {
            logger.error((Object)"error replacing value", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error replacing value"});
        }
        return new VOID();
    }

    public VOID replaceEntryId(ReplaceEntryIdRequest request) throws GCUBEFault {
        logger.info((Object)("modifying by id: " + request.getFieldId() + " " + request.getNewId()));
        try {
            this.getResource().replaceById(request.getOldId(), request.getNewId(), request.getFieldId());
        }
        catch (Exception e) {
            logger.error((Object)"error replacing value", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error replacing value"});
        }
        return new VOID();
    }

    public ColumnDefinitionArray getDimensions(VOID request) throws GCUBEFault {
        long start = System.currentTimeMillis();
        try {
            ColumnDefinitionArray toReturn = new ColumnDefinitionArray(this.getResource().getColumnDefinition());
            logger.trace((Object)("getColumnDefinition took " + (start - System.currentTimeMillis())));
            return toReturn;
        }
        catch (Exception e) {
            logger.error((Object)"error getting Dimensions", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    public VOID saveColumnDefinition(VOID request) throws GCUBEFault {
        try {
            this.getResource().saveColumnDefinition();
            this.getResource().store();
        }
        catch (GCUBEFault e) {
            logger.error((Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"error saving column", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
        return new VOID();
    }

    public VOID setLabelName(SetLabelRequest request) throws GCUBEFault {
        try {
            this.getResource().setLabel(request.getFieldId(), request.getNewLabel());
        }
        catch (Exception e) {
            logger.error((Object)"error modifying value", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error setting attribute lable for " + request.getFieldId()});
        }
        return new VOID();
    }

    public VOID removeAllErrors(VOID request) throws GCUBEFault {
        try {
            this.getResource().removeAllErrors();
        }
        catch (Exception e) {
            logger.error((Object)"error modifying value", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error removing all errors"});
        }
        return new VOID();
    }

    public VOID removeSingleError(long rowId) throws GCUBEFault {
        try {
            this.getResource().removeError(rowId);
        }
        catch (Exception e) {
            logger.error((Object)"error modifying value", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error removing all errors"});
        }
        return new VOID();
    }

    public VOID closeEdit(VOID request) throws GCUBEFault {
        try {
            this.getResource().closeEditing();
        }
        catch (Exception e) {
            logger.error((Object)"error modifying value", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error closing edit mode"});
        }
        return new VOID();
    }

    public boolean isInEditMode(VOID request) throws GCUBEFault {
        try {
            return this.getResource().isUnderEdit();
        }
        catch (Exception e) {
            logger.error((Object)"error modifying value", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error verifying edit mode"});
        }
    }

    public State isUnderInitialization(VOID request) throws GCUBEFault {
        try {
            return this.getResource().getUnderCreationState();
        }
        catch (Exception e) {
            logger.error((Object)"error verifying initialization", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error verifying initialization"});
        }
    }

    public VOID setColumnAs(SetColumnAsRequest request) throws GCUBEFault {
        try {
            this.getResource().setColumn(request.getColumnType(), request.getFieldId());
            this.getResource().store();
        }
        catch (Exception e) {
            logger.error((Object)"error setting attribute type", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error setting attribute type"});
        }
        return new VOID();
    }

    public GuessDimensionArray guessDimension(String fieldId) throws GCUBEFault {
        try {
            CurationResource resource = this.getResource();
            return resource.guess(fieldId);
        }
        catch (Exception e) {
            logger.error((Object)"error in guess Dimension", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error in guess Dimension"});
        }
    }

    public State initializeEditingState(VOID req) throws GCUBEFault {
        try {
            return this.getResource().getInitializeEditingState();
        }
        catch (Exception e) {
            logger.error((Object)"error in guess Dimension", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error in guess Dimension"});
        }
    }

    public ColumnDefinition columnInEditMode(VOID req) throws GCUBEFault {
        try {
            return this.getResource().columnInEditMode();
        }
        catch (Exception e) {
            logger.error((Object)"error in columnInEditMode", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error in columnInEditMode"});
        }
    }

    public VOID removeColumn(String fieldId) throws GCUBEFault {
        try {
            this.getResource().removeColumn(fieldId);
            this.getResource().store();
        }
        catch (Exception e) {
            logger.error((Object)"error in remove column", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error in remove column"});
        }
        return new VOID();
    }

    public VOID replaceEntryValueWithId(ReplaceEntryValueWithIdRequest request) throws GCUBEFault {
        logger.info((Object)("modifying value with id: " + request.getFieldId() + " " + request.getNewId()));
        try {
            if (this.getResource().getFieldEditor() == null) {
                throw new GCUBEFault(new String[]{"the Service is not in edit mode"});
            }
            this.getResource().getFieldEditor().replaceEntryValueWithId(request.getOldValue(), request.getNewId(), request.getFieldId());
        }
        catch (Exception e) {
            logger.error((Object)"error replacing value", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error replacing value"});
        }
        return new VOID();
    }

    public String getPossibleValues(String word) throws GCUBEFault {
        try {
            return this.getResource().getPossibleValues(word);
        }
        catch (Exception e) {
            logger.error((Object)("error guessing word " + word), (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error guessing word " + word});
        }
    }

    public ErrorPairArray getDistinctErrors(VOID req) throws GCUBEFault {
        try {
            if (this.getResource().getFieldEditor() == null) {
                throw new GCUBEFault(new String[]{"the Service is not in edit mode"});
            }
            return new ErrorPairArray(this.getResource().getFieldEditor().getDistinctErrors().toArray(new ErrorPair[0]));
        }
        catch (Exception e) {
            logger.error((Object)"error getting distinct errors", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error getting distinct errors"});
        }
    }

    public VOID applyRules(ApplyRulesRequest request) throws GCUBEFault {
        try {
            if (request.getRules() == null || request.getRules().getItems() == null) {
                return new VOID();
            }
            this.getResource().applyRules(request.getRules().getItems(), request.getFieldId());
        }
        catch (Exception e) {
            logger.error((Object)"error applying rules", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error applying rules"});
        }
        return new VOID();
    }

    public RulesArray getApplyedRules(String fieldID) throws GCUBEFault {
        try {
            ArrayList<RuleItem> listRule = new ArrayList<RuleItem>();
            Iterator<Rule> ruleIt = this.getResource().applyedRules(fieldID);
            while (ruleIt.hasNext()) {
                Rule rule = ruleIt.next();
                listRule.add(new RuleItem(rule.getDescription(), rule.getFilter(), rule.getHumanReadable(), rule.getId(), rule.getName(), Util.mapSqlToJava(rule.getType())));
            }
            return new RulesArray(listRule.toArray(new RuleItem[listRule.size()]));
        }
        catch (Exception e) {
            logger.error((Object)"error getting rules", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error getting rules"});
        }
    }

    public VOID removeApplyedRules(String fieldId) throws GCUBEFault {
        try {
            this.getResource().removeAllRules(fieldId);
            return new VOID();
        }
        catch (Exception e) {
            logger.error((Object)"error getting rules", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error getting rules"});
        }
    }

    public RulesArray getApplyableRules(String fieldID) throws GCUBEFault {
        try {
            ArrayList<RuleItem> listRule = new ArrayList<RuleItem>();
            Iterator<Rule> ruleIt = this.getResource().applyableRules(fieldID);
            while (ruleIt.hasNext()) {
                Rule rule = ruleIt.next();
                listRule.add(new RuleItem(rule.getDescription(), rule.getFilter(), rule.getHumanReadable(), rule.getId(), rule.getName(), Util.mapSqlToJava(rule.getType())));
            }
            return new RulesArray(listRule.toArray(new RuleItem[listRule.size()]));
        }
        catch (Exception e) {
            logger.error((Object)"error getting rules", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error getting rules"});
        }
    }

    public long checkDimension(CheckDimensionRequest req) throws GCUBEFault {
        try {
            return this.getResource().checkDimension(req.getCodeListId(), req.getFieldId(), req.getKeyId());
        }
        catch (Exception e) {
            logger.error((Object)"error checking dimension", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    public long checkRules(CheckRulesRequest req) throws GCUBEFault {
        try {
            return this.getResource().checkRules(req.getFieldId(), req.getFilters());
        }
        catch (Exception e) {
            logger.error((Object)"error checking rules", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    public long checkTypeChange(CheckTypeChangeRequest req) throws GCUBEFault {
        try {
            return this.getResource().checkTypeChange(req.getFieldId(), new Type(Util.mapJavaToSql(req.getType()), new int[0]));
        }
        catch (Exception e) {
            logger.error((Object)"error checking dimension", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }
}

