/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.curation;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.contentmanagement.codelistmanager.entities.CodeList;
import org.gcube.contentmanagement.timeseriesservice.impl.context.CurationContext;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.Curation;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.rules.Rule;
import org.gcube.contentmanagement.timeseriesservice.impl.curation.state.CurationResource;
import org.gcube.contentmanagement.timeseriesservice.impl.timeseries.operations.util.FilterExplorer;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.CurationItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.CurationItemsArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetFieldValuesRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.GetItemRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.RuleItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.RulesArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.SaveRuleRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.StartRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.StartResponse;
import org.gcube.contentmanagement.timeseriesservice.stubs.StringArray;
import org.globus.wsrf.ResourceKey;

public class CurationFactory {
    private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();
    private GCUBELog logger = new GCUBELog(CurationFactory.class);

    public StartResponse startCuration(StartRequest request) throws GCUBEFault {
        StartResponse response;
        String id = uuidGen.nextUUID();
        CurationResource resource = null;
        this.logger.debug((Object)("creating curation resource with id " + id));
        try {
            resource = (CurationResource)CurationContext.getPortTypeContext().getWSHome().create(CurationContext.getPortTypeContext().makeKey(id), new Object[]{id, request.getTitle(), request.getDescription(), request.getCreator(), request.getSource()});
            response = new StartResponse(resource.getEPR(), resource.getId());
            this.logger.trace((Object)("new resource epr: " + resource.getEPR()));
            resource.store();
        }
        catch (Exception re) {
            if (resource != null) {
                resource.remove();
            }
            this.logger.error((Object)"error creating curation resource", (Throwable)re);
            throw new GCUBEFault((Throwable)re, new String[]{"error creating curation resource"});
        }
        return response;
    }

    public EndpointReferenceType open(String curationId) throws GCUBEFault {
        try {
            this.logger.debug((Object)("opening curation resource with id " + curationId));
            CurationResource resource = (CurationResource)CurationContext.getPortTypeContext().getWSHome().find((ResourceKey)CurationContext.getPortTypeContext().makeKey(curationId));
            return resource.getEPR();
        }
        catch (Exception re) {
            this.logger.error((Object)"error opening curation resource", (Throwable)re);
            throw new GCUBEFault((Throwable)re, new String[]{"error opening curation resource"});
        }
    }

    public StringArray getFieldValues(GetFieldValuesRequest request) throws GCUBEFault {
        StringArray toReturn = new StringArray();
        DBSession session = null;
        try {
            session = DBSession.connect();
            CodeList codelist = CodeList.get((String)request.getDimensionId());
            Select fieldValuesQuery = (Select)DBSession.getImplementation(Select.class);
            fieldValuesQuery.setAttributes(new Attribute[]{new SimpleAttribute(request.getFieldName())});
            fieldValuesQuery.setTables(new Table[]{new Table(codelist.getTable().getTableName())});
            ResultSet fieldValuesQueryRes = fieldValuesQuery.getResults(session, new boolean[0]);
            ArrayList<String> valuesList = new ArrayList<String>();
            while (fieldValuesQueryRes.next()) {
                valuesList.add(fieldValuesQueryRes.getString(1));
            }
            toReturn.setStrings(valuesList.toArray(new String[0]));
        }
        catch (Exception e) {
            this.logger.error((Object)"failed getting values", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
        finally {
            session.release();
        }
        return toReturn;
    }

    public CurationItemsArray getCuratingItems(String user) throws GCUBEFault {
        this.logger.debug((Object)"getCuratingItems");
        CurationItemsArray response = new CurationItemsArray();
        try {
            Iterator it = ObjectPersistency.get(Curation.class).getObjectByField("creator", (Object)user);
            ArrayList<CurationItem> listcurations = new ArrayList<CurationItem>();
            while (it.hasNext()) {
                Curation cur = (Curation)it.next();
                if (!ServiceContext.getContext().getScope().isEnclosedIn(GCUBEScope.getScope((String)cur.getScope()))) continue;
                listcurations.add(this.createCurationItem(cur));
            }
            response.setItems(listcurations.toArray(new CurationItem[listcurations.size()]));
        }
        catch (Exception e) {
            this.logger.error((Object)"error retrieving Time Series under curation", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error retrieving Time Series under curation"});
        }
        return response;
    }

    public CurationItem getItem(GetItemRequest req) throws GCUBEFault {
        this.logger.debug((Object)"getCuratingItems");
        CurationItem item = null;
        try {
            item = this.createCurationItem((Curation)ObjectPersistency.get(Curation.class).getByKey((Object)req.getId()));
        }
        catch (Exception e) {
            this.logger.error((Object)"error retrieving Time Series under curation", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"error retrieving Time Series under curation"});
        }
        return item;
    }

    public VOID removeCuration(String id) throws GCUBEFault {
        try {
            ObjectPersistency.get(Curation.class).deleteByKey((Object)id);
            CurationContext.getPortTypeContext().getWSHome().remove((ResourceKey)CurationContext.getPortTypeContext().makeKey(id));
        }
        catch (Exception e) {
            this.logger.error((Object)("error removing curation with id " + id));
            throw new GCUBEUnrecoverableFault(e, new String[0]);
        }
        return new VOID();
    }

    public String saveRule(SaveRuleRequest request) throws GCUBEFault {
        try {
            Rule rule = new Rule(request.getName(), request.getDescription(), FilterExplorer.generateRulesDescription(request.getFilter()).toString(), request.getFilter(), Util.mapJavaToSql(request.getType()));
            if (!rule.store()) {
                throw new Exception("error storing the rule");
            }
            return rule.getId();
        }
        catch (Exception e) {
            this.logger.error((Object)"error saving rule", (Throwable)e);
            throw new GCUBEFault(new String[]{"error saving the rule"});
        }
    }

    public boolean removeRule(String id) throws GCUBEFault {
        try {
            Rule.destroy(id);
            return true;
        }
        catch (Exception e) {
            this.logger.error((Object)"error getting rules", (Throwable)e);
            return false;
        }
    }

    public RulesArray getRules(VOID request) throws GCUBEFault {
        try {
            ArrayList<RuleItem> listRules = new ArrayList<RuleItem>();
            Iterator<Rule> rulesIterator = Rule.getAll();
            while (rulesIterator.hasNext()) {
                Rule rule = rulesIterator.next();
                listRules.add(new RuleItem(rule.getDescription(), rule.getFilter(), rule.getHumanReadable(), rule.getId(), rule.getName(), Util.mapSqlToJava(rule.getType())));
            }
            return new RulesArray(listRules.toArray(new RuleItem[listRules.size()]));
        }
        catch (Exception e) {
            this.logger.error((Object)"error getting rules", (Throwable)e);
            throw new GCUBEFault(new String[]{"error getting rules"});
        }
    }

    private CurationItem createCurationItem(Curation item) throws Exception {
        CurationItem tempItem = new CurationItem();
        tempItem.setCreator(item.getCreator());
        tempItem.setDate(Util.dateFormatter.format(item.getDate()));
        tempItem.setDescription(item.getDescription());
        tempItem.setId(item.getId());
        tempItem.setLenght(item.getLength());
        tempItem.setPublisher(item.getPublisher());
        tempItem.setRights(item.getRights());
        tempItem.setSourceId(item.getSourceId());
        tempItem.setSourceName(item.getSourceName());
        tempItem.setTitle(item.getTitle());
        tempItem.setType(item.getType());
        return tempItem;
    }
}

