/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.codelist.wrappers;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.contentmanagement.codelistmanager.entities.CodeList;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistColumnType;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistColumnsDefinitionArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.State;

@TableRootDefinition
public class CLManagerWrapper {
    private static GCUBELog logger = new GCUBELog(CLManagerWrapper.class);
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private String[] superUsers;
    @FieldDefinition(precision={60}, specifications={Specification.NOT_NULL, Specification.PRIMARY_KEY})
    private String codelistId;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private GCUBEScope scope;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private State status = State.Initializing;
    @FieldDefinition(precision={60})
    private String parentId;
    @FieldDefinition(precision={60}, specifications={Specification.NOT_NULL})
    private String creator;

    private CLManagerWrapper() {
    }

    public CLManagerWrapper(String codelistId, String creator, GCUBEScope scope, String ... superUsers) {
        this.superUsers = superUsers;
        this.codelistId = codelistId;
        this.scope = scope;
        this.creator = creator;
    }

    public String[] getSuperUsers() {
        return this.superUsers;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setSuperUsers(String[] superUsers) {
        this.superUsers = superUsers;
    }

    public String getCodelistId() {
        return this.codelistId;
    }

    public void setCodelistId(String codelistId) {
        this.codelistId = codelistId;
    }

    public GCUBEScope getScope() {
        return this.scope;
    }

    public void setScope(GCUBEScope scope) {
        this.scope = scope;
    }

    public State getStatus() {
        return this.status;
    }

    public void setStatus(State status) {
        this.status = status;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getDataAsJson(Select selectQuery) throws Exception {
        selectQuery.setTables(new Table[]{new Table(this.getCodelist().getRelatedTableName())});
        return selectQuery.getResultAsJSon(true, new boolean[0]);
    }

    public CodeList getCodelist() throws Exception {
        return (CodeList)ObjectPersistency.get(CodeList.class).getByKey((Object)this.getCodelistId());
    }

    public CodelistColumnsDefinitionArray getColumnsDefinition() throws Exception {
        ArrayList<CodelistColumnDefinition> columnDefintionArray = new ArrayList<CodelistColumnDefinition>();
        Object[] returnList = this.getCodelist().getLabelFieldMapping().values().toArray(new TableField[0]);
        Arrays.sort(returnList);
        for (Object field : returnList) {
            columnDefintionArray.add(new CodelistColumnDefinition(CodelistColumnType.fromString((String)field.getColumnReference().getType().toString()), Util.mapSqlToJava(field.getDataType()), field.getId(), field.getFieldName(), field.getColumnReference().getCodelistReferenceId()));
        }
        return new CodelistColumnsDefinitionArray(columnDefintionArray.toArray(new CodelistColumnDefinition[columnDefintionArray.size()]));
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public synchronized boolean remove() {
        try {
            ObjectPersistency.get(CLManagerWrapper.class).deleteByKey((Object)this.getCodelistId());
            this.getCodelist().remove();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Iterator<CLManagerWrapper> getAll() throws Exception {
        return ObjectPersistency.get(CLManagerWrapper.class).getAll();
    }

    public synchronized boolean store() {
        try {
            ObjectPersistency op = ObjectPersistency.get(CLManagerWrapper.class);
            if (!op.existsKey((Object)this.getCodelistId())) {
                op.insert((Object)this);
            } else {
                op.update((Object)this);
            }
        }
        catch (Exception e) {
            logger.error((Object)"error storing codelist wrapper on DB", (Throwable)e);
            return false;
        }
        return true;
    }

    public static CLManagerWrapper get(String key) throws Exception {
        return (CLManagerWrapper)ObjectPersistency.get(CLManagerWrapper.class).getByKey((Object)key);
    }

    public static Iterator<CLManagerWrapper> getByScope(GCUBEScope scope) throws Exception {
        return ObjectPersistency.get(CLManagerWrapper.class).getObjectByField("scope", (Object)new XStream().toXML((Object)scope));
    }
}

