/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.codelist.wrappers;

import java.util.Iterator;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.ObjectStateControl;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;
import org.gcube.contentmanagement.codelistmanager.managers.CodeListImport;
import org.gcube.contentmanagement.timeseriesservice.stubs.State;

@TableRootDefinition
public class CLImportItemWrapper
extends ObjectStateControl {
    @FieldDefinition(precision={60}, specifications={Specification.NOT_NULL})
    private String owner;
    @FieldDefinition(precision={60}, specifications={Specification.NOT_NULL, Specification.PRIMARY_KEY})
    private String codelistId;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private GCUBEScope scope;

    public String getOwner() {
        return this.owner;
    }

    public String getCodelistId() {
        return this.codelistId;
    }

    public State getStatus() throws Exception {
        switch (this.getCodelist().getStatus()) {
            case Failed: {
                return State.Error;
            }
            case Initialized: 
            case InProgress: {
                return State.Open;
            }
            case Complete: {
                return State.Close;
            }
        }
        return null;
    }

    public CodeListImport getCodelist() throws Exception {
        return CodeListImport.get((String)this.codelistId);
    }

    public GCUBEScope getScope() {
        return this.scope;
    }

    private CLImportItemWrapper() {
    }

    public CLImportItemWrapper(String owner, String codelistId, GCUBEScope scope) {
        this.owner = owner;
        this.codelistId = codelistId;
        this.scope = scope;
    }

    public boolean remove() {
        try {
            ObjectPersistency.get(CLImportItemWrapper.class).deleteByKey((Object)this.getCodelistId());
            this.getCodelist().remove();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean store() {
        try {
            ObjectPersistency op = ObjectPersistency.get(CLImportItemWrapper.class);
            if (!op.existsKey((Object)this.getCodelistId())) {
                op.insert((Object)this);
            } else {
                op.update((Object)this);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static CLImportItemWrapper get(String id) throws Exception {
        return (CLImportItemWrapper)((Object)ObjectPersistency.get(CLImportItemWrapper.class).getByKey((Object)id));
    }

    public static Iterator<CLImportItemWrapper> getAll() throws Exception {
        return ObjectPersistency.get(CLImportItemWrapper.class).getAll();
    }

    public static Iterator<CLImportItemWrapper> getByUser(String user) throws Exception {
        return ObjectPersistency.get(CLImportItemWrapper.class).getObjectByField("owner", (Object)user);
    }
}

