/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.codelist.wrappers;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Limit;
import org.gcube.common.dbinterface.Order;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.contentmanagement.codelistmanager.entities.CodeList;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.codelistmanager.managers.CodeListCuration;
import org.gcube.contentmanagement.timeseriesservice.impl.editing.CodeListRelationEdit;
import org.gcube.contentmanagement.timeseriesservice.impl.editing.ColumnEditor;
import org.gcube.contentmanagement.timeseriesservice.impl.exceptions.EditNotFinishedException;
import org.gcube.contentmanagement.timeseriesservice.impl.exceptions.NotInEditModeException;
import org.gcube.contentmanagement.timeseriesservice.stubs.State;

@TableRootDefinition
public class CLCurationWrapper {
    private static GCUBELog logger = new GCUBELog(CLCurationWrapper.class);
    @FieldDefinition
    private ColumnEditor edit;
    @FieldDefinition(precision={60}, specifications={Specification.NOT_NULL})
    private String owner;
    @FieldDefinition(precision={60}, specifications={Specification.NOT_NULL, Specification.PRIMARY_KEY})
    private String codelistId;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private GCUBEScope scope;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private State status = State.Initializing;
    @FieldDefinition(precision={60})
    private String parentId;

    public String getParentId() {
        return this.parentId;
    }

    public State getStatus() {
        return this.status;
    }

    public void setStatus(State status) {
        this.status = status;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getCodelistId() {
        return this.codelistId;
    }

    public GCUBEScope getScope() {
        return this.scope;
    }

    public void setScope(GCUBEScope scope) {
        this.scope = scope;
    }

    private CLCurationWrapper() {
    }

    public CLCurationWrapper(String owner, String codelistId, GCUBEScope scope) {
        this.owner = owner;
        this.codelistId = codelistId;
        this.scope = scope;
        this.edit = null;
    }

    public CodeListCuration getCodelist() throws Exception {
        return CodeListCuration.get((String)this.codelistId);
    }

    public synchronized void edit(String fieldId) throws Exception {
        this.edit(fieldId, null);
    }

    public synchronized void edit(String fieldId, Type type) throws Exception {
        if (this.edit != null) {
            this.edit.dismiss();
        }
        CodeListCuration codelist = this.getCodelist();
        SimpleTable table = codelist.getTable();
        table.initializeFieldMapping();
        int[] fieldLength = ((TableField)codelist.getLabelFieldMapping().get(fieldId)).getLength();
        logger.trace((Object)("fieldLength for " + fieldId + " is " + Arrays.toString(fieldLength)));
        if (((TableField)codelist.getLabelFieldMapping().get(fieldId)).getColumnReference().getType() == TableField.ColumnType.ParentCode || ((TableField)codelist.getLabelFieldMapping().get(fieldId)).getColumnReference().getType() == TableField.ColumnType.HLParentCode || ((TableField)codelist.getLabelFieldMapping().get(fieldId)).getColumnReference().getType() == TableField.ColumnType.HLChildCode) {
            switch (codelist.getCodelistType()) {
                case Simple: {
                    List codesId = codelist.getFieldsIdByColumnType(TableField.ColumnType.Code);
                    if (codesId.size() == 0) {
                        throw new Exception();
                    }
                    logger.debug((Object)("code id is " + (String)codesId.get(0)));
                    logger.debug((Object)("the type is " + ((Type)table.getFieldsMapping().get(codesId.get(0))).getType().getValue()));
                    this.edit = new CodeListRelationEdit(this.getCodelistId(), fieldId, table, fieldLength, false, (String)codesId.get(0), new String[]{"ID"});
                    break;
                }
                case Hierarchical: {
                    logger.debug((Object)"entering in the hierarchical case");
                    CodeList referenceCodelist = CodeList.get((String)((TableField)codelist.getLabelFieldMapping().get(fieldId)).getColumnReference().getCodelistReferenceId());
                    this.edit = new CodeListRelationEdit(this.getCodelistId(), fieldId, table, fieldLength, false, referenceCodelist.getCodeColumnId(), referenceCodelist.getTable(), "ID");
                    break;
                }
                default: {
                    throw new Exception();
                }
            }
        } else if (type != null) {
            this.edit = new ColumnEditor(this.getCodelistId(), fieldId, table, fieldLength, false, type, "ID");
        } else {
            throw new Exception();
        }
        this.edit.initialize();
        if (!this.store()) {
            logger.warn((Object)"error storing the curation");
            this.edit.dismiss();
            this.edit = null;
            logger.error((Object)"error entering in edit mode");
            throw new Exception("error entering in edit mode");
        }
    }

    public State getEditStatus() {
        if (this.edit != null && this.edit.getIsUnderInitialization() == State.Open) {
            return State.Initializing;
        }
        if (this.edit == null) {
            return State.Open;
        }
        if (this.edit.getIsUnderInitialization() == State.Error) {
            this.edit.dismiss();
            this.edit = null;
            this.store();
            return State.Error;
        }
        return this.edit.getIsUnderInitialization();
    }

    public boolean isUnderEditing() {
        return this.edit != null;
    }

    public synchronized void removeEdit() throws NotInEditModeException, Exception {
        if (this.edit == null) {
            throw new NotInEditModeException();
        }
        this.edit.dismiss();
        this.edit = null;
        this.store();
    }

    public synchronized void saveEdit() throws NotInEditModeException, EditNotFinishedException, Exception {
        logger.debug((Object)("called saveEdit in CLCurationWrapper with edit " + (this.edit == null ? "null" : "not null")));
        if (this.edit != null) {
            if (this.getErrorCount() > 0) {
                throw new EditNotFinishedException();
            }
            CodeListCuration codelist = this.getCodelist();
            try {
                this.edit.save();
                codelist.setLabelFieldMapping(this.getEditModeColumnsDefinition());
            }
            catch (Exception e) {
                logger.debug((Object)"error saving the edit", (Throwable)e);
            }
            codelist.getTable().initializeFieldMapping();
            codelist.updateCount();
            codelist.store();
            try {
                this.edit.dismiss();
            }
            catch (Exception e) {
                logger.debug((Object)"error dismissing edit", (Throwable)e);
            }
        } else {
            throw new NotInEditModeException();
        }
        this.edit = null;
        this.store();
    }

    public synchronized boolean remove() {
        try {
            this.getCodelist().remove();
            try {
                this.removeEdit();
            }
            catch (NotInEditModeException e) {
                logger.debug((Object)"revoming a codelist not in edit mode");
            }
            catch (Exception e) {
                logger.warn((Object)"error dismissing edit");
            }
            ObjectPersistency.get(CLCurationWrapper.class).deleteByKey((Object)this.getCodelistId());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public synchronized boolean store() {
        try {
            ObjectPersistency op = ObjectPersistency.get(CLCurationWrapper.class);
            if (!op.existsKey((Object)this.getCodelistId())) {
                op.insert((Object)this);
            } else {
                op.update((Object)this);
            }
        }
        catch (Exception e) {
            logger.error((Object)"error storing curation wrapper on DB", (Throwable)e);
            return false;
        }
        return true;
    }

    public static CLCurationWrapper get(String id) throws Exception {
        return (CLCurationWrapper)ObjectPersistency.get(CLCurationWrapper.class).getByKey((Object)id);
    }

    public String getDataAsJson(Select query) throws Exception {
        if (this.edit != null) {
            return this.edit.getResultAsJson(query, true);
        }
        query.setTables(new Table[]{new Table(this.getCodelist().getTableName())});
        return query.getResultAsJSon(true, new boolean[0]);
    }

    public void replaceValue(String fieldId, int row, Object value) throws NotInEditModeException, Exception {
        if (this.edit != null && this.edit.getFieldId().equals(fieldId)) {
            this.edit.replaceValue(row, value);
        } else {
            this.getCodelist().replaceValue(fieldId, value.toString(), row);
        }
    }

    public TableField getColumnInEditMode() throws NotInEditModeException, Exception {
        if (this.edit == null) {
            throw new NotInEditModeException();
        }
        CodeListCuration codelist = this.getCodelist();
        TableField tf = (TableField)codelist.getLabelFieldMapping().get(this.edit.getFieldId());
        return new TableField(this.edit.getFieldId(), tf.getFieldName(), tf.getColumnReference(), tf.getDataType());
    }

    public Hashtable<String, TableField> getEditModeColumnsDefinition() throws Exception {
        if (this.edit == null) {
            throw new NotInEditModeException();
        }
        CodeListCuration codelist = this.getCodelist();
        Hashtable<String, TableField> tableFields = new Hashtable<String, TableField>();
        for (TableField tf : codelist.getLabelFieldMapping().values()) {
            if (tf.getId().equals(this.edit.getFieldId())) {
                tableFields.put(this.edit.getFieldId(), new TableField(this.edit.getFieldId(), tf.getFieldName(), tf.getColumnReference(), this.edit.getDataType().getType(), tf.getLength()));
                continue;
            }
            tableFields.put(tf.getId(), tf);
        }
        return tableFields;
    }

    public int getErrorCount() throws NotInEditModeException, Exception {
        if (this.edit == null) {
            throw new NotInEditModeException();
        }
        return (int)this.edit.errorCount();
    }

    public void removeAllErrors() throws NotInEditModeException, Exception {
        if (this.edit == null) {
            throw new NotInEditModeException();
        }
        this.edit.removeAllErrors();
    }

    public int getSize() throws Exception {
        SimpleTable table = new SimpleTable(this.getCodelist().getTableName());
        table.initializeCount();
        return table.getCount();
    }

    public String getCodesAsJson(Limit limit, Order order) throws Exception {
        Select select = (Select)DBSession.getImplementation(Select.class);
        if (this.getCodelist().getFieldsIdByColumnType(TableField.ColumnType.Code).size() == 0) {
            throw new Exception();
        }
        select.setTables(new Table[]{new Table(this.getCodelist().getTableName())});
        select.setLimit(limit);
        select.setOrders(new Order[]{order});
        return select.getResultAsJSon(true, new boolean[0]);
    }

    public static Iterator<CLCurationWrapper> getByUser(String user) throws Exception {
        return ObjectPersistency.get(CLCurationWrapper.class).getObjectByField("owner", (Object)user);
    }

    public static Iterator<CLCurationWrapper> getAll() throws Exception {
        return ObjectPersistency.get(CLCurationWrapper.class).getAll();
    }
}

