/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.codelist;

import java.util.ArrayList;
import java.util.Iterator;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Limit;
import org.gcube.common.dbinterface.Order;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.persistence.ObjectNotFoundException;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.contentmanagement.codelistmanager.entities.CodeList;
import org.gcube.contentmanagement.codelistmanager.managers.CodeListCuration;
import org.gcube.contentmanagement.timeseriesservice.impl.codelist.wrappers.CLCurationWrapper;
import org.gcube.contentmanagement.timeseriesservice.impl.codelist.wrappers.CLManagerWrapper;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Export;
import org.gcube.contentmanagement.timeseriesservice.stubs.AccessFault;
import org.gcube.contentmanagement.timeseriesservice.stubs.CLExportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodeListType;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistColumnsDefinitionArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistIdentifier;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistItemsArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateCodeListRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.DataAsJsonRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ItemNotFoundFault;
import org.gcube.contentmanagement.timeseriesservice.stubs.OrderType;
import org.gcube.contentmanagement.timeseriesservice.stubs.State;

public class CodelistManager {
    private static GCUBELog logger = new GCUBELog(CodelistManager.class);

    public String createCodeList(CreateCodeListRequest request) throws GCUBEFault {
        CodeListCuration curation;
        try {
            CLCurationWrapper curationWrapper = CLCurationWrapper.get(request.getCurationId());
            if (!curationWrapper.getOwner().equals(request.getUser()) || !ServiceContext.getContext().getScope().toString().equals(curationWrapper.getScope().toString())) {
                throw new AccessFault();
            }
            curation = curationWrapper.getCodelist();
        }
        catch (ObjectNotFoundException e) {
            throw new ItemNotFoundFault();
        }
        catch (Exception e) {
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
        final CodeList codelist = new CodeList(curation.getAgencyId(), curation.getName(), curation.getDescription(), curation.isFinal());
        final CLManagerWrapper managerWrapper = new CLManagerWrapper(codelist.getId(), request.getUser(), ServiceContext.getContext().getScope(), request.getSuperUsers());
        Thread managerThread = new Thread(){

            @Override
            public void run() {
                managerWrapper.setStatus(State.Open);
                managerWrapper.store();
                if (!codelist.initialize(curation)) {
                    managerWrapper.setStatus(State.Error);
                } else {
                    managerWrapper.setStatus(State.Close);
                }
                managerWrapper.store();
            }
        };
        try {
            ServiceContext.getContext().useServiceCredentials(new Thread[]{managerThread});
        }
        catch (Exception e) {
            logger.error((Object)"error initializing the codelist", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
        managerThread.start();
        return codelist.getId();
    }

    public State getCodeListStatus(CodelistIdentifier identifier) throws GCUBEFault {
        try {
            CLManagerWrapper clManagerWrapper = CLManagerWrapper.get(identifier.getId());
            if (!clManagerWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString())) {
                throw new AccessFault();
            }
            return clManagerWrapper.getStatus();
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error getting data as json", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public String getDataAsJson(DataAsJsonRequest request) throws GCUBEFault {
        try {
            CLManagerWrapper clManagerWrapper = CLManagerWrapper.get(request.getIdentifier().getId());
            if (!clManagerWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString())) {
                throw new AccessFault();
            }
            Select selectQuery = (Select)DBSession.getImplementation(Select.class);
            selectQuery.setLimit(new Limit(request.getLimit().getLowerLimit(), request.getLimit().getUpperLimit()));
            selectQuery.setOrders(new Order[]{new Order(request.getOrder().getOrder() == OrderType.Ascending ? Order.OrderType.ASC : Order.OrderType.DESC, (Attribute)new SimpleAttribute(request.getOrder().getField()))});
            return clManagerWrapper.getDataAsJson(selectQuery);
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error getting data as json", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public CodelistColumnsDefinitionArray getColumnsDefinition(CodelistIdentifier identifier) throws GCUBEFault {
        try {
            CLManagerWrapper clManagerWrapper = CLManagerWrapper.get(identifier.getId());
            if (!clManagerWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString())) {
                throw new AccessFault();
            }
            return clManagerWrapper.getColumnsDefinition();
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error getting columns defintion", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public CodelistItemsArray getCodelists(VOID req) throws GCUBEFault {
        try {
            Iterator<CLManagerWrapper> clManagerIterator = CLManagerWrapper.getByScope(ServiceContext.getContext().getScope());
            ArrayList<CodelistItem> clItemsArray = new ArrayList<CodelistItem>();
            while (clManagerIterator.hasNext()) {
                CLManagerWrapper clWrapper = clManagerIterator.next();
                try {
                    CodeList codelist = clWrapper.getCodelist();
                    clItemsArray.add(new CodelistItem(codelist.getAgency(), CodeListType.fromValue((String)codelist.getCodelistType().toString()), codelist.getCreationDate(), clWrapper.getCreator(), codelist.getDescription(), codelist.getId(), codelist.getModificationDate(), codelist.getName(), codelist.getCount(), clWrapper.getStatus(), codelist.getVersion()));
                }
                catch (ObjectNotFoundException e) {
                    logger.warn((Object)("the wrapper " + clWrapper.getCodelistId() + " is not bound to a codelist"), (Throwable)e);
                    clWrapper.remove();
                }
            }
            return new CodelistItemsArray(clItemsArray.toArray(new CodelistItem[clItemsArray.size()]));
        }
        catch (Exception e1) {
            logger.error((Object)"error getting codelists", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public CodelistItem getCodelistItem(CodelistIdentifier identifier) throws GCUBEFault {
        try {
            CLManagerWrapper clManagerWrapper = CLManagerWrapper.get(identifier.getId());
            if (!clManagerWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString())) {
                throw new AccessFault();
            }
            CodeList codelist = clManagerWrapper.getCodelist();
            return new CodelistItem(codelist.getAgency(), CodeListType.fromValue((String)codelist.getCodelistType().toString()), codelist.getCreationDate(), clManagerWrapper.getCreator(), codelist.getDescription(), codelist.getId(), codelist.getModificationDate(), codelist.getName(), codelist.getCount(), clManagerWrapper.getStatus(), codelist.getVersion());
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error getting columns defintion", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public VOID remove(CodelistIdentifier identifier) throws GCUBEFault {
        try {
            CLManagerWrapper clManagerWrapper = CLManagerWrapper.get(identifier.getId());
            if (!clManagerWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString())) {
                throw new AccessFault();
            }
            clManagerWrapper.remove();
            return new VOID();
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error getting columns defintion", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public int getSize(String id) throws GCUBEFault {
        try {
            CLManagerWrapper clManagerWrapper = CLManagerWrapper.get(id);
            if (!clManagerWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString())) {
                throw new AccessFault();
            }
            return clManagerWrapper.getCodelist().getCount();
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error getting columns defintion", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public String getCodes(DataAsJsonRequest request) throws GCUBEFault {
        try {
            CLManagerWrapper clManagerWrapper = CLManagerWrapper.get(request.getIdentifier().getId());
            if (!clManagerWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString())) {
                throw new AccessFault();
            }
            Select selectQuery = (Select)DBSession.getImplementation(Select.class);
            selectQuery.setAttributes(new Attribute[]{new SimpleAttribute(clManagerWrapper.getCodelist().getCodeColumnId())});
            selectQuery.setLimit(new Limit(request.getLimit().getLowerLimit(), request.getLimit().getUpperLimit()));
            selectQuery.setOrders(new Order[]{new Order(request.getOrder().getOrder() == OrderType.Ascending ? Order.OrderType.ASC : Order.OrderType.DESC, (Attribute)new SimpleAttribute(request.getOrder().getField()))});
            return clManagerWrapper.getDataAsJson(selectQuery);
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error getting data as json", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public String export(CLExportRequest request) throws Exception {
        try {
            CLManagerWrapper clManagerWrapper = CLManagerWrapper.get(request.getIdentifier().getId());
            if (!clManagerWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString())) {
                throw new AccessFault();
            }
            CodeList codeList = clManagerWrapper.getCodelist();
            return Export.codeListAsCsv(codeList.getTable(), codeList.getName(), request.isHeader());
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error getting data as json", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }
}

