/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseriesservice.impl.codelist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetryEquivalentFault;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Limit;
import org.gcube.common.dbinterface.Order;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.attributes.SimpleAttribute;
import org.gcube.common.dbinterface.persistence.ObjectNotFoundException;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.queries.Select;
import org.gcube.common.dbinterface.types.Type;
import org.gcube.contentmanagement.codelistmanager.entities.TableField;
import org.gcube.contentmanagement.codelistmanager.managers.CodeListCuration;
import org.gcube.contentmanagement.codelistmanager.managers.CodeListImport;
import org.gcube.contentmanagement.codelistmanager.util.CodeListType;
import org.gcube.contentmanagement.codelistmanager.util.ColumnReference;
import org.gcube.contentmanagement.timeseriesservice.impl.codelist.wrappers.CLCurationWrapper;
import org.gcube.contentmanagement.timeseriesservice.impl.codelist.wrappers.CLImportItemWrapper;
import org.gcube.contentmanagement.timeseriesservice.impl.context.ServiceContext;
import org.gcube.contentmanagement.timeseriesservice.impl.exceptions.EditNotFinishedException;
import org.gcube.contentmanagement.timeseriesservice.impl.exceptions.NotInEditModeException;
import org.gcube.contentmanagement.timeseriesservice.impl.utils.Util;
import org.gcube.contentmanagement.timeseriesservice.stubs.AccessFault;
import org.gcube.contentmanagement.timeseriesservice.stubs.CLUnderCurationItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.CLUnderCurationItemsArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.ChangeColumnTypeRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CheckNullValuesOnDataTypeChangeRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistColumnType;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistColumnsDefinitionArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistIdentifier;
import org.gcube.contentmanagement.timeseriesservice.stubs.DataAsJsonRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.EnterInEditModeRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ItemNotFoundFault;
import org.gcube.contentmanagement.timeseriesservice.stubs.NotInEditModeFault;
import org.gcube.contentmanagement.timeseriesservice.stubs.OrderType;
import org.gcube.contentmanagement.timeseriesservice.stubs.RemoveColumnRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.RemoveRowsRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.ReplaceValueRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.SetCLLabelRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.SetPropertiesRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.StartCurationModeRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.State;

public class CodelistCurationManager {
    private static GCUBELog logger = new GCUBELog(CodelistCurationManager.class);

    public String startCurationMode(StartCurationModeRequest request) throws GCUBEFault {
        CodeListImport importer;
        try {
            CLImportItemWrapper importWrapper = CLImportItemWrapper.get(request.getImportId());
            if (!importWrapper.getOwner().equals(request.getUser()) || !ServiceContext.getContext().getScope().toString().equals(importWrapper.getScope().toString())) {
                throw new AccessFault();
            }
            importer = importWrapper.getCodelist();
        }
        catch (ObjectNotFoundException e) {
            throw new ItemNotFoundFault();
        }
        catch (Exception e) {
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
        final CodeListCuration curation = new CodeListCuration(importer.getName(), importer.getDescription(), importer.getAgencyId(), importer.isFinal(), importer.getVersion(), importer.getCodelistType() == CodeListType.Unknown ? CodeListType.valueOf((String)request.getCodeListType().toString()) : importer.getCodelistType());
        curation.store();
        final CLCurationWrapper curationWrapper = new CLCurationWrapper(request.getUser(), curation.getId(), ServiceContext.getContext().getScope());
        curationWrapper.store();
        Thread curationThread = new Thread(){

            @Override
            public void run() {
                curationWrapper.setStatus(State.Open);
                curationWrapper.store();
                if (curation.start(importer)) {
                    curationWrapper.setStatus(State.Close);
                } else {
                    curationWrapper.setStatus(State.Error);
                }
                curationWrapper.store();
            }
        };
        try {
            ServiceContext.getContext().useServiceCredentials(new Thread[]{curationThread});
        }
        catch (Exception e) {
            logger.error((Object)"error starting curation", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
        curationThread.start();
        return curation.getId();
    }

    public String getDataAsJson(DataAsJsonRequest request) throws GCUBEFault {
        try {
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(request.getIdentifier().getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !request.getIdentifier().getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            Select selectQuery = (Select)DBSession.getImplementation(Select.class);
            selectQuery.setLimit(new Limit(request.getLimit().getLowerLimit(), request.getLimit().getUpperLimit()));
            selectQuery.setOrders(new Order[]{new Order(request.getOrder().getOrder() == OrderType.Ascending ? Order.OrderType.ASC : Order.OrderType.DESC, (Attribute)new SimpleAttribute(request.getOrder().getField()))});
            return clCurationWrapper.getDataAsJson(selectQuery);
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error getting data as json", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public CLUnderCurationItemsArray getUnderCurationCodelists(String user) throws GCUBEFault {
        ArrayList<CLUnderCurationItem> clItems = new ArrayList<CLUnderCurationItem>();
        logger.debug((Object)("calling  getUnderCurationCodelists with user " + user));
        try {
            Iterator<CLCurationWrapper> clCurationWrapperIterator = CLCurationWrapper.getByUser(user);
            while (clCurationWrapperIterator.hasNext()) {
                CLCurationWrapper wrapperItem = clCurationWrapperIterator.next();
                logger.debug((Object)("scope is null ? " + (wrapperItem.getScope() == null)));
                logger.debug((Object)("service context is null ? " + (ServiceContext.getContext() == null)));
                if (!wrapperItem.getScope().equals((Object)ServiceContext.getContext().getScope())) continue;
                try {
                    CodeListCuration item = wrapperItem.getCodelist();
                    clItems.add(new CLUnderCurationItem(item.isFinal(), item.getAgencyId(), org.gcube.contentmanagement.timeseriesservice.stubs.CodeListType.fromString((String)item.getCodelistType().toString()), item.getCreationDate(), item.getDescription(), item.getId(), item.getLastModifyDate(), item.getName(), wrapperItem.getOwner(), item.getCount(), wrapperItem.getStatus(), item.getVersion()));
                }
                catch (ObjectNotFoundException e) {
                    logger.warn((Object)("the wrapper with id " + wrapperItem.getCodelistId() + " is not bound to a codeListCuration"));
                    wrapperItem.remove();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"error getting imported items", (Throwable)e);
            throw new GCUBEFault(new String[]{"error retrieving codelist imported items"});
        }
        return new CLUnderCurationItemsArray(clItems.toArray(new CLUnderCurationItem[clItems.size()]));
    }

    public CLUnderCurationItem getCLUnderCurationItem(CodelistIdentifier identifier) throws GCUBEFault {
        try {
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(identifier.getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !identifier.getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            CodeListCuration item = clCurationWrapper.getCodelist();
            return new CLUnderCurationItem(item.isFinal(), item.getAgencyId(), org.gcube.contentmanagement.timeseriesservice.stubs.CodeListType.fromString((String)item.getCodelistType().toString()), item.getCreationDate(), item.getDescription(), item.getId(), item.getLastModifyDate(), item.getName(), clCurationWrapper.getOwner(), item.getCount(), clCurationWrapper.getStatus(), item.getVersion());
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)("error getting imported item with id " + identifier.getId()), (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public boolean checkCodeListCurationFinished(CodelistIdentifier identifier) throws GCUBEFault {
        try {
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(identifier.getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !identifier.getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            if (clCurationWrapper.isUnderEditing()) {
                return false;
            }
            CodeListCuration item = clCurationWrapper.getCodelist();
            return item.isMappingFinished();
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)("error getting imported item with id " + identifier.getId()), (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public CodelistColumnsDefinitionArray getColumnsDefinition(CodelistIdentifier identifier) throws GCUBEFault {
        ArrayList<CodelistColumnDefinition> columnDefinitionList = new ArrayList<CodelistColumnDefinition>();
        try {
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(identifier.getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !identifier.getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            Object[] returnList = clCurationWrapper.getCodelist().getLabelFieldMapping().values().toArray(new TableField[0]);
            Arrays.sort(returnList);
            for (Object cd : returnList) {
                columnDefinitionList.add(new CodelistColumnDefinition(CodelistColumnType.fromString((String)cd.getColumnReference().getType().toString()), Util.mapSqlToJava(cd.getDataType()), cd.getId(), cd.getFieldName(), cd.getColumnReference().getCodelistReferenceId()));
            }
            return new CodelistColumnsDefinitionArray(columnDefinitionList.toArray(new CodelistColumnDefinition[columnDefinitionList.size()]));
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error getting column definition", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public boolean remove(CodelistIdentifier identifier) throws GCUBEFault {
        try {
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(identifier.getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !identifier.getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            return clCurationWrapper.remove();
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error removing imported codelist", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public synchronized VOID changeColumnType(ChangeColumnTypeRequest request) throws GCUBEFault {
        try {
            logger.debug((Object)"changing columnType");
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(request.getIdentifier().getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !request.getIdentifier().getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            CodeListCuration codelist = clCurationWrapper.getCodelist();
            codelist.changeColumnType(request.getFieldId(), TableField.ColumnType.valueOf((String)request.getColumnType().toString()), new String[]{request.getRelatedCodeListId()});
            if (!codelist.store()) {
                throw new GCUBERetryEquivalentFault();
            }
            return new VOID();
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (GCUBEFault f1) {
            logger.error((Object)"error changing column type", (Throwable)f1);
            throw f1;
        }
        catch (Exception e1) {
            logger.error((Object)"error changing column type", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public int checkNullValuesOnDataTypeChange(CheckNullValuesOnDataTypeChangeRequest request) throws GCUBEFault {
        try {
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(request.getIdentifier().getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !request.getIdentifier().getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            if (request.getColumnType() == null) {
                return clCurationWrapper.getCodelist().getInvalidRows(request.getFieldId(), new Type(Util.mapJavaToSql(request.getDataType()), new int[0])).length;
            }
            return clCurationWrapper.getCodelist().getInvalidRows(request.getFieldId(), new ColumnReference(TableField.ColumnType.valueOf((String)request.getColumnType().toString()), null, request.getCodelistReferenceId())).length;
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error checking the curation", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public synchronized VOID enterInEditMode(EnterInEditModeRequest request) throws GCUBEFault {
        try {
            logger.debug((Object)"entering in edit mode");
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(request.getIdentifier().getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !request.getIdentifier().getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            if (request.getDataType() == null) {
                clCurationWrapper.edit(request.getFieldId());
            } else {
                clCurationWrapper.edit(request.getFieldId(), new Type(Util.mapJavaToSql(request.getDataType()), new int[0]));
            }
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error checking the curation", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
        return new VOID();
    }

    public synchronized VOID saveEdit(CodelistIdentifier identifier) throws GCUBEFault {
        try {
            logger.debug((Object)("saving Edit for id " + identifier.getId()));
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(identifier.getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !identifier.getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            clCurationWrapper.saveEdit();
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found saving edit", (Throwable)e);
            e.printStackTrace();
            throw new ItemNotFoundFault();
        }
        catch (EditNotFinishedException enf) {
            logger.error((Object)"edit not finished exception", (Throwable)enf);
            throw new GCUBEFault(new String[]{"the Edit is not yet complete"});
        }
        catch (NotInEditModeException nie) {
            logger.error((Object)"not in edit mode", (Throwable)nie);
            throw new NotInEditModeFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error checking the curation", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
        return new VOID();
    }

    public synchronized VOID removeEdit(CodelistIdentifier identifier) throws GCUBEFault {
        try {
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(identifier.getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !identifier.getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            clCurationWrapper.removeEdit();
            clCurationWrapper.store();
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (NotInEditModeException nie) {
            logger.error((Object)"not in edit mode", (Throwable)nie);
            throw new NotInEditModeFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error checking the curation", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
        return new VOID();
    }

    public State getEditingStatus(CodelistIdentifier identifier) throws GCUBEFault {
        try {
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(identifier.getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !identifier.getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            return clCurationWrapper.getEditStatus();
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error checking the curation", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public boolean isUnderEditing(CodelistIdentifier identifier) throws GCUBEFault {
        try {
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(identifier.getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !identifier.getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            return clCurationWrapper.isUnderEditing();
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error checking the curation", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public synchronized VOID replaceValue(ReplaceValueRequest request) throws GCUBEFault {
        try {
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(request.getIdentifier().getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !request.getIdentifier().getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            clCurationWrapper.replaceValue(request.getFieldId(), request.getRowId(), request.getNewValue());
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found replacing value", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (NotInEditModeException nie) {
            logger.error((Object)"not in edit mode", (Throwable)nie);
            throw new NotInEditModeFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error checking the curation", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
        return new VOID();
    }

    public VOID setLabel(SetCLLabelRequest request) throws GCUBEFault {
        try {
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(request.getIdentifier().getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !request.getIdentifier().getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            CodeListCuration codelist = clCurationWrapper.getCodelist();
            ((TableField)codelist.getLabelFieldMapping().get(request.getFieldId())).setFieldName(request.getLabel());
            codelist.store();
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found setting label", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error checking the curation", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
        return new VOID();
    }

    public State getCurationStatus(CodelistIdentifier identifier) throws GCUBEFault {
        try {
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(identifier.getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !identifier.getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            return clCurationWrapper.getStatus();
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found getting the curation status", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error checking the curation", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public synchronized VOID removeAllErrors(CodelistIdentifier identifier) throws GCUBEFault {
        try {
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(identifier.getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !identifier.getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            clCurationWrapper.removeAllErrors();
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found removing all error", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (NotInEditModeException nie) {
            logger.error((Object)"not in edit mode", (Throwable)nie);
            throw new NotInEditModeFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error checking the curation", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
        return new VOID();
    }

    public synchronized CodelistColumnDefinition getColumnDefinitionUnderEdit(CodelistIdentifier identifier) throws GCUBEFault {
        try {
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(identifier.getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !identifier.getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            TableField tf = clCurationWrapper.getColumnInEditMode();
            return new CodelistColumnDefinition(CodelistColumnType.fromString((String)tf.getColumnReference().getType().toString()), Util.mapSqlToJava(tf.getDataType()), tf.getId(), tf.getFieldName(), tf.getColumnReference().getCodelistReferenceId());
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found getting column under edit", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (NotInEditModeException nie) {
            logger.error((Object)"not in edit mode", (Throwable)nie);
            throw new NotInEditModeFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error checking the curation", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public synchronized int getErrorCount(CodelistIdentifier identifier) throws GCUBEFault {
        try {
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(identifier.getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !identifier.getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            return clCurationWrapper.getErrorCount();
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found getting error count", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (NotInEditModeException nie) {
            logger.error((Object)"not in edit mode", (Throwable)nie);
            throw new NotInEditModeFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error checking the curation", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public int getSize(CodelistIdentifier identifier) throws GCUBEFault {
        try {
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(identifier.getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !identifier.getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            return clCurationWrapper.getSize();
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found getting the size", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error checking the curation", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public String getCodes(DataAsJsonRequest request) throws GCUBEFault {
        try {
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(request.getIdentifier().getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !request.getIdentifier().getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            Order order = new Order(request.getOrder().getOrder() == OrderType.Ascending ? Order.OrderType.ASC : Order.OrderType.DESC, (Attribute)new SimpleAttribute(request.getOrder().getField()));
            Limit limit = new Limit(request.getLimit().getLowerLimit(), request.getLimit().getUpperLimit());
            return clCurationWrapper.getCodesAsJson(limit, order);
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found getting the size", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error checking the curation", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public boolean removeRows(RemoveRowsRequest request) throws GCUBEFault {
        try {
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(request.getIdentifier().getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !request.getIdentifier().getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            return false;
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found getting the size", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error removing rows", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public boolean removeColumn(RemoveColumnRequest request) throws GCUBEFault {
        try {
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(request.getIdentifier().getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !request.getIdentifier().getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            CodeListCuration codelist = clCurationWrapper.getCodelist();
            if (clCurationWrapper.isUnderEditing()) {
                throw new Exception("the remove column cannot be done in error edit mode ");
            }
            boolean toReturn = codelist.removeColumn(request.getFieldId());
            codelist.store();
            return toReturn;
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found getting the size", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error removing column", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }

    public VOID setProperties(SetPropertiesRequest request) throws GCUBEFault {
        try {
            CLCurationWrapper clCurationWrapper = CLCurationWrapper.get(request.getIdentifier().getId());
            if (!clCurationWrapper.getScope().toString().equals(ServiceContext.getContext().getScope().toString()) || !request.getIdentifier().getUser().equals(clCurationWrapper.getOwner())) {
                throw new AccessFault();
            }
            CodeListCuration codelist = clCurationWrapper.getCodelist();
            codelist.setName(request.getName());
            codelist.setDescription(request.getDescription());
            codelist.setAgencyId(request.getAgencyId());
            codelist.setFinal(request.isIsFinal());
            codelist.setVersion(request.getVersion());
            codelist.store();
            return new VOID();
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"item not found getting the size", (Throwable)e);
            throw new ItemNotFoundFault();
        }
        catch (Exception e1) {
            logger.error((Object)"error setting properties", (Throwable)e1);
            throw new GCUBEFault((Throwable)e1, new String[0]);
        }
    }
}

