package org.gcube.contentmanagement.timeseriesservice.calls.codelist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.types.VOID;
import org.gcube.contentmanagement.timeseriesservice.calls.Constant;
import org.gcube.contentmanagement.timeseriesservice.calls.NoServiceFoundException;
import org.gcube.contentmanagement.timeseriesservice.stubs.CLExportRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistItem;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistItemsArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.CodelistManagerPortType;
import org.gcube.contentmanagement.timeseriesservice.stubs.CreateCodeListRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodelistColumnDefinition;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodelistColumnsDefinitionArray;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.CodelistIdentifier;
import org.gcube.contentmanagement.timeseriesservice.stubs.codelist.types.DataAsJsonRequest;
import org.gcube.contentmanagement.timeseriesservice.stubs.service.CodelistManagerServiceAddressingLocator;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Limit;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Order;
import org.gcube.contentmanagement.timeseriesservice.stubs.types.Status;

public class CodeListManagerCall extends CodeListCall{
	
	private static String getEndpoint() {
		return "gcube/contentmanagement/timeseriesservice/codelist/CodelistManager";
	}
	
	
	private static  HashMap<String, CodelistManagerPortType> clImportManagerPTMapping= new HashMap<String, CodelistManagerPortType>();
	private String user;
	private String id;
	private CodelistManagerPortType cachedPT;
	
	/**
	 * 
	 * @param scope
	 * @param epr
	 * @throws NoServiceFoundException
	 * @throws Exception
	 */
	public static void setPT(GCUBEScope scope, EndpointReferenceType epr) throws NoServiceFoundException, Exception{
		CodelistManagerPortType pt = new CodelistManagerServiceAddressingLocator().getCodelistManagerPortTypePort(epr);
		pt= GCUBERemotePortTypeContext.getProxy(pt, scope);
		clImportManagerPTMapping.put(scope.toString(),pt);
	}
	
	/**
	 * 
	 * @param scope
	 * @param securityManager
	 * @return
	 * @throws NoServiceFoundException
	 * @throws Exception
	 */
	private static CodelistManagerPortType getCodelistManagerPortType(GCUBEScope scope, GCUBESecurityManager ... securityManager) throws NoServiceFoundException, Exception{
		if (clImportManagerPTMapping.get(scope.toString())==null){
			CodelistManagerPortType pt = new CodelistManagerServiceAddressingLocator().getCodelistManagerPortTypePort(getEpr(scope, getEndpoint()));
			pt= GCUBERemotePortTypeContext.getProxy(pt, scope, securityManager);
			clImportManagerPTMapping.put(scope.toString(),pt);
		}
		return	clImportManagerPTMapping.get(scope.toString());
		
	}
	
	/**
	 * 
	 * @param curationId
	 * @param superUsers
	 * @param scope
	 * @param securityManagers
	 * @return
	 * @throws NoServiceFoundException
	 * @throws Exception
	 */
	public static String createCodelist(String curationId, String user, List<String> superUsers, GCUBEScope scope, GCUBESecurityManager ... securityManagers) throws NoServiceFoundException, Exception{
		return getCodelistManagerPortType(scope, securityManagers).createCodeList(new CreateCodeListRequest(curationId, superUsers.toArray(new String[superUsers.size()]), user));
	}

	/**
	 * 
	 * @param scope
	 * @param securityManagers
	 * @return
	 * @throws Exception
	 */
	public static List<CodelistItem> getCodelists(GCUBEScope scope, GCUBESecurityManager ... securityManagers) throws Exception{
		CodelistItemsArray items= getCodelistManagerPortType(scope, securityManagers).getCodelists(new VOID());
		if (items.getItems()==null) return new ArrayList<CodelistItem>();
		return Arrays.asList(items.getItems());
	}
	
	
	/**
	 * 
	 * @param scope
	 * @param securityManagers
	 * @return
	 * @throws Exception
	 */
	public static CodelistItem getCodelistItem(String id, String user, GCUBEScope scope, GCUBESecurityManager ... securityManagers) throws Exception{
		return getCodelistManagerPortType(scope, securityManagers).getCodelistItem(new CodelistIdentifier(id, user));
	}
	
	
	/**
	 * 
	 * @param user
	 * @param id
	 * @param scope
	 * @param securityManager
	 * @throws NoServiceFoundException
	 * @throws Exception
	 */
	public CodeListManagerCall(String user, String id, GCUBEScope scope, GCUBESecurityManager ... securityManager) throws NoServiceFoundException, Exception{
		this.user = user;
		this.id = id;
		this.cachedPT = getCodelistManagerPortType(scope, securityManager);
	}
	
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public Status getCodeListStatus() throws Exception{
		return cachedPT.getCodeListStatus(new CodelistIdentifier(id, user));
	}
	
	/**
	 * 
	 * @param limit
	 * @param order
	 * @return
	 * @throws Exception
	 */
	public String getDataAsJson(Limit limit, Order order) throws Exception {
		Exception exception;
		int tries = 0;
		do{
			try{
				return cachedPT.getDataAsJson(new DataAsJsonRequest(new CodelistIdentifier(id, user), limit, order));
			}catch (Exception e) {
				tries++;
				exception=e;
			}
		}while(tries<Constant.MAX_TRIES);
		throw exception;
	}
	
	
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public List<CodelistColumnDefinition> getColumnsDefinition() throws Exception{
		CodelistColumnsDefinitionArray cdArray= cachedPT.getColumnsDefinition(new CodelistIdentifier(id, user));
		if (cdArray.getDefinition()==null)  return new ArrayList<CodelistColumnDefinition>();
		else return Arrays.asList(cdArray.getDefinition());
	}
	
	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public CodelistItem getCodelistItem() throws Exception{
		return cachedPT.getCodelistItem(new CodelistIdentifier(id, user));
	}
	
	/**
	 * 
	 * @throws Exception
	 */
	public void remove() throws Exception{
		cachedPT.remove(new CodelistIdentifier(id, user));
	}
	
	public int getSize() throws Exception{
		return cachedPT.getSize(id);
	}
	
	public String getCodes(Limit limit, Order order) throws Exception{
		return cachedPT.getCodes(new DataAsJsonRequest(new CodelistIdentifier(id, user), limit, order));
	}
	
	
	public String export(boolean withHeader) throws Exception {
		return cachedPT.export(new CLExportRequest(withHeader, new CodelistIdentifier(id, user)));
	}
	
}
