/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.timeseries.geotools.vti.test.experiments;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.geoserverinterface.GeoCaller;
import org.gcube.common.geoserverinterface.GeoserverCaller;
import org.gcube.common.geoserverinterface.Logger;
import org.gcube.common.geoserverinterface.bean.FeatureTypeRest;
import org.gcube.common.geoserverinterface.engine.MakeStyle;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.EngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.gcube.contentmanagement.timeseries.geotools.databases.ConnectionsManager;
import org.gcube.contentmanagement.timeseries.geotools.engine.TSGeoToolsConfiguration;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISInformation;
import org.gcube.contentmanagement.timeseries.geotools.gisconnectors.GISOperations;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.hibernate.SessionFactory;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.expression.Expression;

public class ClusterStylesGenerator {
    GISInformation gisInfo;
    ConnectionsManager connectionsManager;
    String workspace;
    String datastore;
    EngineConfiguration geocfg;

    public ClusterStylesGenerator(String configFolder, String geoNetworkURL, String geoServerBackupURL, String geoNetworkUser, String geoNetworkPwd, String geoServerUser, String geoServerPwd, String geoServerDBURL, String geoServerDBUser, String geoServerDBPWD, String workspace, String datastore) {
        AnalysisLogger.setLogger((String)(configFolder + AlgorithmConfiguration.defaultLoggerFile));
        this.workspace = workspace;
        this.datastore = datastore;
        this.gisInfo = new GISInformation();
        this.gisInfo.setGeoNetworkUrl(geoNetworkURL);
        this.gisInfo.setGeoNetworkUserName(geoNetworkUser);
        this.gisInfo.setGeoNetworkPwd(geoNetworkPwd);
        this.gisInfo.setGisDataStore(datastore);
        this.gisInfo.setGisUserName(geoServerUser);
        this.gisInfo.setGisPwd(geoServerPwd);
        this.gisInfo.setGisWorkspace(workspace);
        this.gisInfo.setGisUrl(geoServerBackupURL);
        this.geocfg = new EngineConfiguration();
        this.geocfg.setConfigPath(configFolder);
        this.geocfg.setDatabaseUserName(geoServerDBUser);
        this.geocfg.setDatabasePassword(geoServerDBPWD);
        this.geocfg.setDatabaseURL(geoServerDBURL);
    }

    public static String createPointsStyleMapString(String styleName, String styleAttribute, int numberOfClusters, Class typeValue, Object minValue, Object maxValue) throws Exception {
        String style = ClusterStylesGenerator.createStyleScatterColors(styleName, styleAttribute, numberOfClusters, typeValue, minValue, maxValue);
        style = style.replace("<sld:PolygonSymbolizer>", "<PointSymbolizer><Graphic><Mark><WellKnownName>square</WellKnownName>");
        style = style.replace("</sld:PolygonSymbolizer>", "</Mark><Size>6</Size></Graphic></PointSymbolizer>");
        return style;
    }

    public boolean generateStyleMap(String clusteringAlgorithmName, String clusterTable, String destinationMapTable, String datastore, String clusteridField, String outliersField) throws Exception {
        try {
            this.connectionsManager = new ConnectionsManager(this.geocfg.getConfigPath());
            this.connectionsManager.initGeoserverConnection(this.geocfg);
            AnalysisLogger.getLogger().trace((Object)"Connected to Geo Server DB");
            String randomSuffix = ("" + Math.random()).replace(".", "").substring(0, 3);
            String styleName = clusteringAlgorithmName + "_" + destinationMapTable + "_" + randomSuffix;
            String styleNameOutliers = "outliers_" + styleName;
            String styleAttribute = clusteridField;
            AnalysisLogger.getLogger().trace((Object)"Getting Number of Clusters");
            List pointsN = DatabaseFactory.executeSQLQuery((String)String.format("select count(*) from (select distinct " + styleAttribute + " from %1$s) as a", destinationMapTable), (SessionFactory)this.connectionsManager.getGeoserverConnection());
            int numberOfClusters = Integer.parseInt("" + pointsN.get(0));
            System.out.println("Number Of Clusters " + numberOfClusters);
            String style = ClusterStylesGenerator.createPointsStyleMapString(styleName, styleAttribute, numberOfClusters, Integer.class, numberOfClusters - 1, 0);
            String styleOutliers = ClusterStylesGenerator.createPointsStyleMapString(styleNameOutliers, outliersField, numberOfClusters, Boolean.class, Boolean.TRUE, Boolean.FALSE);
            AnalysisLogger.getLogger().trace((Object)"Creating Style on GeoServer");
            GeoCaller gc = new GISOperations().getGeoCaller(this.gisInfo);
            String geoserverURL = gc.getGeoServerForLayer(destinationMapTable);
            AnalysisLogger.getLogger().trace((Object)("Selected Geoserver for layer " + destinationMapTable + " : " + geoserverURL));
            GeoserverCaller gsc = new GeoserverCaller(geoserverURL, this.gisInfo.getGisUserName(), this.gisInfo.getGisPwd());
            ArrayList files = gsc.listStyles();
            AnalysisLogger.getLogger().trace((Object)"Checking if style is yet present");
            for (String filename : files) {
                if (!(filename = filename.trim()).equalsIgnoreCase(styleName)) continue;
                AnalysisLogger.getLogger().trace((Object)("Deleting previous style " + styleName));
                boolean del = new GISOperations().deleteStyle(this.gisInfo, filename);
                Thread.sleep(5000L);
                AnalysisLogger.getLogger().trace((Object)("Deleted " + del));
            }
            boolean toReturn = gsc.sendStyleSDL(style);
            AnalysisLogger.getLogger().trace((Object)("Sent Creation request to geoServer for clustering style " + styleName + " : " + toReturn));
            toReturn = gsc.sendStyleSDL(styleOutliers);
            AnalysisLogger.getLogger().trace((Object)("Sent Creation request to geoServer for outliers style " + styleNameOutliers + " : " + toReturn));
            FeatureTypeRest ftr = gsc.getFeatureType(this.workspace, datastore, destinationMapTable);
            ArrayList<String> styles = new ArrayList<String>();
            styles.add(styleName);
            styles.add(styleNameOutliers);
            styles.add("point");
            boolean addedStyle = gsc.setLayer(ftr, styleName, styles);
            AnalysisLogger.getLogger().trace((Object)("Style " + styleName + " added to layer " + destinationMapTable + ": " + addedStyle));
            boolean bl = addedStyle;
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            AnalysisLogger.getLogger().trace((Object)"Connection closed");
            this.connectionsManager.getGeoserverConnection().close();
        }
    }

    public static void main(String[] args) throws Exception {
        String cfgPath = "./cfg/";
        String algorithm = "kmeans";
        String tablename = "occcluster_" + algorithm;
        String workspace = "aquamaps";
        String datastore = "timeseriesgisdb";
        String clusterfield = "clusterid";
        String outlierfield = "outlier";
        String geonetworkurl = "http://geoserver-dev.d4science-ii.research-infrastructures.eu/geonetworks";
        String geonetworkuser = "admin";
        String geonetworkpwd = "admin";
        String gisdatastore = "timeseriesgisdb";
        String gispwd = "gcube@geo2010";
        String gisurl = "http://geoserver-dev.d4science-ii.research-infrastructures.eu/geoserver";
        String gisuser = "admin";
        String geodb = "jdbc:postgresql://geoserver-test.d4science-ii.research-infrastructures.eu/timeseriesgisdb";
        String geouser = "postgres";
        String geopwd = "d4science2";
        ClusterStylesGenerator csg = new ClusterStylesGenerator(cfgPath, geonetworkurl, gisurl, geonetworkuser, geonetworkpwd, gisuser, gispwd, geodb, geouser, geopwd, workspace, datastore);
        csg.generateStyleMap(algorithm, tablename, gisdatastore, tablename.replace("_", ""), clusterfield, outlierfield);
    }

    public static void main1(String[] args) throws Exception {
        String cfgPath = "./cfg/";
        String algorithm = "kmeans";
        String tablename = "occcluster_" + algorithm;
        String destinationMapTable = tablename.replace("_", "");
        String workspace = "aquamaps";
        String dataStore = "timeseriesgisdb";
        String styleName = "occurrencecluster10" + algorithm;
        String styleAttribute = "clusterid";
        AnalysisLogger.setLogger((String)(cfgPath + AlgorithmConfiguration.defaultLoggerFile));
        GISInformation gisInfo = new GISInformation();
        gisInfo.setGeoNetworkUrl("http://geoserver-dev.d4science-ii.research-infrastructures.eu/geonetworks");
        gisInfo.setGeoNetworkUserName("admin");
        gisInfo.setGeoNetworkPwd("admin");
        gisInfo.setGisDataStore("timeseriesgisdb");
        gisInfo.setGisPwd("gcube@geo2010");
        gisInfo.setGisWorkspace(workspace);
        gisInfo.setGisUrl("http://geoserver-dev.d4science-ii.research-infrastructures.eu/geoserver");
        gisInfo.setGisUserName("admin");
        TSGeoToolsConfiguration configuration = new TSGeoToolsConfiguration();
        configuration.setConfigPath(cfgPath);
        configuration.setGeoServerDatabase("jdbc:postgresql://geoserver-test.d4science-ii.research-infrastructures.eu/timeseriesgisdb");
        configuration.setGeoServerUserName("postgres");
        configuration.setGeoServerPassword("d4science2");
        configuration.setTimeSeriesDatabase("jdbc:postgresql://localhost/testdb");
        configuration.setTimeSeriesUserName("gcube");
        configuration.setTimeSeriesPassword("d4science2");
        ConnectionsManager connectionsManager = new ConnectionsManager(cfgPath);
        EngineConfiguration tscfg = null;
        if (configuration.getTimeSeriesDatabase() != null) {
            tscfg = new EngineConfiguration();
            tscfg.setConfigPath(cfgPath);
            tscfg.setDatabaseUserName(configuration.getTimeSeriesUserName());
            tscfg.setDatabasePassword(configuration.getTimeSeriesPassword());
            tscfg.setDatabaseURL(configuration.getTimeSeriesDatabase());
        }
        EngineConfiguration geocfg = null;
        if (configuration.getGeoServerDatabase() != null) {
            geocfg = new EngineConfiguration();
            geocfg.setConfigPath(cfgPath);
            geocfg.setDatabaseUserName(configuration.getGeoServerUserName());
            geocfg.setDatabasePassword(configuration.getGeoServerPassword());
            geocfg.setDatabaseURL(configuration.getGeoServerDatabase());
            AnalysisLogger.getLogger().trace((Object)"Create Points Map-> connected to Geo Server");
            connectionsManager.initGeoserverConnection(geocfg);
        }
        connectionsManager.initTimeSeriesConnection(tscfg);
        connectionsManager.initGeoserverConnection(geocfg);
        List pointsN = DatabaseFactory.executeSQLQuery((String)String.format("select count(*) from (select distinct " + styleAttribute + " from %1$s) as a", destinationMapTable), (SessionFactory)connectionsManager.getGeoserverConnection());
        int numberOfClusters = Integer.parseInt("" + pointsN.get(0));
        System.out.println("Number Of Clusters " + numberOfClusters);
        String style = MakeStyle.createStyleScatterColors((String)styleName, (String)styleAttribute, (int)numberOfClusters, Integer.class, (Object)(numberOfClusters - 1), (Object)0);
        style = style.replace("<sld:PolygonSymbolizer>", "<PointSymbolizer>             <Graphic>              <Mark>                <WellKnownName>square</WellKnownName>");
        style = style.replace("</sld:PolygonSymbolizer>", "</Mark>               <Size>6</Size>            </Graphic>          </PointSymbolizer>");
        AnalysisLogger.getLogger().trace((Object)"sending request to geoServer");
        GeoCaller gc = new GISOperations().getGeoCaller(gisInfo);
        ArrayList files = gc.listStyles();
        for (String filename : files) {
            if (!(filename = filename.trim()).equalsIgnoreCase(styleName)) continue;
            AnalysisLogger.getLogger().trace((Object)("deleting previous style " + styleName));
            boolean del = new GISOperations().deleteStyle(gisInfo, filename);
            Thread.sleep(5000L);
            AnalysisLogger.getLogger().trace((Object)("deleted " + del));
        }
        boolean toReturn = gc.sendStyleSDL(style);
        AnalysisLogger.getLogger().trace((Object)("sent request to geoServer " + toReturn));
        FeatureTypeRest ftr = gc.getFeatureType(workspace, dataStore, destinationMapTable);
        ArrayList<String> styles = new ArrayList<String>();
        styles.add(styleName);
        boolean addedStyle = gc.setLayer(ftr, styleName, styles);
        AnalysisLogger.getLogger().trace((Object)("layer added " + addedStyle));
    }

    public static String createStyleScatterColors(String nameStyle, String attributeName, int nClasses, Class typeValue, Object maxValue, Object minValue) throws Exception {
        if (nClasses <= 0) {
            throw new Exception("Invalid number of classes!!");
        }
        Double fMax = 0.0;
        Double fMin = 0.0;
        StyleBuilder sb = new StyleBuilder();
        Style style = sb.createStyle();
        style.setName(nameStyle);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (typeValue == Integer.class) {
            fMax = (double)((Integer)maxValue).intValue() * Double.valueOf(1.0);
            Integer iMax = fMax.intValue();
            fMin = (double)((Integer)minValue).intValue() * Double.valueOf(1.0);
            Integer iMin = fMin.intValue();
            Integer d = (iMax + 1 - iMin) / nClasses;
            if (d == 0) {
                throw new Exception("Too many classes with these values!!");
            }
            Integer start = iMin;
            int nColors = ClusterStylesGenerator.getColorsNumbers(start, iMax, d);
            ArrayList colors = MakeStyle.scatterColor((int)nColors);
            if (d == 1) {
                int color = 0;
                while (start <= iMax) {
                    rules.add(ClusterStylesGenerator.addRule(sb, attributeName, start, (Color)colors.get(color)));
                    start = start + d;
                    ++color;
                }
            } else {
                int color = 0;
                while (start <= iMax) {
                    if (start == iMax) {
                        rules.add(ClusterStylesGenerator.addRule(sb, attributeName, start, (Color)colors.get(color)));
                    } else {
                        rules.add(ClusterStylesGenerator.addRule(sb, attributeName, start + d, start, (Color)colors.get(color)));
                    }
                    start = start + d;
                    ++color;
                }
            }
        } else if (typeValue == Boolean.class) {
            Color c1 = Color.red;
            rules.add(ClusterStylesGenerator.addRule(sb, attributeName, "true", c1));
        }
        FeatureTypeStyle fts = sb.createFeatureTypeStyle("Feature", rules.toArray(new Rule[rules.size()]));
        style.featureTypeStyles().add(fts);
        SLDTransformer aTransformer = new SLDTransformer();
        aTransformer.setIndentation(4);
        String out = aTransformer.transform((Object)style);
        Logger.debug((String)"Style String created!");
        return out;
    }

    private static int getColorsNumbers(Integer start, Integer iMax, Integer d) {
        int color = 0;
        while (start <= iMax) {
            start = start + d;
            ++color;
        }
        return color;
    }

    public static Rule addRule(StyleBuilder sb, String attributeName, Object equal, Color fillColor) {
        PolygonSymbolizer polygonSymbolizer = sb.createPolygonSymbolizer(fillColor);
        Rule rule = sb.createRule((Symbolizer)polygonSymbolizer);
        if (equal instanceof Double) {
            equal = MakeStyle.roundDecimal((double)((Double)equal), (int)2);
        }
        rule.setTitle("=" + equal);
        FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2(null);
        PropertyIsEqualTo filter = filterFactory.equal((Expression)filterFactory.property(attributeName), (Expression)filterFactory.literal(equal), true);
        rule.setFilter((Filter)filter);
        return rule;
    }

    private static Rule addRule(StyleBuilder sb, String attributeName, Object lessThe, Object greater, Color fillColor) {
        PolygonSymbolizer polygonSymbolizer = sb.createPolygonSymbolizer(fillColor);
        Rule rule = sb.createRule((Symbolizer)polygonSymbolizer);
        if (greater instanceof Double || greater instanceof Float) {
            greater = MakeStyle.roundDecimal((double)((Number)greater).doubleValue(), (int)2);
        }
        if (lessThe instanceof Double || lessThe instanceof Float) {
            lessThe = MakeStyle.roundDecimal((double)((Number)lessThe).doubleValue(), (int)2);
        }
        rule.setTitle(">= " + greater + " - < " + lessThe);
        FilterFactory2 filterFactory = CommonFactoryFinder.getFilterFactory2(null);
        PropertyIsGreaterThanOrEqualTo filterThen = filterFactory.greaterOrEqual((Expression)filterFactory.property(attributeName), (Expression)filterFactory.literal(greater), true);
        PropertyIsLessThan filterElse = filterFactory.less((Expression)filterFactory.property(attributeName), (Expression)filterFactory.literal(lessThe));
        And filter = filterFactory.and((Filter)filterThen, (Filter)filterElse);
        rule.setFilter((Filter)filter);
        return rule;
    }
}

